/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.compiler.task.TodoTask;
import org.eclipse.dltk.compiler.task.TodoTaskPreferences;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.preferences.TodoTaskInputDialog;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TodoTaskConfigurationBlock
extends AbstractConfigurationBlock {
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private ListDialogField fTodoTasksList;
    private Button fCaseSensitiveCheckbox;
    private final TodoTaskPreferences preferences;

    public TodoTaskConfigurationBlock(Preferences preferences, OverlayPreferenceStore store, PreferencePage mainPreferencePage) {
        super(store, mainPreferencePage);
        this.preferences = new TodoTaskPreferences(preferences);
        store.addKeys(this.createKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createKeys() {
        return new OverlayPreferenceStore.OverlayKey[]{new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "org.eclipse.dltk.coretasks.tags"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.dltk.coretasks.enabled"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.dltk.coretasks.case_sensitive")};
    }

    protected final void updateModel(DialogField field) {
        this.preferences.setTaskTags(this.fTodoTasksList.getElements());
    }

    private void doTodoButtonPressed(int index) {
        TodoTaskInputDialog dialog;
        TodoTask edited = null;
        if (index != 0) {
            edited = (TodoTask)this.fTodoTasksList.getSelectedElements().get(0);
        }
        if ((index == 0 || index == 1) && (dialog = new TodoTaskInputDialog(this.getShell(), edited, this.fTodoTasksList.getElements())).open() == 0) {
            if (edited != null) {
                this.fTodoTasksList.replaceElement(edited, dialog.getResult());
            } else {
                this.fTodoTasksList.addElement(dialog.getResult());
            }
        }
    }

    @Override
    public Control createControl(Composite parent) {
        TaskTagAdapter adapter = new TaskTagAdapter();
        String[] buttons = new String[]{PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_add_button, PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_edit_button, PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_remove_button};
        this.fTodoTasksList = new ListDialogField(adapter, buttons, (ILabelProvider)new TodoTaskLabelProvider());
        this.fTodoTasksList.setDialogFieldListener(adapter);
        this.fTodoTasksList.setRemoveButtonIndex(2);
        String[] columnsHeaders = new String[]{PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_name_column, PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_priority_column};
        this.fTodoTasksList.setTableColumns(new ListDialogField.ColumnsDescription(columnsHeaders, true));
        this.fTodoTasksList.setViewerSorter(new TodoTaskSorter());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        PixelConverter conv = new PixelConverter((Control)parent);
        Composite markersComposite = new Composite(parent, 0);
        markersComposite.setLayout((Layout)layout);
        markersComposite.setFont(parent.getFont());
        Button enableCheckbox = this.addCheckBox(markersComposite, PreferencesMessages.TodoTaskConfigurationBlock_enableTaskTags, "org.eclipse.dltk.coretasks.enabled", 0);
        this.fCaseSensitiveCheckbox = this.addCheckBox(markersComposite, PreferencesMessages.TodoTaskConfigurationBlock_casesensitive_label, "org.eclipse.dltk.coretasks.case_sensitive", 0);
        GridData data = new GridData(1808);
        data.widthHint = conv.convertWidthInCharsToPixels(50);
        this.fTodoTasksList.getListControl(markersComposite).setLayoutData((Object)data);
        this.fTodoTasksList.getButtonBox(markersComposite).setLayoutData((Object)new GridData(258));
        enableCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.widget).getSelection();
                TodoTaskConfigurationBlock.this.updateEnableState(enabled);
            }
        });
        return markersComposite;
    }

    protected void updateEnableState(boolean enabled) {
        this.fTodoTasksList.setEnabled(enabled);
        this.fCaseSensitiveCheckbox.setEnabled(enabled);
    }

    @Override
    protected void initializeFields() {
        super.initializeFields();
        this.fTodoTasksList.setElements(this.preferences.getTaskTags());
        if (this.fTodoTasksList.getSize() > 0) {
            this.fTodoTasksList.selectFirstElement();
        } else {
            this.fTodoTasksList.enableButton(1, false);
        }
        this.updateEnableState(this.preferences.isEnabled());
    }

    public class TaskTagAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private boolean canEdit(List selectedElements) {
            return selectedElements.size() == 1;
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
            TodoTaskConfigurationBlock.this.doTodoButtonPressed(index);
        }

        @Override
        public void selectionChanged(ListDialogField field) {
            List selectedElements = field.getSelectedElements();
            field.enableButton(1, this.canEdit(selectedElements));
        }

        @Override
        public void doubleClicked(ListDialogField field) {
            if (this.canEdit(field.getSelectedElements())) {
                TodoTaskConfigurationBlock.this.doTodoButtonPressed(1);
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            TodoTaskConfigurationBlock.this.updateModel(field);
        }
    }

    private class TodoTaskLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TodoTaskLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TodoTask task = (TodoTask)element;
            if (columnIndex == 0) {
                return task.name;
            }
            if ("HIGH".equals(task.priority)) {
                return PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_high_priority;
            }
            if ("NORMAL".equals(task.priority)) {
                return PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_normal_priority;
            }
            if ("LOW".equals(task.priority)) {
                return PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_low_priority;
            }
            return "";
        }
    }

    private static class TodoTaskSorter
    extends ViewerSorter {
        private TodoTaskSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.getComparator().compare(((TodoTask)e1).name, ((TodoTask)e2).name);
        }
    }
}

