/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index2;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.index2.AbstractIndexer;
import org.eclipse.dltk.core.index2.IIndexer;
import org.eclipse.dltk.core.index2.IIndexerParticipant;

public class IndexerManager {
    private static final String PARTICIPANT_POINT = "org.eclipse.dltk.core.indexerParticipant";
    private static final String INDEXER_POINT = "org.eclipse.dltk.core.indexer";
    private static final String INDEXER_ATTR = "indexer";
    private static final String PARTICIPANT_ELEMENT = "indexerParticipant";
    private static final String CLASS_ATTR = "class";
    private static final String NATURE_ATTR = "nature";
    private static final String ID_ATTR = "id";
    private static final String TARGET_ID_ATTR = "targetId";
    private static IConfigurationElement indexer;
    private static Map<String, Map<String, IConfigurationElement>> indexerParticipants;

    static {
        String name;
        IConfigurationElement element;
        IConfigurationElement[] elements;
        indexerParticipants = new HashMap<String, Map<String, IConfigurationElement>>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(INDEXER_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            name = element.getName();
            if (INDEXER_ATTR.equals(name)) {
                indexer = element;
                break;
            }
            ++n2;
        }
        iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PARTICIPANT_POINT);
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            name = element.getName();
            if (PARTICIPANT_ELEMENT.equals(name)) {
                String targetId = element.getAttribute(TARGET_ID_ATTR);
                String nature = element.getAttribute(NATURE_ATTR);
                if (!indexerParticipants.containsKey(targetId)) {
                    indexerParticipants.put(targetId, new HashMap());
                }
                indexerParticipants.get(targetId).put(nature, element);
            }
            ++n2;
        }
    }

    public static IIndexer getIndexer() {
        try {
            if (indexer != null) {
                AbstractIndexer instance = (AbstractIndexer)indexer.createExecutableExtension(CLASS_ATTR);
                instance.setId(indexer.getAttribute(ID_ATTR));
                return instance;
            }
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            indexer = null;
        }
        return null;
    }

    public static IIndexerParticipant getIndexerParticipant(IIndexer indexer, String natureId) {
        block3: {
            IConfigurationElement element;
            Map<String, IConfigurationElement> participants = indexerParticipants.get(((AbstractIndexer)indexer).getId());
            if (participants != null && (element = participants.get(natureId)) != null) {
                try {
                    return (IIndexerParticipant)element.createExecutableExtension(CLASS_ATTR);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

