/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.keyword;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.keyword.IKeywordCategory;
import org.eclipse.dltk.core.keyword.IKeywordProvider;
import org.eclipse.dltk.utils.LazyExtensionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordManager
extends LazyExtensionManager<IKeywordProvider> {
    private final String natureId;

    public KeywordManager(String natureId) {
        super("org.eclipse.dltk.core.keywords");
        this.natureId = natureId;
    }

    @Override
    protected LazyExtensionManager.Descriptor<IKeywordProvider> createDescriptor(IConfigurationElement confElement) {
        if (!this.natureId.equals(confElement.getAttribute("nature"))) {
            return null;
        }
        return super.createDescriptor(confElement);
    }

    public String[] getKeywords(IKeywordCategory category, ISourceModule module) {
        ArrayList result = new ArrayList();
        for (IKeywordProvider provider : this) {
            String[] keywords = provider.getKeywords(category, module);
            if (keywords == null) continue;
            Collections.addAll(result, keywords);
        }
        return result.toArray(new String[result.size()]);
    }
}

