/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.docs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IShutdownListener;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallChangedListener;
import org.eclipse.dltk.launching.PropertyChangeEvent;
import org.eclipse.dltk.launching.ScriptLaunchUtil;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ruby.internal.ui.RubyUI;
import org.eclipse.dltk.ruby.internal.ui.docs.Watchdog;
import org.eclipse.dltk.ruby.internal.ui.docs.WatchdogListener;
import org.eclipse.dltk.ui.DLTKUIPlugin;

public class RiHelper {
    private static final String DOC_TERMINATION_LINE = "DLTKDOCEND";
    private static final long TERMINATE_WAIT_TIMEOUT = 2000L;
    private static RiHelper instance;
    private WeakHashMap cache = new WeakHashMap();
    private Process riProcess;
    private OutputStreamWriter writer;
    private BufferedReader reader;
    private BufferedReader errorReader;
    private IDeployment deployment;

    public static synchronized RiHelper getInstance() {
        if (instance == null) {
            instance = new RiHelper();
        }
        return instance;
    }

    protected static boolean isTerminated(Process riProcess) {
        try {
            riProcess.exitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }

    protected synchronized void runRiProcess() throws CoreException, IOException {
        IInterpreterInstall install = ScriptLaunchUtil.getDefaultInterpreterInstall((String)"org.eclipse.dltk.ruby.core.nature", (String)"org.eclipse.dltk.core.environment.localEnvironment");
        if (install == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IEnvironment env = install.getEnvironment();
        IExecutionEnvironment exeEnv = (IExecutionEnvironment)env.getAdapter(IExecutionEnvironment.class);
        this.deployment = exeEnv.createDeployment();
        if (this.deployment == null) {
            return;
        }
        IPath path = this.deployment.add(RubyUI.getDefault().getBundle(), "support/dltkri.rb");
        IFileHandle script = this.deployment.getFile(path);
        this.riProcess = ScriptLaunchUtil.runScriptWithInterpreter((IExecutionEnvironment)exeEnv, (String)install.getInstallLocation().toOSString(), (IFileHandle)script, null, null, null, (EnvironmentVariable[])install.getEnvironmentVariables());
        this.writer = new OutputStreamWriter(this.riProcess.getOutputStream());
        this.reader = new BufferedReader(new InputStreamReader(this.riProcess.getInputStream()));
        this.errorReader = new BufferedReader(new InputStreamReader(this.riProcess.getErrorStream()));
    }

    protected synchronized void destroyRiProcess() {
        if (this.writer != null) {
            RiHelper.closeQuietly(this.writer);
            this.writer = null;
        }
        if (this.reader != null) {
            this.closeQuietly(this.reader);
            this.reader = null;
        }
        if (this.errorReader != null) {
            this.closeQuietly(this.errorReader);
            this.errorReader = null;
        }
        if (this.riProcess != null) {
            try {
                Watchdog watchdog = new Watchdog(2000L);
                watchdog.addListener(new WatchdogListener(){

                    public void timeoutOccured() {
                        RiHelper.this.riProcess.destroy();
                    }
                });
                watchdog.start();
                try {
                    this.riProcess.waitFor();
                }
                finally {
                    watchdog.stop();
                }
            }
            catch (InterruptedException interruptedException) {}
            this.riProcess.destroy();
            this.riProcess = null;
        }
        if (this.deployment != null) {
            this.deployment.dispose();
            this.deployment = null;
        }
        this.cache.clear();
    }

    private void closeQuietly(Reader r) {
        try {
            r.close();
        }
        catch (IOException iOException) {}
    }

    private static void closeQuietly(Writer w) {
        try {
            w.close();
        }
        catch (IOException iOException) {}
    }

    protected String readStderr() throws IOException {
        StringBuffer sb = new StringBuffer();
        String errorLine = null;
        while ((errorLine = this.errorReader.readLine()) != null) {
            sb.append(errorLine);
            sb.append("\n");
        }
        String error = sb.toString().trim();
        return error.length() > 0 ? error : null;
    }

    protected String readStdout() throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        while ((line = this.reader.readLine()) != null && !line.equals(DOC_TERMINATION_LINE)) {
            sb.append(line);
            sb.append('\n');
        }
        return sb.toString();
    }

    protected String loadRiDoc(String keyword) throws IOException {
        this.writer.write(String.valueOf(keyword) + "\n");
        this.writer.flush();
        return this.readStdout();
    }

    private boolean checkRiProcess() {
        if (this.riProcess == null || RiHelper.isTerminated(this.riProcess)) {
            try {
                this.runRiProcess();
            }
            catch (Exception e) {
                DLTKUIPlugin.logErrorMessage((String)"Error starting RiHelper", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected RiHelper() {
        ScriptRuntime.addInterpreterInstallChangedListener((IInterpreterInstallChangedListener)new IInterpreterInstallChangedListener(){

            public void defaultInterpreterInstallChanged(IInterpreterInstall previous, IInterpreterInstall current) {
                RiHelper.this.destroyRiProcess();
            }

            public void interpreterAdded(IInterpreterInstall Interpreter) {
            }

            public void interpreterChanged(PropertyChangeEvent event) {
            }

            public void interpreterRemoved(IInterpreterInstall Interpreter) {
            }
        });
        RubyUI.getDefault().addShutdownListener(new IShutdownListener(){

            public void shutdown() {
                RiHelper.this.destroyRiProcess();
            }
        });
    }

    public synchronized String getDocFor(String keyword) {
        String doc = (String)this.cache.get(keyword);
        if (doc == null && this.checkRiProcess()) {
            try {
                doc = this.loadRiDoc(keyword);
                this.cache.put(keyword, doc);
            }
            catch (IOException iOException) {
                this.destroyRiProcess();
            }
        }
        return doc;
    }
}

