# Commands covered:  various
#
# This file contains a collection of miscellaneous Tcl tests that
# don't fit naturally in any of the other test files.  Many of these
# tests are pathological cases that caused bugs in earlier Tcl
# releases.
#
# Copyright (c) 1992-1993 The Regents of the University of California.
# Copyright (c) 1994-1996 Sun Microsystems, Inc.
# Copyright (c) 1998-1999 by Scriptics Corporation.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# RCS: @(#) $Id: misc.tcl,v 1.1 2006/12/29 09:02:53 fourdman Exp $

if {[lsearch [namespace children] ::tcltest] == -1} {
    package require tcltest
    namespace import -force ::tcltest::*
}

test misc-1.1 {error in variable ref. in command in array reference} {
    proc tstProc {} {
	global a
    
	set tst $a([winfo name $zz])
	# this is a bogus comment
	# this is a bogus comment
	# this is a bogus comment
	# this is a bogus comment
	# this is a bogus comment
	# this is a bogus comment
	# this is a bogus comment
	# this is a bogus comment
    }
    set msg {}
    list [catch tstProc msg] $msg
} {1 {can't read "zz": no such variable}}
test misc-1.2 {error in variable ref. in command in array reference} {
    proc tstProc {} "
	global a
    
	set tst \$a(\[winfo name \$\{zz)
	# this is a bogus comment
	# this is a bogus comment
	# this is a bogus comment
	# this is a bogus comment
	# this is a bogus comment
	# this is a bogus comment
	# this is a bogus comment
	# this is a bogus comment
    "
    set msg {}
    join [list [catch tstProc msg] $msg $errorInfo] \n
} [subst -novariables -nocommands {1
missing close-brace for variable name
missing close-brace for variable name
    while compiling
"set tst $a([winfo name $\{zz)
	# this is a bogus comment
	# this is a bogus comment
	# this is a bogus comment
	# this is a bogus comment
	# this is a ..."
    (compiling body of proc "tstProc", line 4)
    invoked from within
"tstProc"}]

# cleanup
::tcltest::cleanupTests
return












