/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.actions.OpenAction;
import org.eclipse.dltk.ui.infoviews.ModelElementArray;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.util.NLS;

public class ModelElementHyperlink
implements IHyperlink {
    private final IRegion fRegion;
    private final OpenAction fOpenAction;
    private final Object selection;
    private final long TITLE_FLAGS = ScriptElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;

    public ModelElementHyperlink(IRegion region, Object selection, OpenAction openAction) {
        Assert.isNotNull((Object)((Object)openAction));
        Assert.isNotNull((Object)region);
        this.fRegion = region;
        this.fOpenAction = openAction;
        this.selection = selection;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        if (this.selection instanceof IModelElement) {
            this.fOpenAction.run(new Object[]{this.selection});
        } else if (this.selection instanceof ModelElementArray) {
            this.fOpenAction.selectAndOpen(((ModelElementArray)this.selection).getElements());
        }
    }

    public String getTypeLabel() {
        return DLTKEditorMessages.ModelElementHyperlink_typeLabel;
    }

    public String getHyperlinkText() {
        String text;
        if (this.selection instanceof IModelElement) {
            IModelElement me = (IModelElement)this.selection;
            text = ScriptElementLabels.getDefault().getElementLabel(me, this.TITLE_FLAGS);
        } else if (this.selection instanceof ModelElementArray) {
            ModelElementArray array = (ModelElementArray)this.selection;
            text = array.getContentDescription();
        } else {
            return DLTKEditorMessages.ModelElementHyperlink_defaultText;
        }
        return NLS.bind((String)DLTKEditorMessages.ModelElementHyperlink_text, (Object)text);
    }
}

