/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.buildpath;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.ArchiveFileFilter;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementAttribute;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildPathBasePage;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.BuildpathModifierQueries;

public class BuildpathModifier {
    private IBuildpathModifierListener fListener;

    public BuildpathModifier() {
        this(null);
    }

    protected BuildpathModifier(IBuildpathModifierListener listener) {
        this.fListener = listener;
    }

    protected List createLinkedSourceFolder(BuildpathModifierQueries.ILinkToQuery query, IScriptProject project, IProgressMonitor monitor) throws CoreException {
        IFolder folder;
        if (query.doQuery() && (folder = query.getCreatedFolder()) != null) {
            ArrayList<IFolder> folderList = new ArrayList<IFolder>();
            folderList.add(folder);
            List root = this.addToBuildpath(folderList, project, monitor);
            if (root.size() == 0) {
                folder.delete(false, null);
            }
            return root;
        }
        return new ArrayList();
    }

    protected List createFolder(BuildpathModifierQueries.ICreateFolderQuery folderQuery, IScriptProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        IFolder folder;
        if (folderQuery.doQuery() && (folder = folderQuery.getCreatedFolder()) != null) {
            ArrayList<IFolder> folderList = new ArrayList<IFolder>();
            folderList.add(folder);
            if (folderQuery.isSourceFolder()) {
                List root = this.addToBuildpath(folderList, project, monitor);
                if (root.size() == 0) {
                    folder.delete(false, null);
                }
                return root;
            }
            List entries = BuildpathModifier.getExistingEntries(project);
            BuildpathModifier.exclude(folder.getFullPath(), entries, new ArrayList(), project, monitor);
            this.updateBuildpath(entries, project, null);
            return folderList;
        }
        return new ArrayList();
    }

    protected List addToBuildpath(List elements, IScriptProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_AddToBuildpath, 2 * elements.size() + 3);
            if (DLTKLanguageManager.hasScriptNature((IProject)project.getProject())) {
                List existingEntries = BuildpathModifier.getExistingEntries(project);
                ArrayList<BPListElement> newEntries = new ArrayList<BPListElement>();
                int i = 0;
                while (i < elements.size()) {
                    Object element = elements.get(i);
                    BPListElement entry = element instanceof IResource ? BuildpathModifier.addToBuildpath((IResource)element, existingEntries, newEntries, project, monitor) : BuildpathModifier.addToBuildpath((IModelElement)element, existingEntries, newEntries, project, monitor);
                    newEntries.add(entry);
                    ++i;
                }
                HashSet modifiedSourceEntries = new HashSet();
                BuildPathBasePage.fixNestingConflicts(newEntries.toArray(new BPListElement[newEntries.size()]), existingEntries.toArray(new BPListElement[existingEntries.size()]), modifiedSourceEntries);
                BuildpathModifier.setNewEntry(existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.updateBuildpath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ArrayList<IScriptProject> result = new ArrayList<IScriptProject>();
                int i2 = 0;
                while (i2 < newEntries.size()) {
                    IBuildpathEntry entry = ((BPListElement)newEntries.get(i2)).getBuildpathEntry();
                    Object root = entry.getPath().equals((Object)project.getPath()) ? project : project.findProjectFragment(entry.getPath());
                    if (root != null) {
                        result.add((IScriptProject)root);
                    }
                    ++i2;
                }
                ArrayList<IScriptProject> arrayList = result;
                return arrayList;
            }
            StatusInfo rootStatus = new StatusInfo();
            rootStatus.setError(NewWizardMessages.BuildpathModifier_Error_NoNatures);
            throw new CoreException((IStatus)rootStatus);
        }
        finally {
            monitor.done();
        }
    }

    protected List addExternalArchives(BuildpathModifierQueries.IAddArchivesQuery query, IScriptProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IPath[] selected = query.doQuery();
        ArrayList<BPListElement> addedEntries = new ArrayList<BPListElement>();
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_AddToBuildpath, 4);
            if (selected != null) {
                int i = 0;
                while (i < selected.length) {
                    addedEntries.add(new BPListElement(project, 1, selected[i], null, false));
                    ++i;
                }
                monitor.worked(1);
                List existingEntries = BuildpathModifier.getExistingEntries(project);
                BuildpathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.updateBuildpath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ArrayList<IProjectFragment> result = new ArrayList<IProjectFragment>(addedEntries.size());
                int i2 = 0;
                while (i2 < addedEntries.size()) {
                    IBuildpathEntry entry = ((BPListElement)addedEntries.get(i2)).getBuildpathEntry();
                    IProjectFragment elem = project.findProjectFragment(entry.getPath());
                    if (elem != null) {
                        result.add(elem);
                    }
                    ++i2;
                }
                monitor.worked(1);
                ArrayList<IProjectFragment> arrayList = result;
                return arrayList;
            }
        }
        finally {
            monitor.done();
        }
        return new ArrayList();
    }

    protected List addLibraries(BuildpathModifierQueries.IAddLibrariesQuery query, IScriptProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IBuildpathEntry[] selected = query.doQuery(project, project.getRawBuildpath());
        ArrayList<BPListElement> addedEntries = new ArrayList<BPListElement>();
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_AddToBuildpath, 4);
            if (selected != null) {
                int i = 0;
                while (i < selected.length) {
                    addedEntries.add(new BPListElement(project, 5, selected[i].getPath(), null, false));
                    ++i;
                }
                monitor.worked(1);
                List existingEntries = BuildpathModifier.getExistingEntries(project);
                BuildpathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.updateBuildpath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ArrayList<BuildPathContainer> result = new ArrayList<BuildPathContainer>(addedEntries.size());
                int i2 = 0;
                while (i2 < addedEntries.size()) {
                    result.add(new BuildPathContainer(project, selected[i2]));
                    ++i2;
                }
                monitor.worked(1);
                ArrayList<BuildPathContainer> arrayList = result;
                return arrayList;
            }
        }
        finally {
            monitor.done();
        }
        return new ArrayList();
    }

    protected List addLibraryEntries(List resources, IScriptProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<BPListElement> addedEntries = new ArrayList<BPListElement>();
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_AddToBuildpath, 4);
            int i = 0;
            while (i < resources.size()) {
                IResource res = (IResource)resources.get(i);
                addedEntries.add(new BPListElement(project, 1, res.getFullPath(), res, false));
                ++i;
            }
            monitor.worked(1);
            List existingEntries = BuildpathModifier.getExistingEntries(project);
            BuildpathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.updateBuildpath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList<IProjectFragment> result = new ArrayList<IProjectFragment>(addedEntries.size());
            int i2 = 0;
            while (i2 < resources.size()) {
                IResource res = (IResource)resources.get(i2);
                IProjectFragment elem = project.getProjectFragment(res);
                if (elem != null) {
                    result.add(elem);
                }
                ++i2;
            }
            monitor.worked(1);
            ArrayList<IProjectFragment> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    protected List removeFromBuildpath(BuildpathModifierQueries.IRemoveLinkedFolderQuery query, List elements, IScriptProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_RemoveFromBuildpath, elements.size() + 1);
            List existingEntries = BuildpathModifier.getExistingEntries(project);
            ArrayList<IScriptProject> resultElements = new ArrayList<IScriptProject>();
            boolean archiveRemoved = false;
            int i = 0;
            while (i < elements.size()) {
                Object element = elements.get(i);
                IScriptProject res = null;
                if (element instanceof IScriptProject) {
                    res = BuildpathModifier.removeFromBuildpath(project, existingEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else if (element instanceof IProjectFragment) {
                    IProjectFragment root = (IProjectFragment)element;
                    if (root.getKind() == 3) {
                        archiveRemoved = true;
                        res = BuildpathModifier.removeFromBuildpath(root, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        IResource resource = root.getCorrespondingResource();
                        if (resource instanceof IFolder) {
                            IFolder folder = (IFolder)resource;
                            if (folder.isLinked()) {
                                int result = query.doQuery(folder);
                                if (result != 0) {
                                    if (result == 1) {
                                        res = BuildpathModifier.removeFromBuildpath(root, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    } else if (result == 2) {
                                        res = BuildpathModifier.removeFromBuildpath(root, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                        folder.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    }
                                }
                            } else {
                                res = BuildpathModifier.removeFromBuildpath(root, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                        } else {
                            res = BuildpathModifier.removeFromBuildpath(root, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                } else {
                    archiveRemoved = true;
                    BuildPathContainer container = (BuildPathContainer)element;
                    existingEntries.remove(BPListElement.createFromExisting(container.getBuildpathEntry(), project));
                }
                if (res != null) {
                    resultElements.add(res);
                }
                ++i;
            }
            this.updateBuildpath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fireEvent(existingEntries);
            if (archiveRemoved && resultElements.size() == 0) {
                resultElements.add(project);
            }
            ArrayList<IScriptProject> arrayList = resultElements;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    protected List include(List elements, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            List scriptElements;
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_Including, 2 * elements.size());
            List existingEntries = BuildpathModifier.getExistingEntries(project);
            ArrayList<IResource> resources = new ArrayList<IResource>();
            int i = 0;
            while (i < elements.size()) {
                IResource resource;
                if (elements.get(i) instanceof IResource) {
                    resource = (IResource)elements.get(i);
                } else {
                    IModelElement elem = (IModelElement)elements.get(i);
                    resource = elem.getResource();
                }
                resources.add(resource);
                IProjectFragment root = BuildpathModifier.getFragmentRoot(resource, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (root != null) {
                    BPListElement entry = BuildpathModifier.getBuildpathEntry(existingEntries, root);
                    this.include(resource, entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ++i;
            }
            this.updateBuildpath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            List list = scriptElements = BuildpathModifier.getCorrespondingElements(resources, project);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    protected List exclude(List scriptElements, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_Excluding, scriptElements.size() + 4);
            List existingEntries = BuildpathModifier.getExistingEntries(project);
            ArrayList<IResource> resources = new ArrayList<IResource>();
            int i = 0;
            while (i < scriptElements.size()) {
                IProjectFragment root;
                BPListElement entry;
                IModelElement scriptElement = (IModelElement)scriptElements.get(i);
                IResource resource = BuildpathModifier.exclude(scriptElement, entry = BuildpathModifier.getBuildpathEntry(existingEntries, root = (IProjectFragment)scriptElement.getAncestor(3)), project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (resource != null) {
                    resources.add(resource);
                }
                ++i;
            }
            this.updateBuildpath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            ArrayList<IResource> arrayList = resources;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    protected List unInclude(List scriptElements, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            List result;
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_RemoveInclusion, 10);
            List existingEntries = BuildpathModifier.getExistingEntries(project);
            int i = 0;
            while (i < scriptElements.size()) {
                IModelElement scriptElement = (IModelElement)scriptElements.get(i);
                IProjectFragment root = (IProjectFragment)scriptElement.getAncestor(3);
                BPListElement entry = BuildpathModifier.getBuildpathEntry(existingEntries, root);
                this.unInclude(scriptElement, entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
            this.updateBuildpath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            List list = result = BuildpathModifier.getCorrespondingElements(scriptElements, project);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    protected List unExclude(List elements, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            List resultElements;
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_Including, 2 * elements.size());
            List entries = BuildpathModifier.getExistingEntries(project);
            int i = 0;
            while (i < elements.size()) {
                IResource resource = (IResource)elements.get(i);
                IProjectFragment root = BuildpathModifier.getFragmentRoot(resource, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (root != null) {
                    BPListElement entry = BuildpathModifier.getBuildpathEntry(entries, root);
                    BuildpathModifier.unExclude(resource, entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ++i;
            }
            this.updateBuildpath(entries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            List list = resultElements = BuildpathModifier.getCorrespondingElements(elements, project);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    protected IModelElement editFilters(IModelElement element, IScriptProject project, BuildpathModifierQueries.IInclusionExclusionQuery query, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_EditInclusionExclusionFilters, 4);
            List existingEntries = BuildpathModifier.getExistingEntries(project);
            BPListElement entry = BuildpathModifier.getListElement(element.getPath(), existingEntries);
            if (entry != null && query.doQuery(entry, false)) {
                entry.setAttribute("inclusion", query.getInclusionPattern());
                entry.setAttribute("exclusion", query.getExclusionPattern());
                this.updateBuildpath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                IModelElement iModelElement = element;
                return iModelElement;
            }
        }
        finally {
            monitor.done();
        }
        return null;
    }

    protected List reset(List elements, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_Resetting, elements.size());
            List entries = BuildpathModifier.getExistingEntries(project);
            ArrayList<IModelElement> result = new ArrayList<IModelElement>();
            int i = 0;
            while (i < elements.size()) {
                Object element = elements.get(i);
                if (element instanceof IModelElement) {
                    IModelElement scriptElement = (IModelElement)element;
                    IProjectFragment root = element instanceof IScriptProject ? project.getProjectFragment(project.getResource()) : (IProjectFragment)element;
                    BPListElement entry = BuildpathModifier.getBuildpathEntry(entries, root);
                    this.resetFilters(scriptElement, entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    result.add(scriptElement);
                }
                ++i;
            }
            this.updateBuildpath(entries, project, null);
            this.fireEvent(entries);
            ArrayList<IModelElement> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    public static List getExistingEntries(IScriptProject project) throws ModelException {
        IBuildpathEntry[] buildpathEntries = project.getRawBuildpath();
        ArrayList<BPListElement> newBuildPath = new ArrayList<BPListElement>();
        int i = 0;
        while (i < buildpathEntries.length) {
            IBuildpathEntry curr = buildpathEntries[i];
            newBuildPath.add(BPListElement.createFromExisting(curr, project));
            ++i;
        }
        return newBuildPath;
    }

    public static BPListElement getBuildpathEntry(List elements, IProjectFragment root) throws ModelException {
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        int i = 0;
        while (i < elements.size()) {
            BPListElement element = (BPListElement)elements.get(i);
            if (element.getPath().equals((Object)root.getPath()) && element.getEntryKind() == entry.getEntryKind()) {
                return (BPListElement)elements.get(i);
            }
            ++i;
        }
        BPListElement newElement = BPListElement.createFromExisting(entry, root.getScriptProject());
        elements.add(newElement);
        return newElement;
    }

    public static IScriptFolder getFragment(IResource resource) {
        IModelElement elem = DLTKCore.create((IResource)resource);
        if (elem instanceof IScriptFolder) {
            return (IScriptFolder)elem;
        }
        return null;
    }

    public static IProjectFragment getFragmentRoot(IResource resource, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IModelElement scriptElem = null;
        if (resource.getFullPath().equals((Object)project.getPath())) {
            return project.getProjectFragment(resource);
        }
        IContainer container = resource.getParent();
        do {
            if (container instanceof IFolder) {
                scriptElem = DLTKCore.create((IResource)container);
            }
            if (container.getFullPath().equals((Object)project.getPath())) {
                scriptElem = project;
                break;
            }
            if ((container = container.getParent()) != null) continue;
            return null;
        } while (scriptElem == null || !(scriptElem instanceof IProjectFragment));
        if (scriptElem instanceof IScriptProject) {
            if (!BuildpathModifier.isSourceFolder((IScriptProject)scriptElem)) {
                return null;
            }
            scriptElem = project.getProjectFragment(project.getResource());
        }
        return (IProjectFragment)scriptElem;
    }

    public static IBuildpathEntry getBuildpathEntryFor(IPath path, IScriptProject project, int entryKind) throws ModelException {
        IBuildpathEntry[] entries = project.getRawBuildpath();
        int i = 0;
        while (i < entries.length) {
            IBuildpathEntry entry = entries[i];
            if (entry.getPath().equals((Object)path) && BuildpathModifier.equalEntryKind(entry, entryKind)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public static boolean isDefaultOutputFolder(BPListElementAttribute attrib) {
        return attrib.getValue() == null;
    }

    public static boolean isIncluded(IModelElement selection, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_ContainsPath, 4);
            IProjectFragment root = (IProjectFragment)selection.getAncestor(3);
            IBuildpathEntry entry = root.getRawBuildpathEntry();
            if (entry == null) {
                return false;
            }
            boolean bl = BuildpathModifier.contains(selection.getPath().removeFirstSegments(root.getPath().segmentCount()), entry.getInclusionPatterns(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    public static boolean isExcluded(IResource resource, IScriptProject project) throws ModelException {
        IProjectFragment root = BuildpathModifier.getFragmentRoot(resource, project, null);
        if (root == null) {
            return false;
        }
        String fragmentName = BuildpathModifier.getName(resource.getFullPath(), root.getPath());
        fragmentName = BuildpathModifier.completeName(project, fragmentName);
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        return entry != null && BuildpathModifier.contains((IPath)new Path(fragmentName), entry.getExclusionPatterns(), null);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean parentExcluded(IResource resource, IScriptProject project) throws ModelException {
        if (resource.getFullPath().equals((Object)project.getPath())) {
            return false;
        }
        root = BuildpathModifier.getFragmentRoot(resource, project, null);
        if (root == null) {
            return true;
        }
        path = resource.getFullPath().removeFirstSegments(root.getPath().segmentCount());
        entry = root.getRawBuildpathEntry();
        if (entry != null) ** GOTO lbl13
        return true;
lbl-1000:
        // 1 sources

        {
            if (BuildpathModifier.contains(path, entry.getExclusionPatterns(), null)) {
                return true;
            }
            path = path.removeLastSegments(1);
lbl13:
            // 2 sources

            ** while (path.segmentCount() > 0)
        }
lbl14:
        // 1 sources

        return false;
    }

    protected static String escapeSpecialChars(String value) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '\u00a0': {
                    buf.append(" ");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean isSourceFolder(IScriptProject project) throws ModelException {
        return BuildpathModifier.getBuildpathEntryFor(project.getPath(), project, 3) != null;
    }

    public static boolean isDefaultFragment(IScriptFolder fragment) {
        return fragment.getElementName().length() == 0;
    }

    public static boolean includeFiltersEmpty(IResource resource, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_ExamineInputFilters, 4);
            IProjectFragment root = BuildpathModifier.getFragmentRoot(resource, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            if (root != null) {
                IBuildpathEntry entry = root.getRawBuildpathEntry();
                boolean bl = entry.getInclusionPatterns().length == 0;
                return bl;
            }
            return true;
        }
        finally {
            monitor.done();
        }
    }

    public static boolean filtersSet(IProjectFragment root) throws ModelException {
        if (root == null) {
            return false;
        }
        IBuildpathEntry entry = root.getRawBuildpathEntry();
        IPath[] inclusions = entry.getInclusionPatterns();
        IPath[] exclusions = entry.getExclusionPatterns();
        if (inclusions != null && inclusions.length > 0) {
            return true;
        }
        return exclusions != null && exclusions.length > 0;
    }

    public static BPListElement addToBuildpath(IResource resource, List existingEntries, List newEntries, IScriptProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            BPListElement entry;
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_AddToBuildpath, 2);
            BuildpathModifier.exclude(resource.getFullPath(), existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            BPListElement bPListElement = entry = new BPListElement(project, 3, resource.getFullPath(), resource, false);
            return bPListElement;
        }
        finally {
            monitor.done();
        }
    }

    public static boolean isArchive(IFile file, IScriptProject project) throws ModelException {
        if (!ArchiveFileFilter.isArchivePath(file.getFullPath())) {
            return false;
        }
        return project != null && project.exists() && project.findProjectFragment(file.getFullPath()) == null;
    }

    public static BPListElement addToBuildpath(IModelElement scriptElement, List existingEntries, List newEntries, IScriptProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            BPListElement entry;
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_AddToBuildpath, 10);
            BPListElement bPListElement = entry = new BPListElement(project, 3, scriptElement.getPath(), scriptElement.getResource(), false);
            return bPListElement;
        }
        finally {
            monitor.done();
        }
    }

    public static IScriptProject removeFromBuildpath(IScriptProject project, List existingEntries, IProgressMonitor monitor) throws CoreException {
        BPListElement elem = BuildpathModifier.getListElement(project.getPath(), existingEntries);
        if (elem != null) {
            existingEntries.remove(elem);
        }
        return project;
    }

    public static IResource removeFromBuildpath(IProjectFragment root, List existingEntries, IScriptProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_RemoveFromBuildpath, 1);
            IBuildpathEntry entry = root.getRawBuildpathEntry();
            BPListElement elem = BPListElement.createFromExisting(entry, project);
            existingEntries.remove(elem);
            BuildpathModifier.removeFilters(elem.getPath(), project, existingEntries);
            IResource iResource = elem.getResource();
            return iResource;
        }
        finally {
            monitor.done();
        }
    }

    public static List removeFilters(IPath path, IScriptProject project, List existingEntries) {
        if (path == null) {
            return Collections.EMPTY_LIST;
        }
        IPath projPath = project.getPath();
        if (projPath.isPrefixOf(path)) {
            path = path.removeFirstSegments(projPath.segmentCount()).addTrailingSeparator();
        }
        ArrayList<BPListElement> result = new ArrayList<BPListElement>();
        for (BPListElement element : existingEntries) {
            IPath[] inclusion;
            boolean hasChange = false;
            IPath[] exlusions = (IPath[])element.getAttribute("exclusion");
            if (exlusions != null) {
                ArrayList<IPath> exlusionList = new ArrayList<IPath>(exlusions.length);
                int i = 0;
                while (i < exlusions.length) {
                    if (!exlusions[i].equals((Object)path)) {
                        exlusionList.add(exlusions[i]);
                    } else {
                        hasChange = true;
                    }
                    ++i;
                }
                element.setAttribute("exclusion", exlusionList.toArray(new IPath[exlusionList.size()]));
            }
            if ((inclusion = (IPath[])element.getAttribute("inclusion")) != null) {
                ArrayList<IPath> inclusionList = new ArrayList<IPath>(inclusion.length);
                int i = 0;
                while (i < inclusion.length) {
                    if (!inclusion[i].equals((Object)path)) {
                        inclusionList.add(inclusion[i]);
                    } else {
                        hasChange = true;
                    }
                    ++i;
                }
                element.setAttribute("inclusion", inclusionList.toArray(new IPath[inclusionList.size()]));
            }
            if (!hasChange) continue;
            result.add(element);
        }
        return result;
    }

    private void include(IResource resource, BPListElement entry, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_Including, 10);
            String name = BuildpathModifier.getName(resource.getFullPath(), entry.getPath());
            IPath[] includedPath = (IPath[])entry.getAttribute("inclusion");
            IPath[] newIncludedPath = new IPath[includedPath.length + 1];
            String completedName = BuildpathModifier.completeName(project, name);
            Path relPath = new Path(completedName);
            if (!BuildpathModifier.contains((IPath)relPath, includedPath, (IProgressMonitor)new SubProgressMonitor(monitor, 2))) {
                System.arraycopy(includedPath, 0, newIncludedPath, 0, includedPath.length);
                newIncludedPath[includedPath.length] = relPath;
                entry.setAttribute("inclusion", newIncludedPath);
                entry.setAttribute("exclusion", BuildpathModifier.remove((IPath)relPath, (IPath[])entry.getAttribute("exclusion"), (IProgressMonitor)new SubProgressMonitor(monitor, 2)));
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IResource exclude(String name, IPath fullPath, BPListElement entry, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        IResource result;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_Excluding, 6);
            IPath[] excludedPath = (IPath[])entry.getAttribute("exclusion");
            IPath[] newExcludedPath = new IPath[excludedPath.length + 1];
            name = BuildpathModifier.completeName(project, name);
            Path path = new Path(name);
            if (!BuildpathModifier.contains((IPath)path, excludedPath, (IProgressMonitor)new SubProgressMonitor(monitor, 2))) {
                System.arraycopy(excludedPath, 0, newExcludedPath, 0, excludedPath.length);
                newExcludedPath[excludedPath.length] = path;
                entry.setAttribute("exclusion", newExcludedPath);
                entry.setAttribute("inclusion", BuildpathModifier.remove((IPath)path, (IPath[])entry.getAttribute("inclusion"), (IProgressMonitor)new SubProgressMonitor(monitor, 4)));
            }
            result = fullPath == null ? null : BuildpathModifier.getResource(fullPath, project);
        }
        finally {
            monitor.done();
        }
        return result;
    }

    public static void exclude(IPath path, List existingEntries, List newEntries, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IPath rootPath;
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_Excluding, 1);
            BPListElement elem = null;
            BPListElement existingElem = null;
            int i = 0;
            do {
                if ((rootPath = path.removeLastSegments(++i)).segmentCount() == 0) {
                    return;
                }
                elem = BuildpathModifier.getListElement(rootPath, newEntries);
            } while ((existingElem = BuildpathModifier.getListElement(rootPath, existingEntries)) == null && elem == null);
            if (elem == null) {
                elem = existingElem;
            }
            BuildpathModifier.exclude(path.removeFirstSegments(path.segmentCount() - i).toString(), null, elem, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    public static IResource exclude(IModelElement scriptElement, BPListElement entry, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            String name = BuildpathModifier.getName(scriptElement.getPath(), entry.getPath());
            IResource iResource = BuildpathModifier.exclude(name, scriptElement.getPath(), entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return iResource;
        }
        finally {
            monitor.done();
        }
    }

    private void unInclude(IModelElement scriptElement, BPListElement entry, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_RemoveInclusion, 10);
            String name = BuildpathModifier.getName(scriptElement.getPath(), entry.getPath());
            IPath[] includedPath = (IPath[])entry.getAttribute("inclusion");
            Path relPath = new Path(BuildpathModifier.completeName(project, name));
            IPath[] newIncludedPath = BuildpathModifier.remove((IPath)relPath, includedPath, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
            entry.setAttribute("inclusion", newIncludedPath);
        }
        finally {
            monitor.done();
        }
    }

    public static void unExclude(IResource resource, BPListElement entry, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_RemoveExclusion, 10);
            String name = BuildpathModifier.getName(resource.getFullPath(), entry.getPath());
            IPath[] excludedPath = (IPath[])entry.getAttribute("exclusion");
            IPath[] newExcludedPath = BuildpathModifier.remove((IPath)new Path(BuildpathModifier.completeName(project, name)), excludedPath, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
            entry.setAttribute("exclusion", newExcludedPath);
        }
        finally {
            monitor.done();
        }
    }

    private void resetFilters(IModelElement element, BPListElement entry, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_ResetFilters, 3);
            List exclusionList = this.getFoldersOnBP(element.getPath(), project, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            IPath[] exclusions = exclusionList.toArray(new IPath[exclusionList.size()]);
            entry.setAttribute("inclusion", new IPath[0]);
            entry.setAttribute("exclusion", exclusions);
        }
        finally {
            monitor.done();
        }
    }

    public static BPListElement getBuildpathEntry(List elements, BPListElement cpElement) throws ModelException {
        int i = 0;
        while (i < elements.size()) {
            if (((BPListElement)elements.get(i)).getPath().equals((Object)cpElement.getPath())) {
                return (BPListElement)elements.get(i);
            }
            ++i;
        }
        elements.add(cpElement);
        return cpElement;
    }

    private static BPListElement getListElement(IPath path, List elements) {
        int i = 0;
        while (i < elements.size()) {
            BPListElement element = (BPListElement)elements.get(i);
            if (element.getEntryKind() == 3 && element.getPath().equals((Object)path)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private void updateBuildpath(List newEntries, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IBuildpathEntry[] entries = BuildpathModifier.convert(newEntries);
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)project, (IBuildpathEntry[])entries);
            if (!status.isOK()) {
                throw new ModelException(status);
            }
            project.setRawBuildpath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            this.fireEvent(newEntries);
        }
        finally {
            monitor.done();
        }
    }

    public static void commitBuildPath(List newEntries, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IBuildpathEntry[] entries = BuildpathModifier.convert(newEntries);
            IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)project, (IBuildpathEntry[])entries);
            if (!status.isOK()) {
                throw new ModelException(status);
            }
            project.setRawBuildpath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
        }
    }

    public static List getCorrespondingElements(List entries, IScriptProject project) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < entries.size()) {
            Object element = entries.get(i);
            IPath path = element instanceof IResource ? ((IResource)element).getFullPath() : ((IModelElement)element).getPath();
            IResource resource = BuildpathModifier.getResource(path, project);
            if (resource != null) {
                IModelElement elem = DLTKCore.create((IResource)resource);
                if (elem != null && project.isOnBuildpath(elem)) {
                    result.add(elem);
                } else {
                    result.add(resource);
                }
            }
            ++i;
        }
        return result;
    }

    private static IResource getResource(IPath path, IScriptProject project) {
        return project.getProject().getWorkspace().getRoot().findMember(path);
    }

    private static boolean contains(IPath path, IPath[] paths, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (path == null) {
            return false;
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_ComparePaths, paths.length);
            if (path.getFileExtension() == null) {
                path = new Path(BuildpathModifier.completeName(path.toString()));
            }
            int i = 0;
            while (i < paths.length) {
                if (paths[i].equals((Object)path)) {
                    return true;
                }
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        return false;
    }

    private static String completeName(String name) {
        if (DLTKCore.DEBUG) {
            System.err.println("Add Buildpath name completion here");
        }
        return name;
    }

    private static String completeName(IScriptProject project, String name) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(String.valueOf(project.getElementName()) + "/" + name);
        if (resource != null && resource.getType() == 2 && !name.endsWith("/")) {
            name = String.valueOf(name) + "/";
        }
        return name;
    }

    private static IPath[] remove(IPath path, IPath[] paths, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_RemovePath, paths.length + 5);
            if (!BuildpathModifier.contains(path, paths, (IProgressMonitor)new SubProgressMonitor(monitor, 5))) {
                IPath[] iPathArray = paths;
                return iPathArray;
            }
            ArrayList<IPath> newPaths = new ArrayList<IPath>();
            int i = 0;
            while (i < paths.length) {
                monitor.worked(1);
                if (!paths[i].equals((Object)path)) {
                    newPaths.add(paths[i]);
                }
                ++i;
            }
            IPath[] iPathArray = newPaths.toArray(new IPath[newPaths.size()]);
            return iPathArray;
        }
        finally {
            monitor.done();
        }
    }

    private List getFoldersOnBP(IPath path, IScriptProject project, IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<Path> srcFolders = new ArrayList<Path>();
        IBuildpathEntry[] cpEntries = project.getRawBuildpath();
        int i = 0;
        while (i < cpEntries.length) {
            IPath cpPath = cpEntries[i].getPath();
            if (path.isPrefixOf(cpPath) && path.segmentCount() + 1 == cpPath.segmentCount()) {
                srcFolders.add(new Path(BuildpathModifier.completeName(cpPath.lastSegment())));
            }
            ++i;
        }
        return srcFolders;
    }

    private static String getName(IPath path, IPath rootPath) {
        return path.removeFirstSegments(rootPath.segmentCount()).toString();
    }

    public static void setNewEntry(List existingEntries, List newEntries, IScriptProject project, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_SetNewEntry, existingEntries.size());
            int i = 0;
            while (i < newEntries.size()) {
                BPListElement entry = (BPListElement)newEntries.get(i);
                BuildpathModifier.validateAndAddEntry(entry, existingEntries, project);
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IBuildpathEntry[] convert(List list) {
        IBuildpathEntry[] entries = new IBuildpathEntry[list.size()];
        int i = 0;
        while (i < list.size()) {
            BPListElement element = (BPListElement)list.get(i);
            entries[i] = element.getBuildpathEntry();
            ++i;
        }
        return entries;
    }

    private static void validateAndAddEntry(BPListElement entry, List existingEntries, IScriptProject project) throws CoreException {
        IPath path = entry.getPath();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IStatus validate = workspaceRoot.getWorkspace().validatePath(path.toString(), 2);
        StatusInfo rootStatus = new StatusInfo();
        rootStatus.setOK();
        boolean isExternal = BuildpathModifier.isExternalArchiveOrLibrary(entry, project);
        if (!isExternal && validate.matches(4) && !project.getPath().equals((Object)path)) {
            rootStatus.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidRootName, validate.getMessage()));
            throw new CoreException((IStatus)rootStatus);
        }
        if (!isExternal && !project.getPath().equals((Object)path)) {
            IResource res = workspaceRoot.findMember(path);
            if (res != null) {
                if (res.getType() != 2 && res.getType() != 1) {
                    rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAFolder);
                    throw new CoreException((IStatus)rootStatus);
                }
            } else {
                IFileStore store;
                URI projLocation = project.getProject().getLocationURI();
                if (projLocation != null && (store = EFS.getStore((URI)projLocation).getChild(path)).fetchInfo().exists()) {
                    rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExistingDifferentCase);
                    throw new CoreException((IStatus)rootStatus);
                }
            }
        }
        int i = 0;
        while (i < existingEntries.size()) {
            BPListElement curr = (BPListElement)existingEntries.get(i);
            if (curr.getEntryKind() == 3 && path.equals((Object)curr.getPath()) && !project.getPath().equals((Object)path)) {
                rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExisting);
                throw new CoreException((IStatus)rootStatus);
            }
            ++i;
        }
        if (!isExternal && !entry.getPath().equals((Object)project.getPath())) {
            BuildpathModifier.exclude(entry.getPath(), existingEntries, new ArrayList(), project, null);
        }
        BuildpathModifier.insertAtEndOfCategory(entry, existingEntries);
        IBuildpathEntry[] entries = BuildpathModifier.convert(existingEntries);
        IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)project, (IBuildpathEntry[])entries);
        if (!status.isOK()) {
            rootStatus.setError(status.getMessage());
            throw new CoreException((IStatus)rootStatus);
        }
        if (BuildpathModifier.isSourceFolder(project) || project.getPath().equals((Object)path)) {
            rootStatus.setWarning(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSF);
            return;
        }
        rootStatus.setOK();
    }

    private static void insertAtEndOfCategory(BPListElement entry, List existingEntries) {
        int length = existingEntries.size();
        BPListElement[] elements = existingEntries.toArray(new BPListElement[length]);
        int i = 0;
        while (i < length && elements[i].getBuildpathEntry().getEntryKind() != entry.getBuildpathEntry().getEntryKind()) {
            ++i;
        }
        if (i < length) {
            ++i;
            while (i < length && elements[i].getBuildpathEntry().getEntryKind() == entry.getBuildpathEntry().getEntryKind()) {
                ++i;
            }
            existingEntries.add(i, entry);
            return;
        }
        switch (entry.getBuildpathEntry().getEntryKind()) {
            case 3: {
                existingEntries.add(0, entry);
                break;
            }
            default: {
                existingEntries.add(entry);
            }
        }
    }

    private static boolean isExternalArchiveOrLibrary(BPListElement entry, IScriptProject project) {
        if (entry.getEntryKind() == 1 || entry.getEntryKind() == 5) {
            return !(entry.getResource() instanceof IFolder);
        }
        return false;
    }

    private static boolean equalEntryKind(IBuildpathEntry entry, int kind) {
        return entry.getEntryKind() == kind;
    }

    private void fireEvent(List newEntries) {
        if (this.fListener != null) {
            this.fListener.buildpathEntryChanged(newEntries);
        }
    }

    public static interface IBuildpathModifierListener {
        public void buildpathEntryChanged(List var1);
    }
}

