/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing.core;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IProjectIndexer;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.core.search.indexing.core.IndexRequest;

public class SourceModuleRemoveRequest
extends IndexRequest {
    private final IScriptProject project;
    private final String path;

    public SourceModuleRemoveRequest(IProjectIndexer indexer, IScriptProject project, String path) {
        super(indexer);
        this.project = project;
        this.path = path;
    }

    protected String getName() {
        return this.path;
    }

    protected void run() throws CoreException, IOException {
        Index index = this.getIndexer().getProjectIndex(this.project);
        ReadWriteMonitor imon = index.monitor;
        imon.enterWrite();
        try {
            index.remove(this.path);
        }
        finally {
            imon.exitWrite();
        }
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceModuleRemoveRequest other = (SourceModuleRemoveRequest)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }
}

