package org.jruby.parser;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          235,  235,  230,  567,  235,  204,  392,  190,  249,  240, 
          240,  253,  250,  240,  578,  550,  589,  236,  236,  276, 
          420,  236,  615,  239,  239,  204,  449,  239,  258,  260, 
          496,  217,  242,  242,  235,  235,  242,  284,  286,  517, 
          357,  599,   61,   70,  277,  509,  514,  734,  520,  521, 
          343,  270,  230,  304,  755,  292,  496,  615,  276,  436, 
          449,  220,  191,  191,  458,  790,  549,  110,  110,  363, 
          363,  285,  661,  547,  301,  449,  467,  110,  463,  496, 
          218,  444,  354,  191,  586,  788,  355,  791,  249,   73, 
          509,  514,  496,  497,  217,  444,  496,  245,  458,  604, 
          301,  354,  445,  261,  456,  496,  547,  663,  456,  391, 
          191,  652,  657,  458,  110,  443,  282,  363,  363,  444, 
          456,  491,  311,  312,  220,  217,   41,  463,  456,  446, 
          496,  456,  254,  254,  265,   96,  547,  496,  468,  491, 
          496,  496,  596,  218,  530,  658,   72,  496,  216,  219, 
          266,  646,  110,  448,  217,   72,  308,  302,  547,  367, 
          217,  257,  248,   62,  457,  458,  459,  395,  457,  458, 
          254,  391,   62,  383,  218,  744,  248,   90,  496,  496, 
          457,  458,  649,  302,  567,  445,  161,  686,  457,  458, 
          651,  457,  458,  653,   65,  265,  496,  650,  393,  263, 
          790,  654,  292,  218,    6,  308,  693,   55,  441,  344, 
          383,  496,  534,  373,    6,  767,  345,  235,  235,  286, 
          374,  771,  860,  718,  339,   90,   90,  395,  395,  395, 
          235,  296,  235,  235,  445,  161,  346,  496,  573,  240, 
          428,  240,  240,  394,  298,  395,  356,  236,  496,  236, 
          418,  311,  312,  239,  440,  239,  422,  191,  273,   68, 
          496,   70,  242,    6,  242,  242,  261,  262,   35,  220, 
          383,  383,  383,  412,  347,  370,  388,  364,   35,  750, 
          751,  485,  752,   39,   40,  776,  496,  348,  243,  341, 
          352,  244,  711,  577,  356,  356,  342,  496,  479,  480, 
          481,  482,  483,  484,  485,  486,  487,  488,  489,  490, 
          491,  492,  493,  494,  495,  496,  497,  498,  499,  500, 
          501,  502,  503,  504,   63,   70,  363,   35,  235,  739, 
          740,  523,  548,  526,  456,  676,  678,  235,  537,   66, 
          615,  486,   70,  407,  430,  270,  615,  403,  577,  496, 
          395,  265,  276,  388,  353,  235,  529,  624,  627,  449, 
          529,  398,  399,  235,  522,  595,  525,  266,  377,  807, 
          533,  536,  270,  235,  523,  587,  537,  638,  639,  365, 
          235,   62,  382,  723,  496,  230,  529,  496,  235,  496, 
          270,  756,  235,  235,  457,  458,  235,  458,  516,  363, 
          618,  743,  611,  592,  378,  270,   41,   41,  567,  621, 
          630,  463,   65,  110,  541,  531,  496,  380,  634,  635, 
          636,  829,  496,  496,  204,  516,  497,  845,  235,  496, 
          389,  235,  622,  235,   90,  445,  265,  471,  607,  843, 
          235,  390,  476,  516,  472,  473,  474,  475,  597,  597, 
          311,  312,  266,  625,   64,  381,  217,  270,  516,   41, 
          626,  485,   62,  485,  615,  496,    6,    6,    6,  496, 
          496,  580,    6,    6,  859,    6,   65,   68,  391,  588, 
          161,  590,  191,  161,  161,  161,  397,  698,  516,  689, 
          700,  496,  615,   65,  400,  797,  496,  273,  496,  496, 
          667,  672,  496,  356,  273,  673,  422,  496,  407,  235, 
          516,  675,  677,  422,  368,  386,  632,  414,  161,  416, 
          419,  369,  387,  362,  362,  161,  161,  161,  161,  362, 
           35,   35,   35,  496,  672,  865,   35,   35,  486,   35, 
          486,   68,  547,  485,  485,  485,  404,    6,  496,  485, 
          485,  408,  485,  690,  676,  678,  703,   66,   68,  411, 
          455,   35,   35,   35,   35,   35,  496,  313,    6,  839, 
          204,   80,   80,  111,  111,  437,  235,   80,  211,  211, 
          211,  429,  496,  226,  211,  211,  401,  361,  211,  841, 
          684,  362,  431,  402,  235,  211,  423,  435,  235,  432, 
          424,  425,  235,  486,  486,  486,  313,  433,  191,  486, 
          486,   35,  486,  694,  235,  496,   80,  211,  211,  434, 
          280,   66,  211,  611,  485,  747,  789,  438,  191,  451, 
          783,  742,   35,  447,  532,  449,  450,  328,   66,  358, 
          359,  330,  331,  442,  730,  485,  230,  761,  553,  764, 
          766,  554,  555,  556,  736,  769,  770,  452,  280,  306, 
          307,  308,  309,  310,  707,  773,  235,  560,  561,  496, 
          496,  558,  559,  560,  561,  211,  235,   80,  462,  463, 
          685,  818,  763,  765,  486,  819,  557,  464,  768,  466, 
           88,  538,  427,  558,  559,  560,  561,  577,  581,  764, 
          766,  769,  594,  395,  606,  486,  833,  235,  616,  834, 
          628,  629,  835,  637,  235,  633,  209,  209,  209,  235, 
          235,  110,  656,   95,   95,  664,  665,  670,  815,   95, 
           95,   95,   95,  251,  749,  778,   95,   95,   88,   88, 
           95,  671,  814,  727,  674,  681,  759,   95,  760,  687, 
          762,  816,  496,  496,  682,  268,   82,  826,  688,  235, 
          691,  808,  695,  697,  810,  811,  699,  110,   95,   95, 
           95,  279,  701,   82,   95,  702,  704,  597,  714,  708, 
          715,  876,  716,   83,  719,  720,  826,  496,  235,  722, 
          825,  717,  211,  211,  849,  798,  726,  233,  235,  453, 
          729,  735,  235,  273,  737,  738,  454,  741,  837,  746, 
          804,  805,  806,  360,  211,  838,  211,  211,  496,  496, 
          496,   82,  745,  748,  235,  496,   80,   95,  779,   95, 
          772,   83,   83,   80,  784,  780,  235,  800,  235,  801, 
          802,  270,  812,  820,  821,  872,  822,  852,  854,  799, 
          823,  824,  831,  832,  836,  846,  235,  847,  235,   77, 
          851,  853,   89,  828,  427,  856,  235,  857,  273,  858, 
          235,  875,  877,  879,   80,  211,  211,  211,  211,   80, 
          211,  211,  869,  870,  840,  881,  496,  487,  874,   84, 
           84,  112,  112,  496,  516,   84,  485,    8,  496,  487, 
          489,  227,  489,  254,  487,  882,  476,    8,  491,  496, 
           89,   89,  211,  884,  491,  211,  886,  211,   80,  280, 
          888,  211,  211,  497,  300,  116,   84,  878,  867,  189, 
          209,  209,  830,  692,   84,  868,  351,  758,  281,  211, 
           80,  211,  785,  280,   95,   95,  303,   88,   93,   93, 
          113,  113,  113,   80,   93,   85,    8,  211,  866,  787, 
          231,   80,  305,   80,    0,    0,   95,    0,   95,   95, 
            0,    0,  211,    0,   84,   84,  281,    0,   95,    0, 
            0,    0,    0,    0,  211,   95,    0,    0,    0,    0, 
            0,   82,    0,   93,    0,   84,  211,  283,   80,    0, 
            0,    0,    0,   85,   85,    0,    0,  281,    0,    0, 
          279,    0,    0,  209,  209,  209,  209,  279,  477,  478, 
            0,    0,  477,    0,  211,    0,   95,   95,   95,   95, 
           95,   95,   95,   95,    0,  283,  476,    0,   41,    0, 
           83,  553,  273,    0,  554,  555,  556,  313,   41,  273, 
            0,    0,    0,    0,   93,   82,   90,    0,    0,    0, 
            0,    0,    0,    0,   95,    0,    0,   95,    0,   95, 
           95,    0,   82,   95,   95,    0,   80,    0,  328,  551, 
            0,    0,  330,  331,  332,  333,  558,  559,  560,  561, 
            0,   95,   95,   95,   85,  476,   41,   41,    0,    0, 
            0,    0,    0,  427,  313,   95,    0,  273,    7,   95, 
          427,  211,   80,   95,  273,   95,    0,    0,    7,   89, 
          326,  327,  268,  279,   95,    0,    0,    0,    0,    0, 
            0,   80,   92,   92,  631,  328,   95,   90,   92,  330, 
          331,  332,  333,  173,   84,  476,   80,    0,   95,    0, 
           95,   84,  476,  173,    0,    0,    0,  476,    0,    8, 
            8,    8,   77,    0,    0,    8,    8,    7,    8,    0, 
            0,    0,    0,    0,  211,   85,   95,   92,  476,   77, 
            0,    0,  280,   84,   79,    0,    0,  217,    0,  280, 
            0,    0,   84,    0,    0,    0,    0,   84,  211,    0, 
            0,   79,  173,   93,    0,    0,    0,   87,   87,  476, 
           93,    0,   85,   87,    0,    0,   80,    0,    0,  229, 
            0,    0,    0,    0,    0,  476,    0,  226,   80,    0, 
           80,  477,   80,  211,  211,    0,   84,  281,   92,  211, 
            8,    0,    0,    0,    0,    0,  281,    0,    0,  209, 
           75,   93,   87,  281,    0,   87,   93,    0,   84,    0, 
            0,    8,    0,   95,   95,    0,    0,   75,    0,    0, 
            0,   84,    0,  793,    0,  476,    0,   80,   75,   84, 
          211,   84,  476,   95,    0,  272,  275,  476,    0,    0, 
            0,    0,   80,   80,   80,   93,  283,  427,   95,    0, 
           41,   41,   41,   87,   87,   41,   41,   41,  476,   41, 
            0,   88,  209,   87,    0,   86,   84,   93,    0,   41, 
            0,    0,    0,    0,    0,  427,   95,    0,   41,   41, 
           93,   41,   41,   41,   41,   41,  477,    0,   93,    0, 
           93,  211,    0,    0,    0,   80,   80,    0,    0,    0, 
           95,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  279,   86,   86,    0,   80,    0,   95,  279, 
            7,    7,    7,    0,  477,   93,    7,    7,    0,    7, 
           95,   41,   95,    0,   95,   95,   95,   92,    0,    0, 
            0,   95,   88,    0,   92,   79,  480,   77,  476,   80, 
            0,    0,   41,    0,    0,  173,  173,  173,  211,    0, 
           80,  173,  173,    0,  173,    0,   81,   80,  209,   79, 
          477,    0,    0,    0,    0,    0,   80,    0,    0,   95, 
           84,    0,   95,  173,  173,   92,  173,  173,  173,  173, 
           92,    0,  477,   80,   95,   95,   95,   76,  476,   84, 
            0,    7,    0,    0,    0,  476,    0,    0,    0,    0, 
          476,   77,   87,  280,   84,    0,    0,    0,    0,   87, 
          477,    0,    7,  279,    0,    0,    0,  477,   77,   92, 
           78,  476,  477,   79,  421,   75,  173,    0,    0,   93, 
            0,    0,    0,   95,  281,    0,    0,   95,   95,    0, 
           79,   92,    0,  477,    0,    0,    0,  173,   93,   81, 
           87,   78,   87,   83,   92,   87,    0,    0,   95,    0, 
          405,  406,   92,   93,   92,  477,   81,  480,   78,    0, 
            0,    0,    0,    0,   84,  754,  427,    0,    0,    0, 
            0,    0,    0,  427,    0,  227,   84,    0,   84,   75, 
           84,   95,    0,    0,   87,    0,  280,    0,  480,   92, 
           95,    0,   95,    0,  427,    0,   75,    0,    0,   95, 
            0,  427,   86,    0,    0,  477,   87,    0,   33,  272, 
            0,    0,  477,  154,    0,  480,    0,  477,   33,   87, 
            0,  794,    0,   93,   83,   84,    0,   87,    0,   87, 
            0,    0,    0,    0,  231,   93,  272,   93,  477,   93, 
           84,   84,   84,    0,  576,  579,    0,    0,    0,    0, 
            0,    0,  261,    0,  272,    0,    0,    0,    0,    0, 
           87,  477,  154,    0,   87,  480,  528,   33,    0,  272, 
          535,  313,  480,    0,    0,    0,    0,  476,    0,    0, 
          796,   89,    0,    0,   93,    0,    0,  326,  327,    0, 
            0,   80,    0,   84,   84,    0,  574,    0,  480,   93, 
           93,   93,  328,   92,  329,    0,  330,  331,  332,  333, 
            0,  477,   84,  528,   84,    0,    0,    0,  477,    0, 
           14,  272,   92,  477,    0,  608,  610,    0,    0,  614, 
           14,    0,  280,  620,   76,  660,  660,   92,    0,  280, 
            0,   87,  279,    0,  477,   86,  480,   84,    0,  279, 
            0,   76,   93,   93,  477,   80,    0,    0,   84,    0, 
            0,  641,   89,  281,  614,   84,  641,    0,    0,    0, 
          281,  660,   80,   93,   81,  669,   78,  480,   87,   14, 
            0,  281,    0,    0,    0,    0,  669,  669,    0,    0, 
            0,    0,    0,   84,    0,    0,  480,   87,    0,    0, 
            0,    0,    0,  480,  183,    0,   93,   92,  476,    0, 
          669,    0,   87,    0,  183,    0,  164,   93,    0,   92, 
            0,   92,    0,   92,   93,  280,   86,  480,    0,  480, 
            0,    0,  280,    0,  480,    0,    0,    0,   81,  476, 
           78,  706,  679,    0,  710,    0,  579,    0,  183,    0, 
            0,    0,    0,    0,  579,   81,    0,   78,    0,    0, 
          480,    0,  183,  183,    0,  164,  149,  183,   92,    0, 
           33,   33,   33,    0,    0,    0,   33,   33,    0,   33, 
            0,    0,   87,   92,   92,   92,    0,    0,    0,    0, 
            0,    0,    0,  229,   87,    0,   87,    0,   87,    0, 
            0,   33,   33,   33,   33,   33,    0,  154,    0,  721, 
          154,  154,  154,    0,    0,  149,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  728,    0,    0, 
            0,  731,    0,  421,    0,  732,   92,   92,    0,  795, 
          421,    0,    0,   87,    0,  154,    0,  610,    0,  660, 
            0,   33,  154,  154,  154,  154,    0,   92,   87,   87, 
           87,    0,    0,  416,    0,    0,    0,    0,    0,   76, 
            0,    0,   33,  416,    0,    0,    0,    0,    0,    0, 
            0,    0,   14,   14,   14,    0,    0,    0,   14,   14, 
           92,   14,    0,    0,    0,    0,    0,    0,    0,  775, 
            0,   92,    0,    0,    0,  669,  669,  416,   92,  782, 
            0,   87,   87,   14,   14,   14,   14,   14,    0,    0, 
          281,  416,  416,    0,  416,    0,  416,  281,    0,    0, 
            0,    0,   87,   76,    0,    0,    0,    0,    0,    0, 
          641,    0,    0,    0,    0,    0,    0,  614,    0,    0, 
           76,    0,    0,  614,  416,    0,    0,    0,    0,    0, 
            0,    0,    0,   14,    0,   87,  183,  183,  183,    0, 
          579,  183,  183,  183,    0,  183,   87,    0,    0,  419, 
            0,    0,    0,   87,   14,  183,  183,    0,    0,  419, 
            0,  313,  827,    0,  183,  183,    0,  183,  183,  183, 
          183,  183,    0,    0,    0,  272,    0,  326,  327,    0, 
          164,    0,    0,  164,  164,  164,    0,    0,    0,    0, 
            0,  842,  328,  419,  329,    0,  330,  331,  332,  333, 
            0,  850,  336,  579,  337,  855,  423,  419,  419,    0, 
          419,    0,  419,  423,  183,    0,    0,  183,  164,  254, 
          183,    0,  183,    0,    0,  164,  164,  164,  164,    0, 
          149,    0,    0,  149,  149,  149,    0,    0,  183,  610, 
          419,  614,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  424,    0,    0,  880, 
            0,  883,    0,  424,    0,    0,    0,    0,  149,  614, 
            0,    0,  338,  887,    0,  149,  149,  149,  149,    0, 
            0,    0,  132,    0,    0,    0,    0,    0,    0,    0, 
          473,  473,  473,    0,  473,  416,  416,  416,  473,  473, 
          416,  416,  416,  473,  416,  473,  473,  473,  473,  473, 
          473,  473,  416,  473,  416,  416,  473,  473,  473,  473, 
          473,  473,  473,  416,  416,    0,  416,  416,  416,  416, 
          416,  132,  473,    0,    0,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,  473,    0,  473,  473,    0,  473, 
          473,  473,  416,  416,  416,  416,  416,  416,  416,  416, 
          416,  416,  416,  416,  416,  416,    0,    0,  416,  416, 
          416,  473,  416,  416,  473,  473,  416,  473,  473,  416, 
          473,  416,  473,  416,  473,  416,  473,  416,  416,  416, 
          416,  416,  416,  416,  473,  416,  473,  416,    0,  473, 
          473,  473,  473,  473,  473,    0,  474,  474,  474,    0, 
          474,  419,  419,  419,  474,  474,  419,  419,  419,  474, 
          419,  474,  474,  474,  474,  474,  474,  474,  419,  474, 
          419,  419,  474,  474,  474,  474,  474,  474,  474,  419, 
          419,  338,  419,  419,  419,  419,  419,    0,  474,    0, 
            0,  474,  474,  474,  474,  474,  474,  474,  474,  474, 
          474,    0,  474,  474,    0,  474,  474,  474,  419,  419, 
          419,  419,  419,  419,  419,  419,  419,  419,  419,  419, 
          419,  419,    0,    0,  419,  419,  419,  474,  419,  419, 
          474,  474,  419,  474,  474,  419,  474,  419,  474,  419, 
          474,  419,  474,  419,  419,  419,  419,  419,  419,  419, 
          474,  419,  474,  419,  476,  474,  474,  474,  474,  474, 
          474,    0,    0,    0,  476,    0,    0,    0,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,    0, 
          324,  325,    0,    0,  326,  327,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  476,  328, 
            0,  329,    0,  330,  331,  332,  333,  334,  335,  336, 
            0,  337,  476,  476,    0,   85,  132,  476,    0,  132, 
          132,  132,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  313,    0,    0,    0,    0, 
          318,  319,  426,    0,    0,  476,    0,    0,    0,  426, 
            0,  326,  327,    0,  132,    0,    0,    0,    0,    0, 
            0,  132,  132,  132,  132,    0,  328,    0,  329,  477, 
          330,  331,  332,  333,  334,  335,  336,    0,  337,  477, 
            0,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,    0,    0,    0,    0,    0,  326,  327,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  328,  477,  329,  680,  330,  331,  332,  333, 
          334,  335,  336,    0,  337,    0,    0,  477,  477,    0, 
           87,    0,  477,    0,    0,    0,    0,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  133,  324, 
          325,    0,    0,  326,  327,    0,    0,    0,    0,   96, 
          477,    0,    0,    0,    0,    0,    0,    0,  328,    0, 
          329,    0,  330,  331,  332,  333,  334,  335,  336,    0, 
          337,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  133,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   96,    0, 
            0,  476,  476,  476,    0,  476,  476,  476,  476,  476, 
          476,  476,  476,  476,  476,  476,  476,  476,  476,  476, 
          476,  476,  476,    0,  476,  476,  476,  476,  476,  476, 
          476,  476,  476,  476,  476,  476,  338,  476,  476,  476, 
          476,  476,    0,  476,    0,    0,  476,  476,  476,  476, 
          476,  476,  476,  476,  476,  476,    0,  476,  476,    0, 
          476,  476,  476,  476,  476,  476,  476,  476,  476,  476, 
          476,  476,  476,  476,  476,  476,  476,    0,    0,  476, 
          476,  476,  476,    0,  476,  476,  476,  476,  476,  476, 
          476,  476,  476,  476,  476,  476,  476,  476,  476,  476, 
          476,  476,  476,  476,  476,  476,  476,  476,  476,    0, 
          476,  476,  476,  476,  476,  476,  477,  477,  477,    0, 
          477,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,  477,  477,  477,    0,  477, 
          477,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,    0,  477,  477,  477,  477,  477,    0,  477,    0, 
            0,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,    0,  477,  477,    0,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,  477,    0,    0,  477,  477,  477,  477,    0,  477, 
          477,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  480,  477,  477,  477,  477,  477, 
          477,    0,  133,    0,  480,  133,  133,  133,    0,    0, 
            0,    0,    0,   96,    0,    0,   96,   96,   96,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  425,    0, 
            0,    0,    0,    0,    0,  425,    0,    0,  480,  416, 
          133,    0,    0,    0,    0,    0,  416,  133,  133,  133, 
          133,   96,  480,  480,    0,   86,    0,  480,   96,   96, 
           96,   96,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,    0,  324,  325,    0,    0,  326,  327, 
            0,    0,    0,    0,    0,  480,    0,    0,    0,    0, 
            0,    0,    0,  328,    0,  329,    0,  330,  331,  332, 
          333,  334,  335,  336,    0,  337,    0,    0,    0,  274, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  274, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   97,   98,   17, 
           18,    0,    0,  274,    0,   99,  100,  101,   22,   23, 
           24,   25,    0,    0,    0,    0,    0,  274,  274,    0, 
            0,  102,  274,    0,   31,   32,   33,   34,   35,   36, 
           37,   38,   39,   40,    0,   41,   42,    0,   97,    0, 
          105,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          274,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          225,    0,    0,   47,    0,    0,   48,   49,    0,   50, 
            0,   51,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  757,    0,    0,    0,    0,   97,   54,   55, 
           56,   57,   58,   59,    0,    0,    0,    0,    0,    0, 
            0,  476,  476,  476,    0,  476,  480,  480,  480,  476, 
          476,  480,  480,  480,  476,  480,  476,  476,  476,  476, 
          476,  476,  476,    0,  480,  480,  480,  476,  476,  476, 
          476,  476,  476,  476,  480,  480,    0,  480,  480,  480, 
          480,  480,    0,  476,    0,    0,  476,  476,  476,  476, 
          476,  476,  476,  476,  476,  476,    0,  476,  476,    0, 
          476,  476,  476,  480,  480,  480,  480,  480,  480,  480, 
          480,  480,  480,  480,  480,  480,  480,    0,    0,  480, 
          480,  480,  476,    0,  480,  476,  476,  480,  476,  476, 
          480,  476,  480,  476,  480,  476,  480,  476,  480,  480, 
          480,  480,  480,  480,  480,  476,  480,  480,  480,    0, 
          476,  476,  476,  476,  476,  476,  475,  475,  475,    0, 
          475,  274,  274,  274,  475,  475,  274,  274,  274,  475, 
          274,  475,  475,  475,  475,  475,  475,  475,    0,  475, 
          274,  274,  475,  475,  475,  475,  475,  475,  475,  274, 
          274,    0,  274,  274,  274,  274,  274,    0,  475,    0, 
            0,  475,  475,  475,  475,  475,  475,  475,  475,  475, 
          475,    0,  475,  475,    0,  475,  475,  475,  274,  274, 
          274,  274,  274,  274,  274,  274,  274,  274,  274,  274, 
          274,  274,    0,    0,  274,  274,  274,  475,    0,  274, 
          475,  475,  274,  475,  475,  274,  475,  274,  475,  274, 
          475,  274,  475,  274,  274,  274,  274,  274,  274,  274, 
          475,  274,  475,  274,  481,  475,  475,  475,  475,  475, 
          475,    0,   97,    0,  481,   97,   97,   97,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  419,    0, 
            0,    0,    0,    0,    0,  419,    0,    0,  481,    0, 
           97,    0,    0,    0,    0,    0,    0,   97,   97,   97, 
           97,    0,  481,  481,    0,    0,    0,  481,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  481,    0,    0,    0,    0, 
            0,    0,    0,    0,    3,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,  482, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,  482, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,  482,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  482,  482,    0, 
            0,    0,  482,    0,    0,    0,   46,    0,    0,   47, 
            0,    0,   48,   49,    0,   50,    0,   51,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,   53, 
          482,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            0,  606,    0,   60,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          338,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  478,  478,  478,    0,  478,  481,  481,  481,  478, 
          478,  481,  481,  481,  478,  481,  478,  478,  478,  478, 
          478,  478,  478,    0,  481,  481,  481,  478,  478,  478, 
          478,  478,  478,  478,  481,  481,    0,  481,  481,  481, 
          481,  481,    0,  478,    0,    0,  478,  478,  478,  478, 
          478,  478,  478,  478,  478,  478,    0,  478,  478,    0, 
          478,  478,  478,  481,  481,  481,  481,  481,  481,  481, 
          481,  481,  481,  481,  481,  481,  481,    0,    0,  481, 
          481,  481,  478,    0,  481,  478,  478,  481,  478,  478, 
          481,  478,  481,  478,  481,  478,  481,  478,  481,  481, 
          481,  481,  481,  481,  481,  478,  481,  481,  481,    0, 
          478,  478,  478,  478,  478,  478,  479,  479,  479,    0, 
          479,  482,  482,  482,  479,  479,  482,  482,  482,  479, 
          482,  479,  479,  479,  479,  479,  479,  479,    0,  482, 
          482,  482,  479,  479,  479,  479,  479,  479,  479,  482, 
          482,    0,  482,  482,  482,  482,  482,    0,  479,    0, 
            0,  479,  479,  479,  479,  479,  479,  479,  479,  479, 
          479,    0,  479,  479,    0,  479,  479,  479,  482,  482, 
          482,  482,  482,  482,  482,  482,  482,  482,  482,  482, 
          482,  482,    0,    0,  482,  482,  482,  479,    0,  482, 
          479,  479,  482,  479,  479,  482,  479,  482,  479,  482, 
          479,  482,  479,  482,  482,  482,  482,  482,  482,  482, 
          479,  482,  482,  482,  350,  479,  479,  479,  479,  479, 
          479,    0,    0,    0,  350,    0,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,    0,  324,  325, 
            0,    0,  326,  327,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  328,  350,  329, 
            0,  330,  331,  332,  333,  334,  335,  336,    0,  337, 
            0,    0,  350,  350,    0,    0,    0,  350,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  350,    0,    0,    0,    0, 
            0,    0,    0,    0,    3,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,  496, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,  496, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,  496,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  496,  496,    0, 
            0,    0,  496,    0,    0,    0,   46,    0,    0,  264, 
            0,    0,   48,   49,    0,   50,    0,   51,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,   53, 
          496,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            0,    0,    0,   60,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  662,    0,    0,    0,    0, 
          338,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  251,  251,  251,    0,  251,  350,  350,  350,  251, 
          251,  350,  350,  350,  251,  350,  251,  251,  251,  251, 
          251,  251,  251,    0,  350,  350,  350,  251,  251,  251, 
          251,  251,  251,  251,  350,  350,    0,  350,  350,  350, 
          350,  350,    0,  251,    0,    0,  251,  251,  251,  251, 
          251,  251,  251,  251,  251,  251,    0,  251,  251,    0, 
          251,  251,  251,  350,  350,  350,  350,  350,  350,  350, 
          350,  350,  350,  350,  350,  350,  350,    0,    0,  350, 
          350,  350,  251,    0,  350,  251,    0,  350,  251,  251, 
          350,  251,  350,  251,  350,  251,  350,  251,  350,  350, 
          350,  350,  350,  350,  350,  251,  350,  350,  350,    0, 
          251,  251,  251,  251,  251,  251,  251,  251,  251,    0, 
          251,  496,  496,  496,  251,  251,  496,  496,  496,  251, 
          496,  251,  251,  251,  251,  251,  251,  251,    0,  496, 
          496,  496,  251,  251,  251,  251,  251,  251,  251,  496, 
          496,    0,  496,  496,  496,  496,  496,    0,  251,    0, 
            0,  251,  251,  251,  251,  251,  251,  251,  251,  251, 
          251,    0,  251,  251,    0,  251,  251,  251,  496,  496, 
          496,  496,  496,  496,  496,  496,  496,  496,  496,  496, 
          496,  496,    0,    0,  496,  496,  496,  251,    0,  496, 
          251,    0,  496,  251,  251,  496,  251,  496,  251,  496, 
          251,  496,  251,  496,  496,  496,  496,  496,  496,  496, 
          251,  496,  496,  496,  279,  251,  251,  251,  251,  251, 
          251,    0,    0,    0,  279,    0,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,    0,  324,  325, 
            0,    0,  326,  327,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  328,  279,  329, 
            0,  330,  331,  332,  333,  334,  335,  336,    0,  337, 
            0,    0,  279,  279,    0,   88,    0,  279,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  279,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,  287, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,  287, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,  287,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  287,  287,    0, 
            0,    0,  287,    0,    0,    0,   46,    0,    0,   47, 
            0,    0,   48,   49,    0,   50,    0,   51,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,   53, 
          287,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            0,    0,    0,   60,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          217,    0,    0,    0,    0,    0,  477,  477,  477,    0, 
          477,  279,  279,  279,  477,  477,  279,  279,  279,  477, 
          279,  477,  477,  477,  477,  477,  477,  477,    0,    0, 
          279,  279,  477,  477,  477,  477,  477,  477,  477,  279, 
          279,    0,  279,  279,  279,  279,  279,    0,  477,  218, 
            0,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,    0,  477,  477,    0,  477,  477,  477,  279,  279, 
          279,  279,  279,  279,  279,  279,  279,  279,  279,  279, 
          279,  279,    0,    0,  279,  279,  279,  477,    0,  279, 
          477,  477,  279,  477,  477,  279,  477,  279,  477,  279, 
          477,  279,  477,  279,  279,  279,  279,  279,  279,  279, 
          477,  279,    0,  279,    0,  477,  477,  477,  477,  477, 
          477,  251,  251,  251,    0,  251,  287,  287,  287,  251, 
          251,  287,  287,  287,  251,  287,  251,  251,  251,  251, 
          251,  251,  251,    0,    0,  287,  287,  251,  251,  251, 
          251,  251,  251,  251,  287,  287,    0,  287,  287,  287, 
          287,  287,    0,  251,    0,    0,  251,  251,  251,  251, 
          251,  251,  251,  251,  251,  251,    0,  251,  251,    0, 
          251,  251,  251,  287,  287,  287,  287,  287,  287,  287, 
          287,  287,  287,  287,  287,  287,  287,    0,    0,  287, 
          287,  287,  251,    0,  287,  251,    0,  287,  251,  251, 
          287,  251,  287,  251,  287,  251,  287,  251,  287,  287, 
          287,  287,  287,  287,  287,  251,  287,  476,  287,    0, 
          251,  251,  251,  251,  251,  251,    0,  476,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,   77,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,  476,    0,   85,   28, 
          476,    0,   31,   32,   33,   34,   35,   36,   37,   38, 
           39,   40,    0,   41,   42,    0,   43,   44,   45,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  476,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  208,    0, 
            0,  108,    0,    0,   48,   49,    0,   50,    0,    0, 
            0,    0,  477,   52,    0,    0,    0,    0,    0,    0, 
            0,   53,  477,    0,    0,    0,   54,   55,   56,   57, 
           58,   59,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           97,   98,   17,   18,    0,    0,   79,    0,   99,   20, 
           21,   22,   23,   24,   25,    0,    0,    0,    0,    0, 
            0,  477,    0,   87,   28,  477,    0,   31,   32,   33, 
           34,   35,   36,   37,   38,   39,   40,    0,   41,   42, 
            0,   43,   44,   45,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  477,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  208,    0,    0,  108,    0,  413,   48, 
           49,    0,   50,    0,  232,    0,  233,    0,   52,    0, 
            0,    0,    0,    0,    0,    0,  234,    0,    0,    0, 
            0,   54,   55,   56,   57,   58,   59,    0,    0,    0, 
            0,    0,    0,    0,  476,  476,  476,    0,  476,  476, 
          476,  476,  476,  476,    0,  476,  476,  476,  476,  476, 
          476,  476,  476,  476,  476,  476,    0,  476,    0,    0, 
          476,  476,  476,  476,  476,  476,  476,  476,  476,    0, 
          476,  476,  476,  476,  476,    0,  476,    0,    0,  476, 
          476,  476,  476,  476,  476,  476,  476,  476,  476,    0, 
          476,  476,    0,  476,  476,  476,  476,  476,  476,  476, 
          476,  476,  476,  476,  476,  476,  476,  476,  476,  476, 
            0,    0,  476,  476,  476,  476,    0,    0,  476,  476, 
          476,  476,  476,    0,  476,    0,  476,  476,  476,  476, 
          476,  476,  476,  476,  476,  476,  476,  476,  476,  476, 
          476,  476,    0,  476,  476,  476,  476,  476,  476,  477, 
          477,  477,    0,  477,  477,  477,  477,  477,  477,    0, 
          477,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,    0,  477,    0,    0,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,    0,  477,  477,  477,  477,  477, 
            0,  477,    0,    0,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,    0,  477,  477,    0,  477,  477, 
          477,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,    0,    0,  477,  477,  477, 
          477,    0,    0,  477,  477,  477,  477,  477,    0,  477, 
            0,  477,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,  477,  477,  480,  477,  477, 
          477,  477,  477,  477,    0,    0,    0,  480,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,   78,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,  480,    0,   86,   28, 
          480,    0,   31,   32,   33,   34,   35,   36,   37,   38, 
           39,   40,    0,   41,   42,    0,   43,   44,   45,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  480,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  208,    0, 
            0,  108,    0,    0,   48,   49,    0,   50,    0,  617, 
            0,  233,  279,   52,    0,    0,    0,    0,    0,    0, 
            0,   53,  279,    0,    0,    0,   54,   55,   56,   57, 
           58,   59,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           97,   98,   17,   18,    0,    0,   80,    0,   99,   20, 
           21,   22,   23,   24,   25,    0,    0,    0,    0,    0, 
            0,  279,    0,   88,   28,  279,    0,   31,   32,   33, 
           34,   35,   36,   37,   38,   39,   40,    0,   41,   42, 
            0,   43,   44,   45,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  279,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  208,    0,    0,  108,    0,    0,   48, 
           49,    0,   50,    0,  232,    0,  233,    0,   52,    0, 
            0,    0,    0,    0,    0,    0,  234,    0,    0,  496, 
            0,   54,   55,   56,   57,   58,   59,    0,    0,  496, 
            0,    0,    0,    0,  476,  476,  476,    0,  476,  480, 
          480,  480,  476,  476,    0,  480,  480,  476,  480,  476, 
          476,  476,  476,  476,  476,  476,    0,  480,    0,    0, 
          476,  476,  476,  476,  476,  476,  476,  480,  480,    0, 
          480,  480,  480,  480,  480,    0,  476,  496,  496,  476, 
          476,  476,  476,  476,  476,  476,  476,  476,  476,    0, 
          476,  476,    0,  476,  476,  476,  480,  480,  480,  480, 
          480,  480,  480,  480,  480,  480,  480,  480,  480,  480, 
            0,    0,  480,  480,  480,  476,    0,    0,  476,  476, 
          480,  476,  476,    0,  476,    0,  476,  480,  476,  480, 
          476,  480,  480,  480,  480,  480,  480,  480,  476,  480, 
          480,  480,    0,  476,  476,  476,  476,  476,  476,  477, 
          477,  477,    0,  477,  279,  279,  279,  477,  477,    0, 
          279,  279,  477,  279,  477,  477,  477,  477,  477,  477, 
          477,    0,    0,    0,    0,  477,  477,  477,  477,  477, 
          477,  477,  279,  279,    0,  279,  279,  279,  279,  279, 
            0,  477,    0,    0,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,    0,  477,  477,    0,  477,  477, 
          477,  279,  279,  279,  279,  279,  279,  279,  279,  279, 
          279,  279,  279,  279,  279,    0,    0,  279,  279,  279, 
          477,    0,    0,  477,  477,  279,  477,  477,    0,  477, 
            0,  477,  279,  477,  279,  477,  279,  279,  279,  279, 
          279,  279,  279,  477,  279,    0,  279,    0,  477,  477, 
          477,  477,  477,  477,    0,    0,    0,    0,    0,    0, 
           91,    0,    0,    0,    0,    0,  251,  251,  251,    0, 
          251,  496,  496,  496,  251,  251,  496,  496,  496,  251, 
          496,  251,  251,  251,  251,  251,  251,  251,    0,    0, 
          496,    0,  251,  251,  251,  251,  251,  251,  251,  496, 
          496,    0,  496,  496,  496,  496,  496,    0,  251,   91, 
            0,  251,  251,  251,  251,  251,  251,  251,  251,  251, 
          251,    0,  251,  251,    0,  251,  251,  251,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  496, 
            0,  416,    0,    0,    0,    0,  496,  251,    0,    0, 
          251,    0,  496,  251,  251,    0,  251,    0,  251,    0, 
          251,    0,  251,    0,    0,    0,    0,    0,    0,    0, 
          251,    0,    0,  496,    0,  251,  251,  251,  251,  251, 
          251,   92,    0,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   97,   98,   17,   18,    0,    0, 
            0,    0,   99,   20,   21,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
           92,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
           40,    0,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  419,    0,    0,    0,    0,  208,    0,    0, 
          108,    0,    0,  415,   49,    0,   50,    0,  232,    0, 
          233,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    0,    0,    0,    0,    0,   91,   91,   91,   91, 
           91,   91,   91,   91,   91,   91,   91,    0,    0,   91, 
           91,   91,   91,   91,   91,   91,   91,   91,   91,    0, 
          473,    0,    0,   91,   91,   91,   91,   91,   91,   91, 
            0,    0,   91,    0,    0,    0,    0,    0,   91,   91, 
           91,   91,   91,   91,   91,   91,   91,   91,   91,   91, 
           91,   91,    0,   91,   91,    0,   91,   91,   91,    0, 
           91,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          416,    0,    0,    0,    0,    0,    0,  416,   91,    0, 
            0,   91,  473,    0,   91,   91,    0,   91,    0,   91, 
            0,    0,  480,   91,    0,    0,    0,    0,   91,    0, 
            0,   91,    0,  473,    0,    0,   91,   91,   91,   91, 
           91,   91,    0,    0,    0,   91,    0,   92,   92,   92, 
           92,   92,   92,   92,   92,   92,   92,   92,    0,    0, 
           92,   92,   92,   92,   92,   92,   92,   92,   92,   92, 
            0,  474,    0,    0,   92,   92,   92,   92,   92,   92, 
           92,    0,    0,   92,    0,    0,    0,    0,    0,   92, 
           92,   92,   92,   92,   92,   92,   92,   92,   92,   92, 
           92,   92,   92,    0,   92,   92,    0,   92,   92,   92, 
            0,   92,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  419,    0,    0,    0,    0,    0,    0,  419,   92, 
            0,    0,   92,  474,    0,   92,   92,    0,   92,    0, 
           92,    0,    0,  279,   92,    0,    0,    0,    0,   92, 
            0,    0,   92,    0,  474,    0,    0,   92,   92,   92, 
           92,   92,   92,    0,    0,    0,   92,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   91,   91,   91, 
           91,   91,   91,   91,   91,   91,   91,   91,    0,    0, 
           91,   91,   92,   91,   91,   91,   91,   91,   91,   91, 
            0,  480,    0,    0,   91,   91,   91,   91,   91,   91, 
           91,    0,    0,   91,    0,    0,    0,    0,    0,   91, 
           91,   91,   91,   91,   91,   91,   91,   91,   91,   91, 
           91,   91,   91,    0,   91,   91,    0,   91,   91,   91, 
            0,   92,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  480,    0,    0,    0,    0,    0,    0,  480,   91, 
            0,    0,   91,  476,    0,   91,   91,    0,   91,    0, 
           91,    0,    0,  280,   91,    0,    0,    0,    0,   91, 
            0,    0,   91,    0,  480,    0,    0,   91,   91,   91, 
           91,   91,   91,    0,    0,    0,   91,    0,   92,   92, 
           92,   92,   92,   92,   92,   92,   92,   92,   92,    0, 
            0,   92,   92,  323,   92,   92,   92,   92,   92,   92, 
           92,    0,    0,    0,    0,   92,   92,   92,   92,   92, 
           92,   92,    0,    0,   92,    0,    0,    0,    0,    0, 
           92,   92,   92,   92,   92,   92,   92,   92,   92,   92, 
           92,   92,   92,   92,    0,   92,   92,    0,   92,   92, 
           92,    0,  323,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  279,    0,    0,    0,    0,    0,    0,  279, 
           92,    0,    0,   92,  477,    0,   92,   92,    0,   92, 
            0,   92,    0,    0,    0,   92,    0,    0,    0,    0, 
           92,    0,    0,   92,    0,    0,    0,    0,   92,   92, 
           92,   92,   92,   92,    0,    0,    0,   92,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   92,   92, 
           92,   92,   92,   92,   92,   92,   92,   92,   92,    0, 
            0,   92,   92,  496,   92,   92,   92,   92,   92,   92, 
           92,    0,    0,    0,    0,   92,   92,   92,   92,   92, 
           92,   92,    0,    0,   92,    0,    0,    0,    0,    0, 
           92,   92,   92,   92,   92,   92,   92,   92,   92,   92, 
           92,   92,   92,   92,    0,   92,   92,    0,   92,   92, 
           92,    0,  496,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  280,    0,    0,    0,    0,    0,    0,  280, 
           92,    0,    0,   92,    0,    0,   92,   92,    0,   92, 
            0,   92,    0,    0,    0,   92,    0,    0,    0,    0, 
           92,    0,    0,   92,    0,    0,    0,    0,   92,   92, 
           92,   92,   92,   92,    0,    0,    0,   92,    0,  323, 
          323,  323,  323,  323,  323,  323,  323,  323,  323,  323, 
            0,  323,  323,  323,  323,  323,  323,  323,  323,  323, 
          323,  323,  496,    0,    0,    0,  323,  323,  323,  323, 
          323,  323,  323,    0,    0,  323,    0,    0,    0,    0, 
            0,  323,  323,  323,  323,  323,  323,  323,  323,  323, 
          323,  323,  323,  323,  323,    0,  323,  323,    0,  323, 
          323,  323,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  496,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  323,    0,    0,  323,    0,    0,  323,  323,    0, 
          323,    0,  323,    0,    0,    0,  323,    0,    0,    0, 
            0,    0,    0,    0,  323,    0,    0,    0,    0,  323, 
          323,  323,  323,  323,  323,    0,    0,    0,  323,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  496, 
          496,  496,  496,  496,  496,    0,    0,  496,  496,  496, 
            0,    0,    0,  496,  350,  496,  496,  496,  496,  496, 
          496,  496,    0,    0,  350,    0,  496,  496,  496,  496, 
          496,  496,  496,    0,    0,  496,    0,    0,    0,    0, 
            0,  496,  496,  496,  496,  496,  496,  496,  496,  496, 
          496,  496,  496,  496,  496,    0,  496,  496,  350,  496, 
          496,  496,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  350,  350,    0,    0,    0,  350,    0,    0, 
            0,  496,    0,    0,  496,    0,    0,  496,  496,    0, 
          496,    0,  496,    0,    0,    0,  496,    0,    0,    0, 
            0,    0,    0,    0,  496,  350,    0,    0,    0,  496, 
          496,  496,  496,  496,  496,    0,    0,    0,  496,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  496,  496, 
          496,  496,  496,  496,    0,    0,    0,  496,  496,    0, 
            0,    0,  496,  427,  496,  496,  496,  496,  496,  496, 
          496,    0,    0,  427,    0,  496,  496,  496,  496,  496, 
          496,  496,    0,    0,  496,    0,    0,    0,    0,    0, 
          496,  496,  496,  496,  496,  496,  496,  496,  496,  496, 
          496,  496,  496,  496,    0,  496,  496,  427,  496,  496, 
          496,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  427,  427,    0,   83,    0,  427,    0,    0,    0, 
          496,    0,    0,  496,    0,    0,  496,  496,    0,  496, 
            0,  496,    0,    0,    0,  496,    0,    0,    0,    0, 
            0,    0,    0,  496,  427,    0,  496,    0,  496,  496, 
          496,  496,  496,  496,    0,    0,    0,  496,    0,    0, 
            0,    0,    0,    0,    0,    0,  496,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  496,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  350,  350,  350,    0, 
            0,  350,  350,  350,    0,  350,    0,    0,    0,    0, 
            0,    0,    0,    0,  350,  350,  350,    0,    0,    0, 
          496,    0,    0,    0,  350,  350,    0,  350,  350,  350, 
          350,  350,    0,    0,  496,  496,    0,    0,    0,  496, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  350,  350,  350,  350,  350,  350,  350, 
          350,  350,  350,  350,  350,  350,  350,  496,    0,  350, 
          350,  350,    0,    0,  350,    0,    0,  350,    0,    0, 
          350,    0,  350,    0,  350,    0,  350,    0,  350,  350, 
          350,  350,  350,  350,  350,    0,  350,  350,  350,    0, 
            0,    0,    0,    0,    0,  273,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  273,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  427,  427,  427,    0,    0, 
          427,  427,  427,    0,  427,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  427,  427,    0,    0,    0,  273, 
            0,    0,    0,  427,  427,    0,  427,  427,  427,  427, 
          427,    0,    0,  273,  273,    0,   90,    0,  273,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  427,  427,  427,  427,  427,  427,  427,  427, 
          427,  427,  427,  427,  427,  427,  273,    0,  427,  427, 
          427,    0,  428,  427,    0,    0,  427,    0,    0,  427, 
            0,  427,    0,  427,    0,  427,    0,  427,  427,  427, 
          427,  427,  427,  427,  280,  427,    0,  427,    0,    0, 
            0,    0,    0,    0,  280,    0,    0,    0,  496,  496, 
          496,    0,    0,  496,  496,  496,    0,  496,    0,    0, 
            0,    0,    0,    0,    0,    0,  496,  496,  496,    0, 
            0,    0,    0,    0,    0,    0,  496,  496,  280,  496, 
          496,  496,  496,  496,    0,    0,    0,    0,    0,    0, 
            0,    0,  280,  280,    0,   89,    0,  280,    0,    0, 
            0,    0,    0,    0,    0,  496,  496,  496,  496,  496, 
          496,  496,  496,  496,  496,  496,  496,  496,  496,    0, 
            0,  496,  496,  496,    0,  280,  496,    0,    0,  496, 
            0,    0,  496,    0,  496,    0,  496,    0,  496,    0, 
          496,  496,  496,  496,  496,  496,  496,    0,  496,  496, 
          496,    0,    0,    0,    0,    0,    0,  281,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  281,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  273,  273,  273, 
            0,    0,  273,  273,  273,    0,  273,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  273,  273,    0,    0, 
            0,  281,    0,    0,    0,  273,  273,    0,  273,  273, 
          273,  273,  273,    0,    0,  281,  281,    0,   84,    0, 
          281,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  273,  273,  273,  273,  273,  273, 
          273,  273,  273,  273,  273,  273,  273,  273,  281,    0, 
          273,  273,  273,    0,    0,  273,    0,    0,  273,    0, 
            0,  273,    0,  273,    0,  273,    0,  273,    0,  273, 
          273,  273,  273,  273,  273,  273,  373,  273,    0,  273, 
            0,    0,    0,    0,    0,    0,  373,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  280,  280,  280,    0, 
            0,  280,  280,  280,    0,  280,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  280,  280,    0,    0,    0, 
          373,    0,    0,    0,  280,  280,    0,  280,  280,  280, 
          280,  280,    0,    0,  373,  373,    0,    0,    0,  373, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  280,  280,  280,  280,  280,  280,  280, 
          280,  280,  280,  280,  280,  280,  280,  373,    0,  280, 
          280,  280,    0,    0,  280,    0,    0,  280,    0,    0, 
          280,    0,  280,    0,  280,    0,  280,    0,  280,  280, 
          280,  280,  280,  280,  280,    0,  280,    0,  280,  290, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  290, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  281, 
          281,  281,    0,    0,  281,  281,  281,    0,  281,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  281,  281, 
            0,    0,    0,  290,    0,    0,    0,  281,  281,    0, 
          281,  281,  281,  281,  281,    0,    0,  290,  290,    0, 
            0,    0,  290,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  281,  281,  281,  281, 
          281,  281,  281,  281,  281,  281,  281,  281,  281,  281, 
          290,    0,  281,  281,  281,    0,    0,  281,    0,    0, 
          281,    0,    0,  281,    0,  281,    0,  281,    0,  281, 
            0,  281,  281,  281,  281,  281,  281,  281,  216,  281, 
            0,  281,    0,    0,    0,    0,    0,    0,  216,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  373,  373, 
          373,    0,    0,  373,  373,  373,    0,  373,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  373,  373,    0, 
            0,    0,  216,    0,    0,    0,  373,  373,    0,  373, 
          373,  373,  373,  373,    0,    0,  216,  216,    0,    0, 
            0,  216,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  373,  373,  373,  373,  373, 
          373,  373,  373,  373,  373,  373,  373,  373,  373,  322, 
            0,  373,  373,  373,    0,    0,  373,    0,    0,  373, 
            0,    0,  373,    0,  373,    0,  373,    0,  373,    0, 
          373,  373,  373,  373,  373,  373,  373,    0,  373,    0, 
          373,  287,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  287,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  290,  290,  290,    0,    0,  290,  290,  290,    0, 
          290,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          290,  290,    0,    0,    0,  287,    0,    0,    0,  290, 
          290,    0,  290,  290,  290,  290,  290,    0,    0,  287, 
          287,    0,    0,    0,  287,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  290,  290, 
          290,  290,  290,  290,  290,  290,  290,  290,  290,  290, 
          290,  290,  287,    0,  290,  290,  290,    0,    0,  290, 
            0,    0,  290,    0,    0,  290,    0,  290,    0,  290, 
            0,  290,    0,  290,  290,  290,  290,  290,  290,  290, 
          414,  290,    0,  290,    0,    0,    0,    0,    0,    0, 
          414,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          216,  216,  216,    0,    0,  216,  216,  216,    0,  216, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  216, 
          216,    0,    0,    0,  414,    0,    0,    0,  216,  216, 
            0,  216,  216,  216,  216,  216,    0,    0,  414,  414, 
            0,    0,    0,  414,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  216,  216,  216, 
          216,  216,  216,  216,  216,  216,  216,  216,  322,  216, 
          216,  414,    0,  216,  216,  322,    0,    0,  216,    0, 
            0,  216,    0,    0,  216,    0,  216,    0,  216,    0, 
          216,    0,  216,  216,  216,  216,  216,  216,  216,    0, 
          216,    0,  216,  415,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  415,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  287,  287,  287,    0,    0,  287,  287, 
          287,    0,  287,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  287,  287,    0,    0,    0,  415,    0,    0, 
            0,  287,  287,    0,  287,  287,  287,  287,  287,    0, 
            0,  415,  415,    0,    0,    0,  415,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          287,  287,  287,  287,  287,  287,  287,  287,  287,  287, 
          287,  287,  287,  287,  415,    0,  287,  287,  287,    0, 
            0,  287,    0,    0,  287,    0,    0,  287,    0,  287, 
            0,  287,    0,  287,    0,  287,  287,  287,  287,  287, 
          287,  287,  318,  287,    0,  287,    0,    0,    0,    0, 
            0,    0,  318,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  414,  414,  414,    0,    0,  414,  414,  414, 
            0,  414,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  414,  414,    0,    0,    0,  318,    0,    0,    0, 
          414,  414,    0,  414,  414,  414,  414,  414,    0,    0, 
          318,  318,    0,    0,    0,  318,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          414,  414,  414,  414,  414,  414,  414,  414,  414,  414, 
          414,  414,  414,  318,    0,  414,  414,  414,    0,    0, 
          414,    0,    0,  414,    0,    0,  414,    0,  414,    0, 
          414,    0,  414,    0,  414,  414,  414,  414,  414,  414, 
          414,    0,  414,    0,  414,  319,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  319,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  415,  415,  415,    0,    0, 
          415,  415,  415,    0,  415,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  415,  415,    0,    0,    0,  319, 
            0,    0,    0,  415,  415,    0,  415,  415,  415,  415, 
          415,    0,    0,  319,  319,    0,    0,    0,  319,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  415,  415,  415,  415,  415,  415,  415, 
          415,  415,  415,  415,  415,  415,  319,    0,  415,  415, 
          415,    0,    0,  415,    0,    0,  415,    0,    0,  415, 
            0,  415,    0,  415,    0,  415,    0,  415,  415,  415, 
          415,  415,  415,  415,  284,  415,    0,  415,    0,    0, 
            0,    0,    0,    0,  284,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  318,  318,  318,    0,    0,  318, 
          318,  318,    0,  318,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  318,    0,    0,    0,    0,  284,    0, 
            0,    0,  318,  318,    0,  318,  318,  318,  318,  318, 
            0,    0,  284,  284,    0,    0,    0,  284,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  318,  318,  318,  318,  318,  318,  318,  318,  318, 
          318,  318,  318,  318,  318,  284,    0,  318,  318,  318, 
            0,    0,  318,    0,    0,  318,    0,    0,    0,    0, 
            0,    0,  318,    0,  318,    0,  318,  318,  318,  318, 
          318,  318,  318,    0,  318,  194,  318,    0,    0,    0, 
            0,    0,    0,    0,    0,  194,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  319,  319,  319, 
            0,    0,  319,  319,  319,    0,  319,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  319,    0,    0,  194, 
            0,    0,    0,    0,    0,  319,  319,    0,  319,  319, 
          319,  319,  319,  194,  194,    0,    0,    0,  194,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  319,  319,  319,  319,  319,  319, 
          319,  319,  319,  319,  319,  319,  319,  319,    0,    0, 
          319,  319,  319,    0,    0,  319,    0,    0,  319,    0, 
            0,    0,    0,    0,    0,  319,    0,  319,    0,  319, 
          319,  319,  319,  319,  319,  319,  190,  319,    0,  319, 
            0,    0,    0,    0,    0,    0,  190,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  284,  284,  284,    0, 
            0,  284,  284,  284,    0,  284,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  284,    0,    0,    0,    0, 
          190,    0,    0,    0,  284,  284,    0,  284,  284,  284, 
          284,  284,    0,    0,  190,  190,    0,    0,    0,  190, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  284,  284,  284,  284,  284,  284,  284, 
          284,  284,  284,  284,  284,  284,  284,    0,    0,  284, 
          284,  284,    0,    0,  284,    0,    0,  284,    0,    0, 
            0,    0,    0,    0,  284,    0,  284,    0,  284,  284, 
          284,  284,  284,  284,  284,  187,  284,    0,  284,    0, 
            0,    0,    0,    0,    0,  187,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  194,  194,  194, 
            0,    0,  194,  194,  194,    0,  194,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  194,  194,    0,  187, 
            0,    0,    0,    0,    0,  194,  194,    0,  194,  194, 
          194,  194,  194,  187,  187,    0,    0,    0,  187,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  194,  194,  194,  194,  194, 
          194,  194,  194,  194,  194,    0,  194,  194,    0,    0, 
          194,  194,    0,    0,    0,  194,    0,    0,  194,    0, 
            0,  194,    0,  194,    0,  194,    0,  194,    0,  194, 
          194,  194,  194,  194,  194,  194,  189,  194,    0,  194, 
            0,    0,    0,    0,    0,    0,  189,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  190,  190, 
          190,    0,    0,  190,  190,  190,    0,  190,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  190,  190,    0, 
          189,    0,    0,    0,    0,    0,  190,  190,    0,  190, 
          190,  190,  190,  190,  189,  189,    0,    0,    0,  189, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  190,  190,  190,  190, 
          190,  190,  190,  190,  190,  190,    0,  190,  190,    0, 
            0,  190,  190,    0,    0,    0,  190,    0,    0,  190, 
            0,    0,  190,    0,  190,    0,  190,    0,  190,    0, 
          190,  190,  190,  190,  190,  190,  190,  188,  190,    0, 
          190,    0,    0,    0,    0,    0,    0,  188,    0,    0, 
            0,    0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,    0,  187,  187,  187,    0,    0,  187,  187,  187, 
            0,  187,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  187,  187,    0,    0,    0,  188,    0,    0,    0, 
          187,  187,    0,  187,  187,  187,  187,  187,    0,    0, 
          188,  188,    0,    0,    0,  188,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          187,  187,  187,  187,  187,  187,  187,  187,  187,  187, 
            0,  187,  187,    0,    0,  187,  187,    0,    0,    0, 
          187,    0,    0,  187,    0,    0,  187,    0,  187,    0, 
          187,    0,  187,    0,  187,  187,  187,  187,  187,  187, 
          187,  191,  187,    0,  187,    0,    0,    0,    0,    0, 
            0,  191,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  189,  189,  189,    0,    0,  189,  189, 
          189,    0,  189,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  189,  189,    0,  191,    0,    0,    0,    0, 
            0,  189,  189,    0,  189,  189,  189,  189,  189,  191, 
          191,    0,    0,    0,  191,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  189,  189,  189,  189,  189,  189,  189,  189,  189, 
          189,    0,  189,  189,    0,    0,  189,  189,    0,    0, 
            0,  189,    0,    0,  189,    0,    0,  189,    0,  189, 
            0,  189,    0,  189,    0,  189,  189,  189,  189,  189, 
          189,  189,  192,  189,    0,  189,    0,    0,    0,    0, 
            0,    0,  192,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  188,  188,  188,    0,    0,  188, 
          188,  188,    0,  188,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  188,  188,    0,  192,    0,    0,    0, 
            0,    0,  188,  188,    0,  188,  188,  188,  188,  188, 
          192,  192,    0,    0,    0,  192,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  188,  188,  188,  188,  188,  188,  188,  188, 
          188,  188,    0,  188,  188,    0,    0,  188,  188,    0, 
            0,    0,  188,    0,    0,  188,    0,    0,  188,    0, 
          188,    0,  188,    0,  188,    0,  188,  188,  188,  188, 
          188,  188,  188,  427,  188,    0,  188,    0,    0,    0, 
            0,    0,    0,  427,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  191,  191,  191,    0,    0,  191,  191, 
          191,    0,  191,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  191,  191,    0,    0,    0,   75,    0,    0, 
            0,  191,  191,    0,  191,  191,  191,  191,  191,    0, 
            0,    0,  427,    0,   83,    0,  427,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  191,  191,  191,  191,  191,  191,  191,  191,  191, 
          191,    0,  191,  191,  427,    0,  191,  191,    0,    0, 
            0,  191,    0,    0,  191,    0,    0,  191,    0,  191, 
            0,  191,    0,  191,    0,  191,  191,  191,  191,  191, 
          191,  191,    0,  191,  273,  191,    0,    0,    0,    0, 
            0,    0,    0,    0,  273,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  192,  192,  192,    0,    0,  192, 
          192,  192,    0,  192,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  192,  192,    0,    0,    0,   82,    0, 
            0,    0,  192,  192,    0,  192,  192,  192,  192,  192, 
            0,    0,    0,  273,    0,   90,    0,  273,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  192,  192,  192,  192,  192,  192,  192,  192, 
          192,  192,    0,  192,  192,  273,    0,  192,  192,    0, 
            0,    0,  192,    0,    0,  192,    0,    0,  192,    0, 
          192,    0,  192,    0,  192,    0,  192,  192,  192,  192, 
          192,  192,  192,    0,  192,  280,  192,  313,  314,  315, 
          316,  317,  318,  319,  320,  280,  322,  323,    0,    0, 
            0,    0,    0,  326,  327,  427,  427,  427,    0,    0, 
            0,  427,  427,    0,  427,    0,    0,    0,  328,    0, 
          329,    0,  330,  331,  332,  333,  334,  335,  336,   81, 
          337,    0,    0,  427,  427,    0,  427,  427,  427,  427, 
          427,    0,    0,    0,  280,    0,   89,    0,  280,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  427,  427,  427,  427,  427,  427,  427,  427, 
          427,  427,  427,  427,  427,  427,  280,    0,  427,  427, 
          427,    0,  428,    0,    0,    0,  427,    0,    0,    0, 
            0,    0,    0,  427,    0,  427,    0,  427,  427,  427, 
          427,  427,  427,  427,    0,  427,  281,  427,  313,  314, 
          315,  316,  317,  318,  319,    0,  281,  322,  323,    0, 
            0,    0,    0,    0,  326,  327,  273,  273,  273,    0, 
            0,    0,  273,  273,    0,  273,    0,    0,    0,  328, 
            0,  329,    0,  330,  331,  332,  333,  334,  335,  336, 
           76,  337,    0,    0,  273,  273,    0,  273,  273,  273, 
          273,  273,    0,    0,    0,  281,    0,   84,    0,  281, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  273,  273,  273,  273,  273,  273,  273, 
          273,  273,  273,  273,  273,  273,  273,  281,    0,  273, 
          273,  273,    0,    0,    0,    0,    0,  273,    0,    0, 
            0,    0,    0,    0,  273,    0,  273,    0,  273,  273, 
          273,  273,  273,  273,  273,  185,  273,    0,  273,    0, 
            0,    0,    0,    0,    0,  185,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  280,  280,  280, 
            0,    0,    0,  280,  280,    0,  280,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  185, 
            0,    0,    0,    0,    0,  280,  280,    0,  280,  280, 
          280,  280,  280,  185,  185,    0,    0,    0,  185,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  280,  280,  280,  280,  280,  280, 
          280,  280,  280,  280,  280,  280,  280,  280,    0,    0, 
          280,  280,  280,    0,    0,    0,    0,    0,  280,    0, 
            0,    0,    0,    0,    0,  280,    0,  280,    0,  280, 
          280,  280,  280,  280,  280,  280,  186,  280,    0,  280, 
            0,    0,    0,    0,    0,    0,  186,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  281,  281, 
          281,    0,    0,    0,  281,  281,    0,  281,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          186,    0,    0,    0,    0,    0,  281,  281,    0,  281, 
          281,  281,  281,  281,  186,  186,    0,    0,    0,  186, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  281,  281,  281,  281,  281, 
          281,  281,  281,  281,  281,  281,  281,  281,  281,    0, 
            0,  281,  281,  281,    0,    0,    0,    0,    0,  281, 
            0,    0,    0,    0,    0,    0,  281,    0,  281,    0, 
          281,  281,  281,  281,  281,  281,  281,  210,  281,    0, 
          281,    0,    0,    0,    0,    0,    0,  210,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  185,  185,  185, 
            0,    0,  185,  185,  185,    0,  185,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  185,  185,    0,    0, 
            0,  210,    0,    0,    0,  185,  185,    0,  185,  185, 
          185,  185,  185,    0,    0,  210,  210,    0,    0,    0, 
          210,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  185,  185,  185,  185,  185, 
          185,  185,  185,  185,  185,    0,  185,  185,    0,    0, 
          185,  185,    0,    0,    0,  185,    0,    0,  185,    0, 
            0,  185,    0,  185,    0,    0,    0,  185,    0,    0, 
            0,  185,  185,  185,  185,  185,  211,  185,    0,  185, 
            0,    0,    0,    0,    0,    0,  211,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  186,  186, 
          186,    0,    0,  186,  186,  186,    0,  186,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  186,  186,    0, 
          211,    0,    0,    0,    0,    0,  186,  186,    0,  186, 
          186,  186,  186,  186,  211,  211,    0,    0,    0,  211, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  186,  186,  186,  186, 
          186,  186,  186,  186,  186,  186,    0,  186,  186,    0, 
            0,  186,  186,    0,    0,    0,  186,    0,    0,  186, 
            0,    0,  186,    0,  186,    0,    0,    0,  186,    0, 
            0,    0,  186,  186,  186,  186,  186,  197,  186,    0, 
          186,    0,    0,    0,    0,    0,    0,  197,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  210, 
          210,  210,    0,    0,  210,  210,  210,    0,  210,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  210,  210, 
            0,  197,    0,    0,    0,    0,    0,  210,  210,    0, 
          210,  210,  210,  210,  210,  197,  197,    0,    0,    0, 
          197,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  210,  210,  210, 
          210,  210,  210,  210,  210,  210,  210,    0,  210,  210, 
            0,    0,  210,  210,    0,    0,    0,  210,    0,    0, 
          210,    0,  195,  210,    0,  210,    0,    0,    0,  210, 
            0,    0,  195,    0,    0,  210,  210,  210,    0,  210, 
            0,  210,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  211,  211, 
          211,    0,    0,  211,  211,  211,  195,  211,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  211,  211,    0, 
          195,  195,    0,    0,    0,  195,  211,  211,    0,  211, 
          211,  211,  211,  211,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  211,  211,  211,  211, 
          211,  211,  211,  211,  211,  211,    0,  211,  211,    0, 
            0,  211,  211,  196,    0,    0,  211,    0,    0,  211, 
            0,    0,  211,  196,  211,    0,    0,    0,  211,    0, 
            0,    0,    0,    0,  211,  211,  211,    0,  211,    0, 
          211,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  196,    0,  197, 
          197,  197,    0,    0,  197,  197,  197,    0,  197,    0, 
            0,  196,  196,    0,    0,    0,  196,    0,  197,  197, 
            0,    0,    0,    0,    0,    0,    0,  197,  197,    0, 
          197,  197,  197,  197,  197,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  197,  197,  197, 
          197,  197,  197,  197,  197,  197,  197,    0,  197,  197, 
            0,  200,    0,    0,    0,    0,    0,  197,    0,    0, 
          197,  200,    0,  197,    0,  197,    0,    0,    0,  197, 
            0,    0,    0,    0,    0,  197,  197,  197,    0,  197, 
            0,  197,    0,    0,  195,  195,  195,    0,    0,  195, 
          195,  195,    0,  195,    0,  200,    0,    0,    0,    0, 
            0,    0,    0,  195,  195,    0,    0,    0,    0,  200, 
          200,    0,  195,  195,  200,  195,  195,  195,  195,  195, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  195,  195,  195,  195,  195,  195,  195,  195, 
          195,  195,    0,  195,  195,    0,    0,    0,    0,  202, 
            0,    0,  195,    0,    0,  195,    0,    0,  195,  202, 
          195,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          195,  195,  195,    0,  195,    0,  195,    0,    0,    0, 
            0,    0,    0,    0,    0,  196,  196,  196,    0,    0, 
          196,  196,  196,  202,  196,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  196,  196,    0,  202,  202,    0, 
            0,    0,  202,  196,  196,    0,  196,  196,  196,  196, 
          196,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  196,  196,  196,  196,  196,  196,  196, 
          196,  196,  196,    0,  196,  196,    0,  201,    0,    0, 
            0,    0,    0,  196,    0,    0,  196,  201,    0,  196, 
            0,  196,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  196,  196,  196,    0,  196,    0,  196,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  201,    0,  200,  200,  200,    0,    0,  200,  200, 
          200,    0,  200,    0,    0,  201,  201,    0,    0,    0, 
          201,    0,  200,  200,    0,    0,    0,    0,    0,    0, 
            0,  200,  200,    0,  200,  200,  200,  200,  200,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  200,  200,  200,  200,  200,  200,  200,  200,  200, 
          200,    0,  200,  200,    0,  199,    0,    0,    0,    0, 
            0,  200,    0,    0,  200,  199,    0,  200,    0,  200, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  200, 
          200,    0,    0,    0,    0,  200,    0,    0,    0,    0, 
            0,  202,  202,  202,    0,    0,  202,  202,  202,  199, 
          202,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          202,  202,    0,  199,  199,    0,    0,    0,  199,  202, 
          202,    0,  202,  202,  202,  202,  202,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  202, 
          202,  202,  202,  202,  202,  202,  202,  202,  202,    0, 
          202,  202,    0,  198,    0,    0,    0,    0,    0,  202, 
            0,    0,  202,  198,    0,  202,    0,  202,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  202,  202,    0, 
            0,    0,    0,  202,    0,    0,    0,    0,    0,  201, 
          201,  201,    0,    0,  201,  201,  201,  198,  201,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  201,  201, 
            0,  198,  198,    0,    0,    0,  198,  201,  201,    0, 
          201,  201,  201,  201,  201,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  201,  201,  201, 
          201,  201,  201,  201,  201,  201,  201,    0,  201,  201, 
            0,  203,    0,    0,    0,    0,    0,  201,    0,    0, 
          201,  203,    0,  201,    0,  201,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  201,  201,    0,    0,    0, 
            0,  201,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  203,    0,  199,  199,  199, 
            0,    0,  199,  199,  199,    0,  199,    0,    0,  203, 
          203,    0,    0,    0,  203,    0,  199,  199,    0,    0, 
            0,    0,    0,    0,    0,  199,  199,    0,  199,  199, 
          199,  199,  199,    0,    0,    0,    0,    0,  204,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  204,    0, 
            0,    0,    0,    0,    0,  199,  199,  199,  199,  199, 
          199,  199,  199,  199,  199,    0,  199,  199,    0,    0, 
            0,    0,    0,    0,    0,  199,    0,    0,  199,    0, 
            0,  199,  204,  199,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  199,  199,    0,  204,  204,    0,  199, 
            0,  204,    0,    0,    0,  198,  198,  198,    0,    0, 
          198,  198,  198,    0,  198,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  198,  198,    0,    0,    0,    0, 
            0,    0,    0,  198,  198,    0,  198,  198,  198,  198, 
          198,  205,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  205,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  198, 
          198,    0,    0,    0,  198,  198,    0,    0,    0,    0, 
            0,    0,    0,  198,    0,  205,  198,    0,    0,  198, 
            0,  198,    0,    0,    0,    0,    0,    0,    0,  205, 
          205,    0,    0,    0,  205,    0,    0,  198,    0,    0, 
            0,    0,    0,  203,  203,  203,    0,    0,  203,  203, 
          203,    0,  203,    0,    0,    0,    0,    0,    0,  212, 
            0,    0,  203,  203,    0,    0,    0,    0,    0,  212, 
            0,  203,  203,    0,  203,  203,  203,  203,  203,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  212,    0,    0,    0,  203,  203,    0, 
            0,    0,  203,  203,    0,    0,    0,  212,  212,    0, 
            0,  203,  212,    0,  203,    0,    0,  203,    0,  203, 
          204,  204,  204,    0,    0,  204,  204,  204,    0,  204, 
            0,    0,    0,    0,    0,  203,  206,    0,    0,  204, 
          204,    0,    0,    0,    0,    0,  206,    0,  204,  204, 
            0,  204,  204,  204,  204,  204,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          206,    0,    0,    0,  204,  204,    0,    0,    0,  204, 
          204,    0,    0,    0,  206,  206,    0,    0,  204,  206, 
            0,  204,    0,    0,  204,    0,  204,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  204,  205,  205,  205,  207,    0,  205,  205, 
          205,    0,  205,    0,    0,    0,  207,    0,    0,    0, 
            0,    0,  205,  205,    0,    0,    0,    0,    0,    0, 
            0,  205,  205,    0,  205,  205,  205,  205,  205,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          207,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  207,  207,    0,  205,  205,  207, 
            0,    0,  205,  205,    0,    0,    0,    0,    0,    0, 
            0,  205,    0,    0,  205,    0,    0,  205,    0,  205, 
            0,  212,  212,  212,  213,    0,  212,  212,  212,    0, 
          212,    0,    0,    0,  213,  205,    0,    0,    0,    0, 
          212,  212,    0,    0,    0,    0,    0,    0,    0,  212, 
          212,    0,  212,  212,  212,  212,  212,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   42,    0,  213,    0, 
            0,    0,    0,    0,    0,    0,   42,    0,    0,    0, 
            0,    0,  213,  213,    0,  212,  212,  213,    0,    0, 
          212,  212,    0,    0,    0,    0,    0,    0,    0,  212, 
            0,    0,  212,    0,    0,  212,    0,  212,  206,  206, 
          206,  184,    0,  206,  206,  206,    0,  206,    0,    0, 
            0,  184,    0,  212,   42,   42,    0,  206,  206,    0, 
            0,    0,    0,    0,    0,    0,  206,  206,    0,  206, 
          206,  206,  206,  206,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  217,    0,  184,    0,    0,    0,    0, 
            0,    0,    0,  217,    0,    0,    0,    0,    0,  184, 
          184,    0,  206,  206,  184,    0,    0,  206,  206,    0, 
            0,    0,    0,    0,    0,    0,  206,    0,    0,  206, 
            0,    0,  206,    0,  206,    0,    0,  217,  207,  207, 
          207,    0,    0,  207,  207,  207,    0,  207,    0,    0, 
          206,  217,  217,    0,    0,    0,    0,  207,  207,    0, 
            0,    0,    0,    0,    0,    0,  207,  207,    0,  207, 
          207,  207,  207,  207,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  214,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  214,    0,    0,    0,    0, 
            0,    0,  207,  207,    0,    0,    0,  207,  207,    0, 
            0,    0,    0,    0,    0,    0,  207,    0,    0,  207, 
            0,    0,  207,    0,  207,    0,  213,  213,  213,  214, 
            0,  213,  213,  213,    0,  213,    0,    0,    0,    0, 
          207,    0,    0,  214,  214,  213,  213,    0,    0,    0, 
            0,    0,    0,    0,  213,  213,    0,  213,  213,  213, 
          213,  213,    0,    0,    0,    0,    0,    0,   42,   42, 
           42,    0,  182,   42,   42,   42,    0,   42,    0,    0, 
            0,    0,  182,    0,    0,    0,    0,   42,    0,    0, 
            0,  213,    0,    0,    0,  213,  213,    0,    0,   42, 
           42,   42,   42,   42,  213,    0,    0,  213,    0,    0, 
          213,    0,  213,  184,  184,  184,  182,    0,  184,  184, 
          184,    0,  184,    0,    0,    0,    0,    0,  213,    0, 
          182,  182,  184,  184,    0,    0,    0,    0,    0,    0, 
            0,  184,  184,    0,  184,  184,  184,  184,  184,   42, 
            0,    0,    0,    0,    0,  217,  217,  217,    0,  175, 
          217,  217,  217,    0,  217,    0,    0,    0,    0,  175, 
           42,    0,    0,    0,  217,  217,    0,    0,    0,    0, 
            0,    0,    0,  217,  217,    0,  217,  217,  217,  217, 
          217,  184,    0,    0,  184,    0,    0,  184,    0,  184, 
          181,    0,    0,  175,    0,    0,    0,    0,    0,    0, 
          181,    0,    0,    0,    0,  184,    0,  175,  175,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  217,    0,    0,  217,    0,    0,  217, 
            0,  217,    0,    0,  181,    0,    0,  214,  214,  214, 
            0,    0,  214,  214,  214,    0,  214,  217,  181,  181, 
            0,    0,    0,  215,    0,    0,  214,  214,    0,    0, 
            0,    0,    0,  215,    0,  214,  214,    0,  214,  214, 
          214,  214,  214,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  215,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  215,  215,    0,    0,  214,    0,    0,  214,    0, 
            0,  214,    0,  214,  182,  182,  182,    0,    0,  182, 
          182,  182,    0,  182,    0,    0,    0,    0,    0,  214, 
          177,    0,    0,  182,  182,    0,    0,    0,    0,    0, 
          177,    0,  182,  182,    0,  182,  182,  182,  182,  182, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  178,    0,    0, 
            0,    0,    0,    0,  177,    0,    0,  178,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  177,  177, 
            0,    0,  182,    0,    0,  182,    0,    0,  182,    0, 
          182,  175,  175,  175,    0,    0,  175,  175,  175,    0, 
          175,  178,    0,    0,    0,    0,  182,    0,    0,    0, 
          175,  175,    0,    0,    0,  178,  178,    0,    0,  175, 
          175,    0,  175,  175,  175,  175,  175,    0,    0,    0, 
            0,    0,  181,  181,  181,    0,    0,  181,  181,  181, 
            0,  181,    0,    0,    0,    0,    0,  179,    0,    0, 
            0,  181,  181,    0,    0,    0,    0,  179,    0,    0, 
          181,  181,    0,  181,  181,  181,  181,  181,    0,  175, 
            0,    0,  175,    0,    0,  175,    0,  175,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  180,    0, 
            0,  179,    0,  175,    0,  215,  215,  215,  180,    0, 
          215,  215,  215,    0,  215,  179,  179,    0,    0,    0, 
          181,    0,    0,  181,  215,  215,  181,    0,  181,    0, 
            0,    0,    0,  215,  215,    0,  215,  215,  215,  215, 
          215,    0,  180,    0,  181,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  180,  180,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  215,    0,    0,  215,    0,    0,  215, 
            0,  215,  177,  177,  177,    0,  174,  177,  177,  177, 
            0,  177,    0,    0,    0,    0,  174,  215,    0,    0, 
            0,  177,  177,    0,    0,    0,    0,    0,    0,    0, 
          177,  177,    0,  177,  177,  177,  177,  177,    0,  178, 
          178,  178,    0,  176,  178,  178,  178,    0,  178,    0, 
          174,    0,    0,  176,    0,    0,    0,    0,  178,  178, 
            0,    0,    0,    0,  174,  174,    0,  178,  178,    0, 
          178,  178,  178,  178,  178,    0,    0,    0,    0,    0, 
          177,    0,    0,  177,    0,    0,  177,  176,  177,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  176,  176,    0,  177,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  178,    0,    0, 
          178,    0,    0,  178,    0,  178,    0,    0,    0,  179, 
          179,  179,    0,    0,  179,  179,  179,  261,  179,    0, 
            0,  178,    0,    0,    0,    0,    0,  261,  179,  179, 
            0,    0,    0,    0,    0,    0,    0,  179,  179,    0, 
          179,  179,  179,  179,  179,    0,    0,    0,    0,    0, 
          180,  180,  180,    0,  173,  180,  180,  180,    0,  180, 
            0,  261,    0,    0,  173,    0,    0,    0,    0,  180, 
          180,    0,    0,    0,    0,  261,  261,    0,  180,  180, 
            0,  180,  180,  180,  180,  180,    0,  179,    0,    0, 
          179,    0,    0,  179,    0,  179,    0,    0,  173,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  179,  173,  173,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  180,    0, 
            0,  180,    0,    0,  180,    0,  180,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  174,  174, 
          174,    0,  180,  174,  174,  174,    0,  174,    0,    0, 
            0,    0,    0,  262,    0,    0,    0,  174,  174,    0, 
            0,    0,    0,  262,    0,    0,  174,  174,    0,  174, 
          174,  174,  174,  174,    0,  176,  176,  176,    0,    0, 
          176,  176,  176,    0,  176,    0,    0,    0,    0,  497, 
            0,    0,    0,    0,  176,  176,    0,  262,    0,  497, 
            0,    0,    0,  176,  176,    0,  176,  176,  176,  176, 
          176,  262,  262,    0,    0,    0,  174,    0,    0,  174, 
            0,    0,  174,    0,  174,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          174,    0,    0,    0,    0,    0,    0,  497,  497,    0, 
            0,    0,    0,  176,    0,    0,  176,    0,    0,  176, 
            0,  176,    0,    0,    0,    0,    0,    0,    0,  261, 
          261,  261,    0,    0,  261,  261,  261,  176,  261,    0, 
            0,    0,    0,   53,    0,    0,    0,    0,  261,  261, 
            0,    0,    0,   53,    0,    0,    0,  261,  261,    0, 
          261,  261,  261,  261,  261,    0,  173,  173,  173,    0, 
            0,  173,  173,  173,    0,  173,    0,    0,    0,   55, 
            0,    0,    0,    0,    0,  173,  173,    0,    0,   55, 
            0,    0,    0,    0,  173,  173,    0,  173,  173,  173, 
          173,   53,   53,    0,    0,    0,    0,    0,    0,    0, 
          261,    0,    0,  261,    0,  261,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  261,    0,   57,    0,    0,    0,   55,   55,    0, 
            0,    0,    0,   57,  173,    0,    0,  173,    0,    0, 
          173,    0,  173,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  173,   43, 
            0,    0,    0,    0,    0,  262,  262,  262,    0,   43, 
          262,  262,  262,    0,  262,    0,    0,    0,    0,    0, 
            0,   57,   57,    0,  262,  262,    0,    0,    0,    0, 
            0,    0,    0,  262,  262,    0,  262,  262,  262,  262, 
          262,  497,  497,  497,    0,    0,  497,  497,  497,    0, 
          497,    0,    0,   48,    0,    0,    0,   43,   43,    0, 
          497,  497,    0,   48,    0,    0,    0,    0,    0,  497, 
          497,    0,  497,  497,  497,  497,  497,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  262,    0,    0,  262, 
          263,  262,    0,    0,    0,    0,    0,    0,    0,    0, 
          263,    0,    0,    0,    0,    0,    0,  262,    0,    0, 
            0,   48,   48,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  497,    0,    0,  497,    0,  497,    0,    0, 
            0,    0,    0,    0,  262,   53,   53,   53,    0,    0, 
           53,   53,   53,  497,   53,    0,    0,    0,  263,  263, 
            0,    0,    0,    0,   53,   53,    0,    0,    0,    0, 
            0,    0,    0,   53,   53,    0,   53,   53,   53,   53, 
           53,   55,   55,   55,    0,    0,   55,   55,   55,    0, 
           55,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           55,   55,    0,    0,    0,    0,    0,    0,    0,   55, 
           55,    0,   55,   55,   55,   55,   55,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   53,    0,    0,   53, 
            0,    0,    0,    0,    0,   57,   57,   57,    0,    0, 
           57,   57,   57,    0,   57,    0,    0,   53,    0,    0, 
            0,    0,  397,    0,   57,   57,    0,    0,    0,    0, 
            0,    0,   55,   57,   57,   55,   57,   57,   57,   57, 
           57,   43,   43,   43,    0,    0,   43,   43,   43,    0, 
           43,    0,    0,   55,    0,    0,    0,    0,    0,    0, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,   43, 
           43,    0,   43,   43,   43,   43,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   57,    0,    0,   57, 
            0,    0,    0,    0,    0,   48,   48,   48,    0,    0, 
           48,   48,   48,    0,   48,    0,    0,   57,    0,    0, 
            0,    0,    0,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,   43,   48,   48,    0,   48,   48,   48,   48, 
           48,    0,  263,  263,  263,    0,    0,  263,  263,  263, 
            0,  263,    0,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  263,  263,  263,  263,  263,    0,    0, 
            0,    0,    0,    0,    0,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   48,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          263,    0,    0,  263,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    7,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,  263, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,    0,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   46,    0,    0,   47, 
            0,    0,   48,   49,    0,   50,    0,   51,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,   53, 
            0,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,   60,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   97,   98, 
           17,   18,    0,    0,    0,    0,   99,  100,  101,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,   39,   40,    0,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  108,    0,    0,   48,   49,    0, 
           50,    0,  609,    0,  233,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,   54, 
           55,   56,   57,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   97,   98,   17,   18,    0,    0,    0, 
            0,   99,  100,  101,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,    0,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,  108, 
            0,    0,   48,   49,    0,   50,    0,  613,    0,  233, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   97,   98, 
           17,   18,    0,    0,    0,    0,   99,   20,   21,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,   39,   40,    0,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  108,    0,    0,   48,   49,    0, 
           50,    0,  609,    0,  233,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,   54, 
           55,   56,   57,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   97,   98,   17,   18,    0,    0,    0, 
            0,   99,  100,  101,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,    0,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,  108, 
            0,    0,   48,   49,    0,   50,    0,  809,    0,  233, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   97,   98, 
           17,   18,    0,    0,    0,    0,   99,  100,  101,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,   39,   40,    0,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  108,    0,    0,   48,   49,    0, 
           50,    0,  813,    0,  233,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,   54, 
           55,   56,   57,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   97,   98,   17,   18,    0,    0,    0, 
            0,   99,  100,  101,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,    0,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,  108, 
            0,    0,   48,   49,    0,   50,    0,  817,    0,  233, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   97,   98, 
           17,   18,    0,    0,    0,    0,   99,  100,  101,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,   39,   40,    0,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  108,    0,    0,   48,   49,    0, 
           50,    0,  871,    0,  233,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,   54, 
           55,   56,   57,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   97,   98,   17,   18,    0,    0,    0, 
            0,   99,  100,  101,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,    0,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,  108, 
            0,    0,   48,   49,    0,   50,    0,  873,    0,  233, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   97,   98, 
           17,   18,    0,    0,    0,    0,   99,  100,  101,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,   39,   40,    0,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  108,    0,    0,   48,   49,    0, 
           50,    0,  885,    0,  233,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,   54, 
           55,   56,   57,   58,   59,  251,  251,  251,    0,  251, 
            0,    0,    0,  251,  251,    0,    0,    0,  251,    0, 
          251,  251,  251,  251,  251,  251,  251,    0,    0,    0, 
            0,  251,  251,  251,  251,  251,  251,  251,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  251,    0,    0, 
          251,  251,  251,  251,  251,  251,  251,  251,  251,  251, 
            0,  251,  251,    0,  251,  251,  251,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  251,    0,    0,  251, 
            0,    0,  251,  251,    0,  251,    0,  251,    0,  251, 
            0,  251,    0,    0,    0,    0,    0,    0,    0,  251, 
            0,    0,    0,    0,  251,  251,  251,  251,  251,  251, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,   39,   40,    0,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  108,    0,    0,   48,   49,    0, 
           50,    0,    0,    0,    0,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,   53,    0,    0,    0,    0,   54, 
           55,   56,   57,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   97,   98,   17,   18,    0,    0,    0, 
            0,   99,   20,   21,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,    0,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,  108, 
            0,    0,   48,   49,    0,   50,    0,  269,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   97,   98, 
           17,   18,    0,    0,    0,    0,   99,  100,  101,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,   39,   40,    0,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  108,  427,    0,   48,   49,    0, 
           50,    0,    0,    0,    0,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,   54, 
           55,   56,   57,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,    0,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,  108, 
            0,    0,   48,   49,    0,   50,    0,  524,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   97,   98, 
           17,   18,    0,    0,    0,    0,   99,  100,  101,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,   39,   40,    0,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  108,    0,    0,   48,   49,    0, 
           50,    0,  524,    0,    0,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,   54, 
           55,   56,   57,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   97,   98,   17,   18,    0,    0,    0, 
            0,   99,  100,  101,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,    0,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,  108, 
            0,    0,   48,   49,    0,   50,    0,  591,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   97,   98, 
           17,   18,    0,    0,    0,    0,   99,  100,  101,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,   39,   40,    0,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  108,    0,    0,   48,   49,    0, 
           50,    0,  640,    0,    0,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,   54, 
           55,   56,   57,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   97,   98,   17,   18,    0,    0,    0, 
            0,   99,  100,  101,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,    0,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,  108, 
            0,    0,   48,   49,    0,   50,    0,  774,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   97,   98, 
           17,   18,    0,    0,    0,    0,   99,  100,  101,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,   39,   40,    0,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  108,    0,    0,   48,   49,    0, 
           50,    0,  803,    0,    0,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,   54, 
           55,   56,   57,   58,   59,  487,  487,  487,    0,  487, 
            0,    0,    0,  487,  487,    0,    0,    0,  487,    0, 
          487,  487,  487,  487,  487,  487,  487,    0,    0,    0, 
            0,  487,  487,  487,  487,  487,  487,  487,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  487,    0,    0, 
          487,  487,  487,  487,  487,  487,  487,  487,  487,  487, 
            0,  487,  487,    0,  487,  487,  487,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  487,    0,    0,  487, 
          487,    0,  487,  487,    0,  487,    0,    0,    0,    0, 
            0,  487,    0,    0,    0,    0,    0,    0,    0,  487, 
            0,    0,    0,    0,  487,  487,  487,  487,  487,  487, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   97,   98, 
           17,   18,    0,    0,    0,    0,   99,  100,  101,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,   39,   40,    0,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  108,    0,    0,   48,   49,    0, 
           50,    0,    0,    0,    0,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,   54, 
           55,   56,   57,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,    0,   43,   44,   45,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,  108, 
            0,    0,   48,   49,    0,   50,    0,    0,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   97,   98, 
           17,   18,    0,    0,    0,    0,   99,  100,  101,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  102,    0,    0,   31,   32,  103,   34,   35, 
           36,  104,   38,   39,   40,    0,   41,   42,    0,    0, 
            0,  105,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  106,    0, 
            0,  107,    0,    0,  108,    0,    0,   48,   49,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   54, 
           55,   56,   57,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   97,   98,   17,   18,    0,    0,    0, 
            0,   99,  100,  101,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  102,    0,    0, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,    0,    0,    0,  105,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  225,    0,    0,   47, 
            0,    0,   48,   49,    0,   50,    0,   51,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   97,   98, 
           17,   18,    0,    0,    0,    0,   99,  100,  101,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  102,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,   39,   40,    0,   41,   42,    0,    0, 
            0,  105,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  279,    0,    0,  349,    0,    0,   48,   49,    0, 
           50,    0,  350,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   54, 
           55,   56,   57,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   97,   98,   17,   18,    0,    0,    0, 
            0,   99,  100,  101,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  102,    0,    0, 
           31,   32,  103,   34,   35,   36,  104,   38,   39,   40, 
            0,   41,   42,    0,    0,    0,  105,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  107,    0,    0,  108, 
            0,    0,   48,   49,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   97,   98, 
           17,   18,    0,    0,    0,    0,   99,  100,  101,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  102,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,   39,   40,    0,   41,   42,    0,    0, 
            0,  105,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  279,    0,    0,  108,    0,    0,   48,   49,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   54, 
           55,   56,   57,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   97,   98,   17,   18,    0,    0,    0, 
            0,   99,  100,  101,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  102,    0,    0, 
           31,   32,   33,   34,   35,   36,   37,   38,   39,   40, 
            0,   41,   42,    0,    0,    0,  105,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  792,    0,    0,  108, 
            0,    0,   48,   49,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
          117,  118,  119,  120,  121,  122,  123,  124,    0,    0, 
          125,  126,  127,  128,  129,    0,    0,  130,  131,  132, 
          133,  134,  135,  136,    0,    0,  137,  138,  139,  193, 
          194,  195,  196,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  155,  197,  198,  199,  159,  252, 
            0,  200,    0,    0,    0,    0,    0,    0,    0,  161, 
          162,    0,  163,  164,  165,  166,    0,  167,  168,    0, 
            0,  169,    0,    0,    0,    0,  170,  171,  172,  173, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  175,  176,    0,  177,  178,  179,  180,  181, 
          182,  183,  184,  185,    0,  186,    0,    0,  187,  201, 
          117,  118,  119,  120,  121,  122,  123,  124,    0,    0, 
          125,  126,  127,  128,  129,    0,    0,  130,  131,  132, 
          133,  134,  135,  136,    0,    0,  137,  138,  139,  193, 
          194,  195,  196,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  155,  197,  198,  199,  159,    0, 
            0,  200,    0,    0,    0,    0,    0,    0,    0,  161, 
          162,    0,  163,  164,  165,  166,    0,  167,  168,    0, 
            0,  169,    0,    0,    0,    0,  170,  171,  172,  173, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  175,  176,    0,  177,  178,  179,  180,  181, 
          182,  183,  184,  185,    0,  186,    0,    0,  187,  201, 
          117,  118,  119,  120,  121,  122,  123,  124,    0,    0, 
          125,  126,  127,  128,  129,    0,    0,  130,  131,  132, 
          133,  134,  135,  136,    0,    0,  137,  138,  139,  140, 
          141,  142,  143,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  155,  156,  157,  158,  159,   35, 
           36,  160,   38,    0,    0,    0,    0,    0,    0,  161, 
          162,    0,  163,  164,  165,  166,    0,  167,  168,    0, 
            0,  169,    0,    0,    0,    0,  170,  171,  172,  173, 
            0,    0,    0,    0,    0,  174,    0,    0,    0,    0, 
            0,    0,  175,  176,    0,  177,  178,  179,  180,  181, 
          182,  183,  184,  185,    0,  186,    0,    0,  187,  117, 
          118,  119,  120,  121,  122,  123,  124,    0,    0,  125, 
          126,  127,  128,  129,    0,    0,  130,  131,  132,  133, 
          134,  135,  136,    0,    0,  137,  138,  139,  193,  194, 
          195,  196,  144,  145,  146,  147,  148,  149,  150,  151, 
          152,  153,  154,  155,  197,  198,  199,  159,  287,  288, 
          200,  289,    0,    0,    0,    0,    0,    0,  161,  162, 
            0,  163,  164,  165,  166,    0,  167,  168,    0,    0, 
          169,    0,    0,    0,    0,  170,  171,  172,  173,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  175,  176,    0,  177,  178,  179,  180,  181,  182, 
          183,  184,  185,    0,  186,    0,    0,  187,  117,  118, 
          119,  120,  121,  122,  123,  124,    0,    0,  125,  126, 
          127,  128,  129,    0,    0,  130,  131,  132,  133,  134, 
          135,  136,    0,    0,  137,  138,  139,  193,  194,  195, 
          196,  144,  145,  146,  147,  148,  149,  150,  151,  152, 
          153,  154,  155,  197,  198,  199,  159,    0,    0,  200, 
            0,    0,    0,    0,    0,    0,    0,  161,  162,    0, 
          163,  164,  165,  166,    0,  167,  168,    0,    0,  169, 
            0,    0,    0,    0,  170,  171,  172,  173,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          175,  176,    0,  177,  178,  179,  180,  181,  182,  183, 
          184,  185,    0,  186,  506,  507,  187,    0,  508,    0, 
            0,    0,    0,    0,    0,    0,  161,  162,    0,  163, 
          164,  165,  166,    0,  167,  168,    0,    0,  169,    0, 
            0,    0,    0,  170,  171,  172,  173,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  175, 
          176,    0,  177,  178,  179,  180,  181,  182,  183,  184, 
          185,    0,  186,  511,  512,  187,    0,  513,    0,    0, 
            0,    0,    0,    0,    0,  161,  162,    0,  163,  164, 
          165,  166,    0,  167,  168,    0,    0,  169,    0,    0, 
            0,    0,  170,  171,  172,  173,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  175,  176, 
            0,  177,  178,  179,  180,  181,  182,  183,  184,  185, 
            0,  186,  518,  507,  187,    0,  519,    0,    0,    0, 
            0,    0,    0,    0,  161,  162,    0,  163,  164,  165, 
          166,    0,  167,  168,    0,    0,  169,    0,    0,    0, 
            0,  170,  171,  172,  173,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  175,  176,    0, 
          177,  178,  179,  180,  181,  182,  183,  184,  185,    0, 
          186,  545,  512,  187,    0,  546,    0,    0,    0,    0, 
            0,    0,    0,  161,  162,    0,  163,  164,  165,  166, 
            0,  167,  168,    0,    0,  169,    0,    0,    0,    0, 
          170,  171,  172,  173,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  175,  176,    0,  177, 
          178,  179,  180,  181,  182,  183,  184,  185,    0,  186, 
          582,  507,  187,    0,  583,    0,    0,    0,    0,    0, 
            0,    0,  161,  162,    0,  163,  164,  165,  166,    0, 
          167,  168,    0,    0,  169,    0,    0,    0,    0,  170, 
          171,  172,  173,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  175,  176,    0,  177,  178, 
          179,  180,  181,  182,  183,  184,  185,    0,  186,  584, 
          512,  187,    0,  585,    0,    0,    0,    0,    0,    0, 
            0,  161,  162,    0,  163,  164,  165,  166,    0,  167, 
          168,    0,    0,  169,    0,    0,    0,    0,  170,  171, 
          172,  173,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  175,  176,    0,  177,  178,  179, 
          180,  181,  182,  183,  184,  185,    0,  186,  600,  507, 
          187,    0,  601,    0,    0,    0,    0,    0,    0,    0, 
          161,  162,    0,  163,  164,  165,  166,    0,  167,  168, 
            0,    0,  169,    0,    0,    0,    0,  170,  171,  172, 
          173,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  175,  176,    0,  177,  178,  179,  180, 
          181,  182,  183,  184,  185,    0,  186,  602,  512,  187, 
            0,  603,    0,    0,    0,    0,    0,    0,    0,  161, 
          162,    0,  163,  164,  165,  166,    0,  167,  168,    0, 
            0,  169,    0,    0,    0,    0,  170,  171,  172,  173, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  175,  176,    0,  177,  178,  179,  180,  181, 
          182,  183,  184,  185,    0,  186,  642,  507,  187,    0, 
          643,    0,    0,    0,    0,    0,    0,    0,  161,  162, 
            0,  163,  164,  165,  166,    0,  167,  168,    0,    0, 
          169,    0,    0,    0,    0,  170,  171,  172,  173,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  175,  176,    0,  177,  178,  179,  180,  181,  182, 
          183,  184,  185,    0,  186,  644,  512,  187,    0,  645, 
            0,    0,    0,    0,    0,    0,    0,  161,  162,    0, 
          163,  164,  165,  166,    0,  167,  168,    0,    0,  169, 
            0,    0,    0,    0,  170,  171,  172,  173,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          175,  176,    0,  177,  178,  179,  180,  181,  182,  183, 
          184,  185,    0,  186,  861,  507,  187,    0,  862,    0, 
            0,    0,    0,    0,    0,    0,  161,  162,    0,  163, 
          164,  165,  166,    0,  167,  168,    0,    0,  169,    0, 
            0,    0,    0,  170,  171,  172,  173,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  175, 
          176,    0,  177,  178,  179,  180,  181,  182,  183,  184, 
          185,    0,  186,  863,  512,  187,    0,  864,    0,    0, 
            0,    0,    0,    0,    0,  161,  162,    0,  163,  164, 
          165,  166,    0,  167,  168,    0,    0,  169,    0,    0, 
            0,    0,  170,  171,  172,  173,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  175,  176, 
            0,  177,  178,  179,  180,  181,  182,  183,  184,  185, 
            0,  186,    0,    0,  187, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

           15,   16,   14,  376,   19,    7,  216,    6,   21,   15, 
           16,   27,   21,   19,  379,  371,  393,   15,   16,   10, 
          248,   19,  411,   15,   16,   27,   10,   19,   43,   44, 
           10,   10,   15,   16,   49,   50,   19,   52,   53,  343, 
          102,  399,   61,   61,   50,  341,  342,   44,  344,  345, 
           91,   49,   10,   74,   32,   54,   10,  446,   50,  264, 
           44,   11,    6,    7,   10,  697,  370,    4,    5,   10, 
          107,   53,  470,  369,  280,   59,  312,   14,   10,   59, 
           59,   10,   95,   27,  388,  695,   95,  697,  101,    2, 
          386,  387,   10,   10,   10,   10,   10,  342,   44,  403, 
          280,  114,   10,   44,  312,   59,  402,  505,  312,  312, 
           54,  315,  327,   59,   51,   44,   51,   58,   59,   10, 
          312,  346,  290,  291,   74,   10,   10,   59,  312,   44, 
           10,  312,   10,   10,   47,    3,  432,    0,  374,  364, 
           58,   59,   58,   59,  349,  360,   44,   10,   10,   11, 
           47,  455,   89,   44,   10,   44,   10,  363,  454,  109, 
           44,  363,  342,   61,  372,  373,  374,  312,  372,  373, 
           10,  374,   61,   58,   59,  343,  342,   10,   58,   59, 
          372,  373,  374,  363,  557,   10,   10,  543,  372,  373, 
          374,  372,  373,  374,   61,  108,   59,  461,  219,  308, 
          832,  465,  201,   59,    0,   59,  562,  367,  270,  330, 
          312,   10,  352,  330,   10,  667,  337,  232,  233,  234, 
          337,  673,  832,  588,  282,   58,   59,  372,  373,  374, 
          245,   32,  247,  248,   59,   59,  339,   10,  378,  245, 
          255,  247,  248,  269,   32,  271,   10,  245,   10,  247, 
          248,  290,  291,  245,  269,  247,  248,  201,   91,   61, 
           59,  279,  245,   59,  247,  248,  313,  314,    0,  219, 
          372,  373,  374,  240,   44,   91,   91,  256,   10,  306, 
          307,    0,  309,  310,  311,  683,   59,   61,   16,  330, 
           61,   19,  268,  269,   58,   59,  337,   59,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,  343,  343,  267,   59,  343,  625, 
          626,  346,  369,  348,  312,  520,  521,  352,  353,   61, 
          729,    0,  360,  340,  257,  343,  735,   91,  269,  267, 
          271,  264,  343,   91,  339,  370,  348,  419,  420,  343, 
          352,  223,  224,  378,  346,  281,  348,  264,   44,  727, 
          352,  353,  370,  388,  389,  390,  391,  439,  440,  358, 
          395,  279,  267,  593,  364,  343,  378,  267,  403,  343, 
          388,  655,  407,  408,  372,  373,  411,  343,  342,  340, 
          415,  629,  408,  395,  262,  403,  290,  291,  781,  415, 
          426,  343,  279,  350,  364,  350,  330,  264,  433,  434, 
          435,  777,  340,  337,  426,  369,  343,  804,  443,  343, 
          339,  446,  415,  448,  267,  343,  349,  305,  405,  804, 
          455,   61,  310,  387,  306,  307,  308,  309,  398,  399, 
          290,  291,  349,  330,  343,  308,  340,  455,  402,  343, 
          337,  269,  360,  271,  853,  264,  262,  263,  264,  268, 
          269,  384,  268,  269,  830,  271,  343,  279,  339,  392, 
          304,  394,  426,  307,  308,  309,   59,  566,  432,  551, 
          569,  264,  881,  360,  308,  705,  269,  330,  271,   10, 
          509,  514,  264,  267,  337,  514,  330,  269,  340,  524, 
          454,  520,  521,  337,  330,  330,  429,  245,  342,  247, 
          248,  337,  337,  263,  264,  349,  350,  351,  352,  269, 
          262,  263,  264,   10,  547,  839,  268,  269,  269,  271, 
          271,  343,  838,  262,  263,  264,  279,  343,   59,  268, 
          269,   44,  271,  552,  739,  740,  572,  279,  360,   44, 
           91,  293,  294,  295,  296,  297,   10,  319,  364,   91, 
          572,    2,    3,    4,    5,  343,  591,    8,    9,   10, 
           11,  363,   59,   14,   15,   16,  330,  304,   19,  799, 
          540,  308,  330,  337,  609,   26,  306,  339,  613,  337, 
          310,  311,  617,  262,  263,  264,  319,  319,  552,  268, 
          269,  343,  271,  563,  629,   59,   47,   48,   49,  319, 
           51,  343,   53,  629,  343,  640,  304,  343,  572,  364, 
          692,  629,  364,  274,   44,  276,  277,  350,  360,  313, 
          314,  354,  355,  346,  611,  364,  658,  662,  304,  664, 
          665,  307,  308,  309,  621,  670,  671,  308,   89,  293, 
          294,  295,  296,  297,  577,  680,  681,  351,  352,  263, 
          264,  349,  350,  351,  352,  106,  691,  108,  294,  295, 
          542,  743,  664,  665,  343,  747,  342,  374,  670,  374, 
           10,  348,  342,  349,  350,  351,  352,  269,  267,  714, 
          715,  716,  264,  271,   44,  364,  785,  722,  343,  788, 
          343,   44,  791,  343,  729,  364,    9,   10,   11,  734, 
          735,  658,   32,    2,    3,  339,  339,  339,  734,    8, 
            9,   10,   11,   26,  647,  685,   15,   16,   58,   59, 
           19,  339,  734,  605,  346,   44,  659,   26,  661,  346, 
          663,  734,  263,  264,  343,   48,   44,  772,  264,  774, 
           61,  728,   44,   44,  731,  732,   44,  704,   47,   48, 
           49,   91,  304,   61,   53,  304,  340,  727,  339,  263, 
          339,  860,  339,   10,  264,  264,  801,  264,  803,   44, 
          772,  346,  223,  224,  809,  708,  346,  351,  813,  330, 
           44,   44,  817,   91,  343,  343,  337,  343,  330,  343, 
          723,  724,  725,  106,  245,  337,  247,  248,  262,  263, 
          264,   44,  364,  346,  839,  269,  257,  106,  264,  108, 
          339,   58,   59,  264,  264,  343,  851,  264,  853,  339, 
          264,  839,  343,  364,  360,  851,  264,  814,  815,  711, 
          364,  264,  343,   44,  308,  264,  871,  264,  873,   44, 
           44,   44,   10,  776,   91,  343,  881,  364,   91,  264, 
          885,  264,  346,  264,  305,  306,  307,  308,  309,  310, 
          311,  312,  849,  850,  797,   44,  346,  342,  855,    2, 
            3,    4,    5,  364,  838,    8,  271,    0,  343,  346, 
          346,   14,  364,  343,  343,  872,   91,   10,  346,  264, 
           58,   59,  343,  880,  364,  346,  883,  348,  349,  350, 
          887,  352,  353,  343,   62,    5,   10,  867,  841,    6, 
          223,  224,  781,  557,   47,  848,   89,  658,   51,  370, 
          371,  372,  695,   91,  223,  224,   66,  267,    2,    3, 
            4,    5,    6,  384,    8,   10,   59,  388,  840,  695, 
           14,  392,   74,  394,   -1,   -1,  245,   -1,  247,  248, 
           -1,   -1,  403,   -1,   58,   59,   89,   -1,  257,   -1, 
           -1,   -1,   -1,   -1,  415,  264,   -1,   -1,   -1,   -1, 
           -1,  279,   -1,   47,   -1,  108,  427,   51,  429,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   91,   -1,   -1, 
          330,   -1,   -1,  306,  307,  308,  309,  337,  311,  312, 
           -1,   -1,  342,   -1,  455,   -1,  305,  306,  307,  308, 
          309,  310,  311,  312,   -1,   89,   91,   -1,    0,   -1, 
          267,  304,  330,   -1,  307,  308,  309,  319,   10,  337, 
           -1,   -1,   -1,   -1,  108,  343,  279,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
          349,   -1,  360,  352,  353,   -1,   44,   -1,  350,  372, 
           -1,   -1,  354,  355,  356,  357,  349,  350,  351,  352, 
           -1,  370,  371,  372,  279,  280,   58,   59,   -1,   -1, 
           -1,   -1,   -1,  330,  319,  384,   -1,  330,    0,  388, 
          337,  542,  543,  392,  337,  394,   -1,   -1,   10,  267, 
          335,  336,  415,   91,  403,   -1,   -1,   -1,   -1,   -1, 
           -1,  562,    2,    3,  427,  350,  415,  360,    8,  354, 
          355,  356,  357,    0,  257,  330,  577,   -1,  427,   -1, 
          429,  264,  337,   10,   -1,   -1,   -1,  342,   -1,  262, 
          263,  264,   44,   -1,   -1,  268,  269,   59,  271,   -1, 
           -1,   -1,   -1,   -1,  605,  360,  455,   47,  363,   61, 
           -1,   -1,  330,  267,   44,   -1,   -1,   44,   -1,  337, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,  310,  629,   -1, 
           -1,   61,   59,  257,   -1,   -1,   -1,    2,    3,   91, 
          264,   -1,  267,    8,   -1,   -1,  647,   -1,   -1,   14, 
           -1,   -1,   -1,   -1,   -1,  280,   -1,  658,  659,   -1, 
          661,   91,  663,  664,  665,   -1,  349,  350,  108,  670, 
          343,   -1,   -1,   -1,   -1,   -1,  330,   -1,   -1,  542, 
           44,  305,   47,  337,   -1,   10,  310,   -1,  371,   -1, 
           -1,  364,   -1,  542,  543,   -1,   -1,   61,   -1,   -1, 
           -1,  384,   -1,  704,   -1,  330,   -1,  708,   44,  392, 
          711,  394,  337,  562,   -1,   49,   50,  342,   -1,   -1, 
           -1,   -1,  723,  724,  725,  349,  350,   91,  577,   -1, 
          262,  263,  264,   58,   59,  267,  268,  269,  363,  271, 
           -1,  279,  605,  108,   -1,   10,  429,  371,   -1,  281, 
           -1,   -1,   -1,   -1,   -1,   91,  605,   -1,  290,  291, 
          384,  293,  294,  295,  296,  297,   91,   -1,  392,   -1, 
          394,  772,   -1,   -1,   -1,  776,  777,   -1,   -1,   -1, 
          629,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  330,   58,   59,   -1,  797,   -1,  647,  337, 
          262,  263,  264,   -1,  342,  429,  268,  269,   -1,  271, 
          659,  343,  661,   -1,  663,  664,  665,  257,   -1,   -1, 
           -1,  670,  360,   -1,  264,   44,   91,  279,  280,  830, 
           -1,   -1,  364,   -1,   -1,  262,  263,  264,  839,   -1, 
          841,  268,  269,   -1,  271,   -1,   44,  848,  711,  279, 
          280,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,  708, 
          543,   -1,  711,  290,  291,  305,  293,  294,  295,  296, 
          310,   -1,   91,   61,  723,  724,  725,   44,  330,  562, 
           -1,  343,   -1,   -1,   -1,  337,   -1,   -1,   -1,   -1, 
          342,  343,  257,   91,  577,   -1,   -1,   -1,   -1,  264, 
          330,   -1,  364,   91,   -1,   -1,   -1,  337,  360,  349, 
           44,  363,  342,  343,  248,  279,  343,   -1,   -1,  543, 
           -1,   -1,   -1,  772,   91,   -1,   -1,  776,  777,   -1, 
          360,  371,   -1,  363,   -1,   -1,   -1,  364,  562,   44, 
          305,   44,  267,  279,  384,  310,   -1,   -1,  797,   -1, 
          232,  233,  392,  577,  394,  280,   61,   91,   61,   -1, 
           -1,   -1,   -1,   -1,  647,  648,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,  658,  659,   -1,  661,  343, 
          663,  830,   -1,   -1,  349,   -1,   91,   -1,   91,  429, 
          839,   -1,  841,   -1,  330,   -1,  360,   -1,   -1,  848, 
           -1,  337,  267,   -1,   -1,  330,  371,   -1,    0,  343, 
           -1,   -1,  337,   10,   -1,  280,   -1,  342,   10,  384, 
           -1,  704,   -1,  647,  360,  708,   -1,  392,   -1,  394, 
           -1,   -1,   -1,   -1,  658,  659,  370,  661,  363,  663, 
          723,  724,  725,   -1,  378,  379,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  388,   -1,   -1,   -1,   -1,   -1, 
          279,  280,   59,   -1,  429,  330,  348,   59,   -1,  403, 
          352,  319,  337,   -1,   -1,   -1,   -1,  342,   -1,   -1, 
          704,  279,   -1,   -1,  708,   -1,   -1,  335,  336,   -1, 
           -1,  279,   -1,  776,  777,   -1,  378,   -1,  363,  723, 
          724,  725,  350,  543,  352,   -1,  354,  355,  356,  357, 
           -1,  330,  279,  395,  797,   -1,   -1,   -1,  337,   -1, 
            0,  455,  562,  342,   -1,  407,  408,   -1,   -1,  411, 
           10,   -1,  330,  415,   44,  469,  470,  577,   -1,  337, 
           -1,  360,  330,   -1,  363,  279,  280,  830,   -1,  337, 
           -1,   61,  776,  777,  342,  343,   -1,   -1,  841,   -1, 
           -1,  443,  360,  330,  446,  848,  448,   -1,   -1,   -1, 
          337,  505,  360,  797,  279,  509,  279,  280,  543,   59, 
           -1,   91,   -1,   -1,   -1,   -1,  520,  521,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,  330,  562,   -1,   -1, 
           -1,   -1,   -1,  337,    0,   -1,  830,  647,  342,   -1, 
          544,   -1,  577,   -1,   10,   -1,   10,  841,   -1,  659, 
           -1,  661,   -1,  663,  848,  330,  360,  330,   -1,  363, 
           -1,   -1,  337,   -1,  337,   -1,   -1,   -1,  343,  342, 
          343,  575,  524,   -1,  578,   -1,  580,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,  588,  360,   -1,  360,   -1,   -1, 
          363,   -1,   58,   59,   -1,   59,   10,   63,  708,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,  647,  723,  724,  725,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  658,  659,   -1,  661,   -1,  663,   -1, 
           -1,  293,  294,  295,  296,  297,   -1,  304,   -1,  591, 
          307,  308,  309,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  609,   -1,   -1, 
           -1,  613,   -1,  330,   -1,  617,  776,  777,   -1,  704, 
          337,   -1,   -1,  708,   -1,  342,   -1,  629,   -1,  683, 
           -1,  343,  349,  350,  351,  352,   -1,  797,  723,  724, 
          725,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  279, 
           -1,   -1,  364,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
          830,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  681, 
           -1,  841,   -1,   -1,   -1,  739,  740,   44,  848,  691, 
           -1,  776,  777,  293,  294,  295,  296,  297,   -1,   -1, 
          330,   58,   59,   -1,   61,   -1,   63,  337,   -1,   -1, 
           -1,   -1,  797,  343,   -1,   -1,   -1,   -1,   -1,   -1, 
          722,   -1,   -1,   -1,   -1,   -1,   -1,  729,   -1,   -1, 
          360,   -1,   -1,  735,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  343,   -1,  830,  262,  263,  264,   -1, 
          804,  267,  268,  269,   -1,  271,  841,   -1,   -1,    0, 
           -1,   -1,   -1,  848,  364,  281,  282,   -1,   -1,   10, 
           -1,  319,  774,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,  839,   -1,  335,  336,   -1, 
          304,   -1,   -1,  307,  308,  309,   -1,   -1,   -1,   -1, 
           -1,  803,  350,   44,  352,   -1,  354,  355,  356,  357, 
           -1,  813,  360,  867,  362,  817,  330,   58,   59,   -1, 
           61,   -1,   63,  337,  340,   -1,   -1,  343,  342,   10, 
          346,   -1,  348,   -1,   -1,  349,  350,  351,  352,   -1, 
          304,   -1,   -1,  307,  308,  309,   -1,   -1,  364,  851, 
           91,  853,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  330,   -1,   -1,  871, 
           -1,  873,   -1,  337,   -1,   -1,   -1,   -1,  342,  881, 
           -1,   -1,   63,  885,   -1,  349,  350,  351,  352,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,  279,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,   -1,  293,  294,  295,  296, 
          297,   59,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
          337,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,  364,   -1,  366, 
          367,  368,  369,  370,  371,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   63,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,  364,    0,  366,  367,  368,  369,  370, 
          371,   -1,   -1,   -1,   10,   -1,   -1,   -1,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,   -1, 
          331,  332,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  350, 
           -1,  352,   -1,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,   58,   59,   -1,   61,  304,   63,   -1,  307, 
          308,  309,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  319,   -1,   -1,   -1,   -1, 
          324,  325,  330,   -1,   -1,   91,   -1,   -1,   -1,  337, 
           -1,  335,  336,   -1,  342,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,  350,  351,  352,   -1,  350,   -1,  352,    0, 
          354,  355,  356,  357,  358,  359,  360,   -1,  362,   10, 
           -1,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  350,   44,  352,  297,  354,  355,  356,  357, 
          358,  359,  360,   -1,  362,   -1,   -1,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,   10,  331, 
          332,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,   10, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,   -1, 
          352,   -1,  354,  355,  356,  357,  358,  359,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   63,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   -1,   -1,  335, 
          336,  337,  338,   -1,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,   -1,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,  364,    0,  366,  367,  368,  369,  370, 
          371,   -1,  304,   -1,   10,  307,  308,  309,   -1,   -1, 
           -1,   -1,   -1,  304,   -1,   -1,  307,  308,  309,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,   44,  330, 
          342,   -1,   -1,   -1,   -1,   -1,  337,  349,  350,  351, 
          352,  342,   58,   59,   -1,   61,   -1,   63,  349,  350, 
          351,  352,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,   -1,  331,  332,   -1,   -1,  335,  336, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  350,   -1,  352,   -1,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   44,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,  299,   63,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,   -1,   10,   -1, 
          318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347, 
           -1,  349,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,   59,  366,  367, 
          368,  369,  370,  371,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   -1,   -1,  335, 
          336,  337,  338,   -1,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,   -1,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,  364,    0,  366,  367,  368,  369,  370, 
          371,   -1,  304,   -1,   10,  307,  308,  309,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,   44,   -1, 
          342,   -1,   -1,   -1,   -1,   -1,   -1,  349,  350,  351, 
          352,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,    0, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   10, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   44,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           91,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
           -1,   44,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   -1,   -1,  335, 
          336,  337,  338,   -1,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,   -1,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,  364,    0,  366,  367,  368,  369,  370, 
          371,   -1,   -1,   -1,   10,   -1,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,   -1,  331,  332, 
           -1,   -1,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,   44,  352, 
           -1,  354,  355,  356,  357,  358,  359,  360,   -1,  362, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,    0, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   10, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   44,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           91,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   -1,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   -1,   -1,  335, 
          336,  337,  338,   -1,  340,  341,   -1,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,  368,  369,  370,  371,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,   -1,  340, 
          341,   -1,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,  364,    0,  366,  367,  368,  369,  370, 
          371,   -1,   -1,   -1,   10,   -1,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,   -1,  331,  332, 
           -1,   -1,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  350,   44,  352, 
           -1,  354,  355,  356,  357,  358,  359,  360,   -1,  362, 
           -1,   -1,   58,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,    0, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   10, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   44,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           91,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   59, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,   -1,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,   -1,  366,  367,  368,  369,  370, 
          371,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   -1,   -1,  335, 
          336,  337,  338,   -1,  340,  341,   -1,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,    0,  364,   -1, 
          366,  367,  368,  369,  370,  371,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   44,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   59,   -1,   61,  299, 
           63,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,   -1,  316,  317,  318,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1,   -1, 
           -1,   -1,    0,  353,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  361,   10,   -1,   -1,   -1,  366,  367,  368,  369, 
          370,  371,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   44,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   61,  299,   63,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
           -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,  343,  344, 
          345,   -1,  347,   -1,  349,   -1,  351,   -1,  353,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1, 
           -1,  366,  367,  368,  369,  370,  371,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,   -1,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
           -1,   -1,  335,  336,  337,  338,   -1,   -1,  341,  342, 
          343,  344,  345,   -1,  347,   -1,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,  364,   -1,  366,  367,  368,  369,  370,  371,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,   -1,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,   -1,   -1,  335,  336,  337, 
          338,   -1,   -1,  341,  342,  343,  344,  345,   -1,  347, 
           -1,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,  364,    0,  366,  367, 
          368,  369,  370,  371,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   44,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   59,   -1,   61,  299, 
           63,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,   -1,  316,  317,  318,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1,  349, 
           -1,  351,    0,  353,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  361,   10,   -1,   -1,   -1,  366,  367,  368,  369, 
          370,  371,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   44,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   61,  299,   63,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
           -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
          345,   -1,  347,   -1,  349,   -1,  351,   -1,  353,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,    0, 
           -1,  366,  367,  368,  369,  370,  371,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,  299,   58,   59,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,   -1,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
           -1,   -1,  335,  336,  337,  338,   -1,   -1,  341,  342, 
          343,  344,  345,   -1,  347,   -1,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,  364,   -1,  366,  367,  368,  369,  370,  371,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,   -1,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,   -1,   -1,  335,  336,  337, 
          338,   -1,   -1,  341,  342,  343,  344,  345,   -1,  347, 
           -1,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,   -1,  366,  367, 
          368,  369,  370,  371,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
          281,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   59, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330, 
           -1,   91,   -1,   -1,   -1,   -1,  337,  338,   -1,   -1, 
          341,   -1,  343,  344,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,  364,   -1,  366,  367,  368,  369,  370, 
          371,   10,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           59,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,   -1,   -1,  269, 
          270,   10,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
          300,  301,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,   -1,  316,  317,  318,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          330,   -1,   -1,   -1,   -1,   -1,   -1,  337,  338,   -1, 
           -1,  341,  342,   -1,  344,  345,   -1,  347,   -1,  349, 
           -1,   -1,   91,  353,   -1,   -1,   -1,   -1,  358,   -1, 
           -1,  361,   -1,  363,   -1,   -1,  366,  367,  368,  369, 
          370,  371,   -1,   -1,   -1,  375,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   -1, 
          269,  270,   10,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  330,   -1,   -1,   -1,   -1,   -1,   -1,  337,  338, 
           -1,   -1,  341,  342,   -1,  344,  345,   -1,  347,   -1, 
          349,   -1,   -1,   91,  353,   -1,   -1,   -1,   -1,  358, 
           -1,   -1,  361,   -1,  363,   -1,   -1,  366,  367,  368, 
          369,  370,  371,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   -1, 
          269,  270,   10,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  330,   -1,   -1,   -1,   -1,   -1,   -1,  337,  338, 
           -1,   -1,  341,  342,   -1,  344,  345,   -1,  347,   -1, 
          349,   -1,   -1,   91,  353,   -1,   -1,   -1,   -1,  358, 
           -1,   -1,  361,   -1,  363,   -1,   -1,  366,  367,  368, 
          369,  370,  371,   -1,   -1,   -1,  375,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           -1,  269,  270,   10,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,   -1,  316,  317, 
          318,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  330,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
          338,   -1,   -1,  341,  342,   -1,  344,  345,   -1,  347, 
           -1,  349,   -1,   -1,   -1,  353,   -1,   -1,   -1,   -1, 
          358,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367, 
          368,  369,  370,  371,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           -1,  269,  270,   10,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,   -1,  316,  317, 
          318,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  330,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
          338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347, 
           -1,  349,   -1,   -1,   -1,  353,   -1,   -1,   -1,   -1, 
          358,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367, 
          368,  369,  370,  371,   -1,   -1,   -1,  375,   -1,  256, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
           -1,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   10,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,  300,  301,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,  349,   -1,   -1,   -1,  353,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256, 
          257,  258,  259,  260,  261,   -1,   -1,  264,  265,  266, 
           -1,   -1,   -1,  270,    0,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   10,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,  300,  301,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   44,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,  349,   -1,   -1,   -1,  353,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  361,   91,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,    0,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   10,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,   44,  316,  317, 
          318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347, 
           -1,  349,   -1,   -1,   -1,  353,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  361,   91,   -1,  364,   -1,  366,  367, 
          368,  369,  370,  371,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  280,  281,  282,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   91,   -1,  335, 
          336,  337,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,   -1,  354,  355, 
          356,  357,  358,  359,  360,   -1,  362,  363,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   58,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   91,   -1,  335,  336, 
          337,   -1,  339,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,  354,  355,  356, 
          357,  358,  359,  360,    0,  362,   -1,  364,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  280,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   -1, 
           -1,  335,  336,  337,   -1,   91,  340,   -1,   -1,  343, 
           -1,   -1,  346,   -1,  348,   -1,  350,   -1,  352,   -1, 
          354,  355,  356,  357,  358,  359,  360,   -1,  362,  363, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   58,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,   91,   -1, 
          335,  336,  337,   -1,   -1,  340,   -1,   -1,  343,   -1, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,   -1,  354, 
          355,  356,  357,  358,  359,  360,    0,  362,   -1,  364, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   91,   -1,  335, 
          336,  337,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,   -1,  354,  355, 
          356,  357,  358,  359,  360,   -1,  362,   -1,  364,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
           91,   -1,  335,  336,  337,   -1,   -1,  340,   -1,   -1, 
          343,   -1,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
           -1,  354,  355,  356,  357,  358,  359,  360,    0,  362, 
           -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   91, 
           -1,  335,  336,  337,   -1,   -1,  340,   -1,   -1,  343, 
           -1,   -1,  346,   -1,  348,   -1,  350,   -1,  352,   -1, 
          354,  355,  356,  357,  358,  359,  360,   -1,  362,   -1, 
          364,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   44,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   91,   -1,  335,  336,  337,   -1,   -1,  340, 
           -1,   -1,  343,   -1,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,   -1,  354,  355,  356,  357,  358,  359,  360, 
            0,  362,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   44,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   91,   -1,  335,  336,  337,   -1,   -1,  340,   -1, 
           -1,  343,   -1,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,   -1,  354,  355,  356,  357,  358,  359,  360,   -1, 
          362,   -1,  364,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   91,   -1,  335,  336,  337,   -1, 
           -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,   -1,  354,  355,  356,  357,  358, 
          359,  360,    0,  362,   -1,  364,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  331,  332,   91,   -1,  335,  336,  337,   -1,   -1, 
          340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,   -1,  354,  355,  356,  357,  358,  359, 
          360,   -1,  362,   -1,  364,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   91,   -1,  335,  336, 
          337,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,   -1,  354,  355,  356, 
          357,  358,  359,  360,    0,  362,   -1,  364,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,   91,   -1,  335,  336,  337, 
           -1,   -1,  340,   -1,   -1,  343,   -1,   -1,   -1,   -1, 
           -1,   -1,  350,   -1,  352,   -1,  354,  355,  356,  357, 
          358,  359,  360,   -1,  362,    0,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,   -1,   -1, 
          335,  336,  337,   -1,   -1,  340,   -1,   -1,  343,   -1, 
           -1,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,  354, 
          355,  356,  357,  358,  359,  360,    0,  362,   -1,  364, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   -1,   -1,  335, 
          336,  337,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1, 
           -1,   -1,   -1,   -1,  350,   -1,  352,   -1,  354,  355, 
          356,  357,  358,  359,  360,    0,  362,   -1,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   -1,  331,  332,   -1,   -1, 
          335,  336,   -1,   -1,   -1,  340,   -1,   -1,  343,   -1, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,   -1,  354, 
          355,  356,  357,  358,  359,  360,    0,  362,   -1,  364, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,   -1,  331,  332,   -1, 
           -1,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,  343, 
           -1,   -1,  346,   -1,  348,   -1,  350,   -1,  352,   -1, 
          354,  355,  356,  357,  358,  359,  360,    0,  362,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
           -1,  331,  332,   -1,   -1,  335,  336,   -1,   -1,   -1, 
          340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,   -1,  354,  355,  356,  357,  358,  359, 
          360,    0,  362,   -1,  364,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,   -1,  331,  332,   -1,   -1,  335,  336,   -1,   -1, 
           -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,   -1,  354,  355,  356,  357,  358, 
          359,  360,    0,  362,   -1,  364,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,   -1,  331,  332,   -1,   -1,  335,  336,   -1, 
           -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,   -1,  354,  355,  356,  357, 
          358,  359,  360,    0,  362,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,   -1,  331,  332,   91,   -1,  335,  336,   -1,   -1, 
           -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,   -1,  354,  355,  356,  357,  358, 
          359,  360,   -1,  362,    0,  364,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,   -1,  331,  332,   91,   -1,  335,  336,   -1, 
           -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,   -1,  354,  355,  356,  357, 
          358,  359,  360,   -1,  362,    0,  364,  319,  320,  321, 
          322,  323,  324,  325,  326,   10,  328,  329,   -1,   -1, 
           -1,   -1,   -1,  335,  336,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,  350,   -1, 
          352,   -1,  354,  355,  356,  357,  358,  359,  360,   44, 
          362,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   91,   -1,  335,  336, 
          337,   -1,  339,   -1,   -1,   -1,  343,   -1,   -1,   -1, 
           -1,   -1,   -1,  350,   -1,  352,   -1,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,    0,  364,  319,  320, 
          321,  322,  323,  324,  325,   -1,   10,  328,  329,   -1, 
           -1,   -1,   -1,   -1,  335,  336,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,  350, 
           -1,  352,   -1,  354,  355,  356,  357,  358,  359,  360, 
           44,  362,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   91,   -1,  335, 
          336,  337,   -1,   -1,   -1,   -1,   -1,  343,   -1,   -1, 
           -1,   -1,   -1,   -1,  350,   -1,  352,   -1,  354,  355, 
          356,  357,  358,  359,  360,    0,  362,   -1,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,   -1,   -1, 
          335,  336,  337,   -1,   -1,   -1,   -1,   -1,  343,   -1, 
           -1,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,  354, 
          355,  356,  357,  358,  359,  360,    0,  362,   -1,  364, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   -1, 
           -1,  335,  336,  337,   -1,   -1,   -1,   -1,   -1,  343, 
           -1,   -1,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1, 
          354,  355,  356,  357,  358,  359,  360,    0,  362,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   -1,  331,  332,   -1,   -1, 
          335,  336,   -1,   -1,   -1,  340,   -1,   -1,  343,   -1, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,  356,  357,  358,  359,  360,    0,  362,   -1,  364, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,   -1,  331,  332,   -1, 
           -1,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,  343, 
           -1,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,  356,  357,  358,  359,  360,    0,  362,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,   -1,  331,  332, 
           -1,   -1,  335,  336,   -1,   -1,   -1,  340,   -1,   -1, 
          343,   -1,    0,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   10,   -1,   -1,  358,  359,  360,   -1,  362, 
           -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   44,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           58,   59,   -1,   -1,   -1,   63,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,   -1,  331,  332,   -1, 
           -1,  335,  336,    0,   -1,   -1,  340,   -1,   -1,  343, 
           -1,   -1,  346,   10,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,  358,  359,  360,   -1,  362,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,   -1,  331,  332, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
          343,   10,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,  358,  359,  360,   -1,  362, 
           -1,  364,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   58, 
           59,   -1,  290,  291,   63,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,   -1,  331,  332,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346,   10, 
          348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          358,  359,  360,   -1,  362,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   44,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   58,   59,   -1, 
           -1,   -1,   63,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,   -1,  331,  332,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,  343,   10,   -1,  346, 
           -1,  348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  358,  359,  360,   -1,  362,   -1,  364,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,   -1,  331,  332,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,  343,   10,   -1,  346,   -1,  348, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  358, 
          359,   -1,   -1,   -1,   -1,  364,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   44, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   58,   59,   -1,   -1,   -1,   63,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,   -1, 
          331,  332,   -1,    0,   -1,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,  343,   10,   -1,  346,   -1,  348,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  358,  359,   -1, 
           -1,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   44,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   58,   59,   -1,   -1,   -1,   63,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,   -1,  331,  332, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
          343,   10,   -1,  346,   -1,  348,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  358,  359,   -1,   -1,   -1, 
           -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   -1,  331,  332,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,  343,   -1, 
           -1,  346,   44,  348,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  358,  359,   -1,   58,   59,   -1,  364, 
           -1,   63,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   44,  343,   -1,   -1,  346, 
           -1,  348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,  364,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,   -1,   -1,   -1,   58,   59,   -1, 
           -1,  340,   63,   -1,  343,   -1,   -1,  346,   -1,  348, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,  364,    0,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   10,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,   -1,   -1,   -1,   58,   59,   -1,   -1,  340,   63, 
           -1,  343,   -1,   -1,  346,   -1,  348,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  364,  262,  263,  264,    0,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,  326,  327,   63, 
           -1,   -1,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
           -1,  262,  263,  264,    0,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   10,  364,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,  326,  327,   63,   -1,   -1, 
          331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,  343,   -1,   -1,  346,   -1,  348,  262,  263, 
          264,    0,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   10,   -1,  364,   58,   59,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,  326,  327,   63,   -1,   -1,  331,  332,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,  343, 
           -1,   -1,  346,   -1,  348,   -1,   -1,   44,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
          364,   58,   59,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,  343, 
           -1,   -1,  346,   -1,  348,   -1,  262,  263,  264,   44, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
          364,   -1,   -1,   58,   59,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,    0,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,  281,   -1,   -1, 
           -1,  327,   -1,   -1,   -1,  331,  332,   -1,   -1,  293, 
          294,  295,  296,  297,  340,   -1,   -1,  343,   -1,   -1, 
          346,   -1,  348,  262,  263,  264,   44,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  364,   -1, 
           58,   59,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,  343, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,    0, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   10, 
          364,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,  340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
            0,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,  364,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,   -1,   44,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,  364,   58,   59, 
           -1,   -1,   -1,    0,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,  340,   -1,   -1,  343,   -1, 
           -1,  346,   -1,  348,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  364, 
            0,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1, 
          348,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   44,   -1,   -1,   -1,   -1,  364,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   58,   59,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,  340, 
           -1,   -1,  343,   -1,   -1,  346,   -1,  348,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   44,   -1,  364,   -1,  262,  263,  264,   10,   -1, 
          267,  268,  269,   -1,  271,   58,   59,   -1,   -1,   -1, 
          340,   -1,   -1,  343,  281,  282,  346,   -1,  348,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   44,   -1,  364,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,  262,  263,  264,   -1,    0,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   10,  364,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,  262, 
          263,  264,   -1,    0,  267,  268,  269,   -1,  271,   -1, 
           44,   -1,   -1,   10,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   58,   59,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
          340,   -1,   -1,  343,   -1,   -1,  346,   44,  348,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,  364,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
          343,   -1,   -1,  346,   -1,  348,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,    0,  271,   -1, 
           -1,  364,   -1,   -1,   -1,   -1,   -1,   10,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,    0,  267,  268,  269,   -1,  271, 
           -1,   44,   -1,   -1,   10,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   58,   59,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,  340,   -1,   -1, 
          343,   -1,   -1,  346,   -1,  348,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  364,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,  343,   -1,   -1,  346,   -1,  348,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,  364,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   10, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,  340,   -1,   -1,  343, 
           -1,   -1,  346,   -1,  348,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  364,  271,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          343,   -1,   -1,  346,   -1,  348,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  364,   -1,    0,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   10,  340,   -1,   -1,  343,   -1,   -1, 
          346,   -1,  348,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,    0, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   10, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,    0,   -1,   -1,   -1,   58,   59,   -1, 
          281,  282,   -1,   10,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  343,   -1,   -1,  346, 
            0,  348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  364,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  343,   -1,   -1,  346,   -1,  348,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  364,  271,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  343,   -1,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,  364,   -1,   -1, 
           -1,   -1,   59,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,  343,  290,  291,  346,  293,  294,  295,  296, 
          297,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  343,   -1,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,  364,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  343,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  343,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          340,   -1,   -1,  343,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,  364, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,  375,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,  353,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,  353,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,  353,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,  353,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,  353,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,  353,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,  342,   -1,  344,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,  353,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,  349,   -1,   -1,   -1,  353,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,  349,   -1,   -1,   -1,  353,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,  349,   -1,   -1,   -1,  353,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
          342,   -1,  344,  345,   -1,  347,   -1,   -1,   -1,   -1, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,  353,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,   -1,   -1,   -1, 
           -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,   -1, 
           -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,   -1,   -1,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,   -1, 
           -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,  349,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,   -1,   -1,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,   -1, 
           -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,   -1,   -1,  318,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  345,   -1,  347,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,  260,  261,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  270,  271,   -1,   -1,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,  299,  300,  301,  302,  303,  304,  305,  306, 
           -1,  308,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316, 
          317,   -1,  319,  320,  321,  322,   -1,  324,  325,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   -1,   -1,  365,  366, 
          257,  258,  259,  260,  261,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  270,  271,   -1,   -1,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,  299,  300,  301,  302,  303,  304,  305,   -1, 
           -1,  308,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316, 
          317,   -1,  319,  320,  321,  322,   -1,  324,  325,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   -1,   -1,  365,  366, 
          257,  258,  259,  260,  261,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  270,  271,   -1,   -1,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,  299,  300,  301,  302,  303,  304,  305,  306, 
          307,  308,  309,   -1,   -1,   -1,   -1,   -1,   -1,  316, 
          317,   -1,  319,  320,  321,  322,   -1,  324,  325,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   -1,   -1,  365,  257, 
          258,  259,  260,  261,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  270,  271,   -1,   -1,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,  299,  300,  301,  302,  303,  304,  305,  306,  307, 
          308,  309,   -1,   -1,   -1,   -1,   -1,   -1,  316,  317, 
           -1,  319,  320,  321,  322,   -1,  324,  325,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,  362,   -1,   -1,  365,  257,  258, 
          259,  260,  261,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  270,  271,   -1,   -1,  274,  275,  276,  277,  278, 
          279,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,  298, 
          299,  300,  301,  302,  303,  304,  305,   -1,   -1,  308, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,  317,   -1, 
          319,  320,  321,  322,   -1,  324,  325,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          349,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,  362,  304,  305,  365,   -1,  308,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  316,  317,   -1,  319, 
          320,  321,  322,   -1,  324,  325,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,  333,  334,  335,  336,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,  362,  304,  305,  365,   -1,  308,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  316,  317,   -1,  319,  320, 
          321,  322,   -1,  324,  325,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,  304,  305,  365,   -1,  308,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  316,  317,   -1,  319,  320,  321, 
          322,   -1,  324,  325,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
          362,  304,  305,  365,   -1,  308,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  316,  317,   -1,  319,  320,  321,  322, 
           -1,  324,  325,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  349,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,  362, 
          304,  305,  365,   -1,  308,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  316,  317,   -1,  319,  320,  321,  322,   -1, 
          324,  325,   -1,   -1,  328,   -1,   -1,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,  362,  304, 
          305,  365,   -1,  308,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  316,  317,   -1,  319,  320,  321,  322,   -1,  324, 
          325,   -1,   -1,  328,   -1,   -1,   -1,   -1,  333,  334, 
          335,  336,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,  362,  304,  305, 
          365,   -1,  308,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          316,  317,   -1,  319,  320,  321,  322,   -1,  324,  325, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,  362,  304,  305,  365, 
           -1,  308,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316, 
          317,   -1,  319,  320,  321,  322,   -1,  324,  325,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,  304,  305,  365,   -1, 
          308,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,  317, 
           -1,  319,  320,  321,  322,   -1,  324,  325,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,  362,  304,  305,  365,   -1,  308, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,  317,   -1, 
          319,  320,  321,  322,   -1,  324,  325,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          349,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,  362,  304,  305,  365,   -1,  308,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  316,  317,   -1,  319, 
          320,  321,  322,   -1,  324,  325,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,  333,  334,  335,  336,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,  362,  304,  305,  365,   -1,  308,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  316,  317,   -1,  319,  320, 
          321,  322,   -1,  324,  325,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,   -1,   -1,  365, 
      };
   }

}
