/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.tests.templates;

import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.ui.templates.NopScriptTemplateIndenter;
import org.eclipse.dltk.ui.templates.TabExpandScriptTemplateIndenter;
import org.eclipse.dltk.ui.tests.templates.TestTemplateContext;

public class ScriptTemplateContextTest
extends SuiteOfTestCases {
    static /* synthetic */ Class class$0;

    public ScriptTemplateContextTest(String name) {
        super(name);
    }

    public static SuiteOfTestCases.Suite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.ui.tests.templates.ScriptTemplateContextTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public void testCalulateIndent() {
        ScriptTemplateContextTest.assertEquals((String)"", (String)TestTemplateContext.calculateIndent(""));
        ScriptTemplateContextTest.assertEquals((String)"", (String)TestTemplateContext.calculateIndent("if"));
        ScriptTemplateContextTest.assertEquals((String)"\t", (String)TestTemplateContext.calculateIndent("\tif"));
        ScriptTemplateContextTest.assertEquals((String)"\t\t", (String)TestTemplateContext.calculateIndent("\t\tif"));
        ScriptTemplateContextTest.assertEquals((String)"  ", (String)TestTemplateContext.calculateIndent("  if"));
        ScriptTemplateContextTest.assertEquals((String)"\t  ", (String)TestTemplateContext.calculateIndent("\t  if"));
    }

    private String tabExpandIndent(String line) {
        TabExpandScriptTemplateIndenter indenter = new TabExpandScriptTemplateIndenter(4);
        StringBuffer sb = new StringBuffer();
        indenter.indentLine(sb, "", line);
        return sb.toString();
    }

    public void testTabExpandIndenter() {
        ScriptTemplateContextTest.assertEquals((String)"if", (String)this.tabExpandIndent("if"));
        ScriptTemplateContextTest.assertEquals((String)"    if", (String)this.tabExpandIndent("\tif"));
        ScriptTemplateContextTest.assertEquals((String)"        if", (String)this.tabExpandIndent("\t\tif"));
    }

    private String nopIndent(String line) {
        NopScriptTemplateIndenter indenter = new NopScriptTemplateIndenter();
        StringBuffer sb = new StringBuffer();
        indenter.indentLine(sb, "", line);
        return sb.toString();
    }

    public void testNopIndenter() {
        ScriptTemplateContextTest.assertEquals((String)"if", (String)this.nopIndent("if"));
        ScriptTemplateContextTest.assertEquals((String)"\tif", (String)this.nopIndent("\tif"));
        ScriptTemplateContextTest.assertEquals((String)"\t\tif", (String)this.nopIndent("\t\tif"));
    }
}

