/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.tests.refactoring;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.tests.model.AbstractModelTests;
import org.eclipse.dltk.internal.corext.refactoring.util.ModelElementUtil;

public class ModelElementUtilTests
extends AbstractModelTests {
    public ModelElementUtilTests(String name) {
        super("org.eclipse.dltk.ui.tests", name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetPackageAndSubpackages() throws CoreException, IOException {
        this.setUpScriptProject("subpackages");
        try {
            ModelElementUtilTests.waitUntilIndexesReady();
            IScriptFolder folder0 = this.getScriptFolder("subpackages", "", (IPath)new Path("folder0"));
            IScriptFolder[] subfolders0 = ModelElementUtil.getPackageAndSubpackages((IScriptFolder)folder0);
            this.checkFolders(subfolders0, new String[]{folder0.getElementName()});
            IScriptFolder folder1 = this.getScriptFolder("subpackages", "", (IPath)new Path("folder1"));
            IScriptFolder[] subfolders1 = ModelElementUtil.getPackageAndSubpackages((IScriptFolder)folder1);
            this.checkFolders(subfolders1, new String[]{folder1.getElementName(), String.valueOf(folder1.getElementName()) + "/A"});
            IScriptFolder folder2 = this.getScriptFolder("subpackages", "", (IPath)new Path("folder2"));
            IScriptFolder[] subfolders2 = ModelElementUtil.getPackageAndSubpackages((IScriptFolder)folder2);
            this.checkFolders(subfolders2, new String[]{folder2.getElementName(), String.valueOf(folder2.getElementName()) + "/B", String.valueOf(folder2.getElementName()) + "/C"});
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.deleteProject("subpackages");
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.deleteProject("subpackages");
    }

    private void checkFolders(IScriptFolder[] folders, String[] names) {
        ModelElementUtilTests.assertEquals((int)names.length, (int)folders.length);
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < folders.length) {
            String relativePath = folders[i].getPath().removeFirstSegments(1).toString();
            ModelElementUtilTests.assertTrue((String)("duplicate entry " + relativePath), (boolean)set.add(relativePath));
            ++i;
        }
        i = 0;
        while (i < names.length) {
            ModelElementUtilTests.assertTrue((String)(String.valueOf(names[i]) + " is not found"), (boolean)set.contains(names[i]));
            ++i;
        }
    }
}

