/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ruby.ast.RubyASTUtil;

public class RubyModuleDeclaration
extends TypeDeclaration {
    private ASTNode name;

    public RubyModuleDeclaration(ASTNode name, Block body, int start, int end) {
        super(RubyASTUtil.resolveClassName(name), name.sourceStart(), name.sourceEnd(), start, end);
        ASTListNode el = new ASTListNode();
        this.setSuperClasses(el);
        this.name = name;
        this.fBody = body;
        this.setStart(start);
        this.setEnd(end);
    }

    public ASTNode getClassName() {
        return this.name;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((TypeDeclaration)this)) {
            if (this.getClassName() != null) {
                this.getClassName().traverse(visitor);
            }
            if (this.getBody() != null) {
                this.getBody().traverse(visitor);
            }
            visitor.endvisit((TypeDeclaration)this);
        }
    }

    public List getSuperClassNames() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator iter = this.getSuperClasses().getChilds().iterator();
        while (iter.hasNext()) {
            String name = RubyASTUtil.resolveClassName((ASTNode)iter.next());
            if (name == null || name.length() <= 0) continue;
            names.add(name);
        }
        return names;
    }
}

