/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.core.ModelElement;

class ModelElementInfo {
    protected IModelElement[] children = ModelElement.NO_ELEMENTS;
    static Object[] NO_NON_SCRIPT_RESOURCES = new Object[0];

    protected ModelElementInfo() {
    }

    public void addChild(IModelElement child) {
        if (this.children == ModelElement.NO_ELEMENTS) {
            this.setChildren(new IModelElement[]{child});
        } else if (!this.includesChild(child)) {
            this.setChildren(this.growAndAddToArray(this.children, child));
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    public IModelElement[] getChildren() {
        return this.children;
    }

    protected IModelElement[] growAndAddToArray(IModelElement[] array, IModelElement addition) {
        IModelElement[] old = array;
        array = new IModelElement[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected boolean includesChild(IModelElement child) {
        int i = 0;
        while (i < this.children.length) {
            if (child.equals(this.children[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IModelElement[] removeAndShrinkArray(IModelElement[] array, IModelElement deletion) {
        IModelElement[] old = array;
        array = new IModelElement[old.length - 1];
        int j = 0;
        int i = 0;
        while (i < old.length) {
            if (old[i].equals(deletion)) {
                System.arraycopy(old, i + 1, array, j, old.length - (i + 1));
                return array;
            }
            array[j] = old[i];
            ++j;
            ++i;
        }
        return array;
    }

    public void removeChild(IModelElement child) {
        if (this.includesChild(child)) {
            this.setChildren(this.removeAndShrinkArray(this.children, child));
        }
    }

    public void setChildren(IModelElement[] children) {
        this.children = children;
    }
}

