/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.typehierarchy;

import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.util.MethodOverrideTester;
import org.eclipse.dltk.internal.ui.typehierarchy.MethodsViewer;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class MethodsLabelProvider
extends AppearanceAwareLabelProvider {
    private Color fResolvedBackground;
    private boolean fShowDefiningType;
    private TypeHierarchyLifeCycle fHierarchy;
    private MethodsViewer fMethodsViewer;

    public MethodsLabelProvider(TypeHierarchyLifeCycle lifeCycle, MethodsViewer methodsViewer, IPreferenceStore store) {
        super(564049465049131L, 1, store);
        this.fHierarchy = lifeCycle;
        this.fShowDefiningType = false;
        this.fMethodsViewer = methodsViewer;
        this.fResolvedBackground = null;
    }

    public void setShowDefiningType(boolean showDefiningType) {
        this.fShowDefiningType = showDefiningType;
    }

    public boolean isShowDefiningType() {
        return this.fShowDefiningType;
    }

    private IType getDefiningType(Object element) throws ModelException {
        int kind = ((IModelElement)element).getElementType();
        if (kind != 9 && kind != 8) {
            return null;
        }
        IType declaringType = ((IMember)element).getDeclaringType();
        if (kind != 9) {
            return declaringType;
        }
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (hierarchy == null) {
            return declaringType;
        }
        MethodOverrideTester tester = new MethodOverrideTester(declaringType, hierarchy);
        IMethod method = (IMethod)element;
        IMethod res = tester.findDeclaringMethod(method, true);
        if (res == null || method.equals(res)) {
            return declaringType;
        }
        return res.getDeclaringType();
    }

    public String getText(Object element) {
        String text = super.getText(element);
        if (this.fShowDefiningType) {
            try {
                IType type = this.getDefiningType(element);
                if (type != null) {
                    StringBuffer buf = new StringBuffer(super.getText(type));
                    buf.append(" - ");
                    buf.append(text);
                    return buf.toString();
                }
            }
            catch (ModelException modelException) {}
        }
        return text;
    }

    public Color getForeground(Object element) {
        IMethod curr;
        IType declaringType;
        if (this.fMethodsViewer.isShowInheritedMethods() && element instanceof IMethod && (declaringType = (curr = (IMethod)element).getDeclaringType()).equals(this.fMethodsViewer.getInput())) {
            if (this.fResolvedBackground == null) {
                Display display = Display.getCurrent();
                this.fResolvedBackground = display.getSystemColor(10);
            }
            return this.fResolvedBackground;
        }
        return null;
    }
}

