/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.ui.externalchecker;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.dltk.validators.internal.core.externalchecker.Rule;
import org.eclipse.dltk.validators.internal.ui.externalchecker.IRulesListViewer;

public class RulesList {
    private Vector rules = new Vector();
    private Set changeListeners = new HashSet();
    private String[] types = new String[]{"Error", "Warning"};

    public void addRule() {
        Rule r = new Rule("%f:%n:%m", "Error");
        this.rules.add(r);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IRulesListViewer)iterator.next()).addRule(r);
        }
    }

    public void removeChangeListener(IRulesListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(IRulesListViewer viewer) {
        this.changeListeners.add(viewer);
    }

    public Vector getRules() {
        return this.rules;
    }

    public void ruleChanged(Rule r) {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IRulesListViewer)iterator.next()).updateRule(r);
        }
    }

    public void addRule(Rule r) {
        this.rules.add(r);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IRulesListViewer)iterator.next()).addRule(r);
        }
    }

    public void removeRule(Rule task) {
        this.rules.remove(task);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IRulesListViewer)iterator.next()).removeRule(task);
        }
    }

    public String[] getTypes() {
        return this.types;
    }
}

