/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.actions;

import java.text.MessageFormat;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationResult;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.actions.ScriptEvaluationAction;
import org.eclipse.swt.widgets.Display;

public abstract class ScriptDisplayAction
extends ScriptEvaluationAction {
    public static String trimDisplayResult(String result) {
        int max = DebugUITools.getPreferenceStore().getInt("org.eclipse.debug.ui.max_detail_length");
        if (max > 0 && result.length() > max) {
            result = String.valueOf(result.substring(0, max)) + "...";
        }
        return result;
    }

    protected void displayResult(final IScriptEvaluationResult result) {
        if (result.hasErrors()) {
            final Display display = DLTKDebugUIPlugin.getStandardDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (display.isDisposed()) {
                        return;
                    }
                    ScriptDisplayAction.this.reportErrors(result);
                    ScriptDisplayAction.this.evaluationCleanup();
                }
            });
            return;
        }
        final String snippet = result.getSnippet();
        IScriptValue resultValue = result.getValue();
        final String typeName = resultValue.getType().getName();
        IDebugModelPresentation presentation = ScriptDisplayAction.getDebugModelPresentation(result.getThread().getModelIdentifier());
        presentation.computeDetail((IValue)resultValue, new IValueDetailListener(){

            public void detailComputed(IValue value, String result) {
                ScriptDisplayAction.this.displayStringResult(snippet, MessageFormat.format("({0}) {1}", typeName, ScriptDisplayAction.trimDisplayResult(result)));
            }
        });
        presentation.dispose();
    }

    protected abstract void displayStringResult(String var1, String var2);
}

