/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.ISourceParser;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.Reference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.MatchLocatorParser;
import org.eclipse.dltk.core.search.matching.PatternLocator;
import org.eclipse.dltk.core.search.matching.PossibleMatch;
import org.eclipse.dltk.tcl.TclKeywordsManager;
import org.eclipse.dltk.tcl.ast.TclModuleDeclaration;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.internal.parser.TclParseUtils;

public class TclMatchLocatorParser
extends MatchLocatorParser {
    private ISourceParser parser;
    private static String[] kw = TclKeywordsManager.getKeywords();
    private static Map kwMap = new HashMap();

    static {
        int q = 0;
        while (q < kw.length) {
            kwMap.put(kw[q], Boolean.TRUE);
            ++q;
        }
    }

    public TclMatchLocatorParser(MatchLocator locator) {
        block2: {
            super(locator);
            try {
                this.parser = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.tcl.core.nature");
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public ModuleDeclaration parse(PossibleMatch possibleMatch) {
        TclModuleDeclaration module = (TclModuleDeclaration)this.parser.parse(possibleMatch.getFileName(), possibleMatch.getSourceContents().toCharArray(), null);
        module.rebuild();
        module.rebuildMethods();
        return module;
    }

    public void parseBodies(ModuleDeclaration unit) {
        MethodDeclaration[] methods;
        TypeDeclaration[] types = unit.getTypes();
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                TypeDeclaration type = types[i];
                this.getPatternLocator().match(this.processType(type), this.getNodeSet());
                this.parseBodies(type);
                ++i;
            }
        }
        if ((methods = unit.getFunctions()) != null) {
            PatternLocator locator = this.getPatternLocator();
            int i = 0;
            while (i < methods.length) {
                MethodDeclaration method = methods[i];
                if (method instanceof MethodDeclaration) {
                    MethodDeclaration methodDeclaration = method;
                    locator.match(this.processMethod(methodDeclaration), this.getNodeSet());
                    this.parseBodies(methodDeclaration);
                }
                ++i;
            }
        }
        ASTNode[] nodes = unit.getNonTypeOrMethodNode();
        int length = nodes.length;
        int i = 0;
        while (i < length) {
            this.processStatement(nodes[i]);
            ++i;
        }
    }

    private MethodDeclaration processMethod(MethodDeclaration m) {
        String name = m.getName();
        if (name.startsWith("::")) {
            name = name.substring(2);
        }
        if (name.indexOf("::") != -1) {
            int pos = name.lastIndexOf("::");
            String declTypeName = name.substring(0, pos);
            m.setDeclaringTypeName(declTypeName);
            name = name.substring(pos + 2);
        }
        m.setName(name);
        return m;
    }

    private TypeDeclaration processType(TypeDeclaration t) {
        String name = t.getName();
        if (name.startsWith("::")) {
            name = name.substring(2);
        }
        if (name.endsWith("::")) {
            name = name.substring(0, name.length() - 2);
        }
        t.setName(name);
        return t;
    }

    protected void parseBodies(TypeDeclaration type) {
        TypeDeclaration[] memberTypes;
        PatternLocator locator = this.getPatternLocator();
        MethodDeclaration[] methods = type.getMethods();
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                MethodDeclaration method = methods[i];
                if (method instanceof MethodDeclaration) {
                    MethodDeclaration methodDeclaration = method;
                    locator.match(this.processMethod(methodDeclaration), this.getNodeSet());
                    this.parseBodies(methodDeclaration);
                }
                ++i;
            }
        }
        if ((memberTypes = type.getTypes()) != null) {
            int i = 0;
            while (i < memberTypes.length) {
                TypeDeclaration memberType = memberTypes[i];
                locator.match(this.processType(memberType), this.getNodeSet());
                this.parseBodies(memberType);
                ++i;
            }
        }
        ASTNode[] nodes = type.getNonTypeOrMethodNode();
        int length = nodes.length;
        int i = 0;
        while (i < length) {
            this.processStatement(nodes[i]);
            ++i;
        }
    }

    protected void parseBodies(MethodDeclaration method) {
        List nodes = method.getStatements();
        int length = nodes.size();
        int i = 0;
        while (i < length) {
            ASTNode node = (ASTNode)nodes.get(i);
            this.processStatement(node);
            ++i;
        }
    }

    private void processStatement(ASTNode node) {
        if (node == null) {
            return;
        }
        if (node instanceof TclStatement) {
            PatternLocator locator = this.getPatternLocator();
            TclStatement statement = (TclStatement)node;
            FieldDeclaration[] fields = TclParseUtils.returnVariableDeclarations(statement);
            int k = 0;
            while (k < fields.length) {
                locator.match(fields[k], this.getNodeSet());
                ++k;
            }
            this.processReferences(statement);
        }
    }

    private void processReferences(TclStatement statement) {
        Expression commandId = statement.getAt(0);
        PatternLocator locator = this.getPatternLocator();
        if (commandId != null && commandId instanceof SimpleReference) {
            Expression e;
            String name = ((SimpleReference)commandId).getName();
            if (name.startsWith("::")) {
                name = name.substring(2);
            }
            if (!kwMap.containsKey(name) && !kwMap.containsKey(name)) {
                String[] ns = name.split("::");
                int i = 0;
                while (i < ns.length) {
                    if (ns[i].length() > 0) {
                        if (i == ns.length - 1) {
                            locator.match(new CallExpression(commandId.sourceStart(), commandId.sourceEnd(), null, ns[i], null), this.getNodeSet());
                        } else {
                            locator.match(new TypeReference(commandId.sourceStart(), commandId.sourceEnd(), ns[i]), this.getNodeSet());
                        }
                    }
                    ++i;
                }
            }
            if (name.equals("catch") && statement.getCount() >= 2 && (e = statement.getAt(1)) instanceof TclBlockExpression) {
                this.processBlock(e);
            }
            if (name.equals("if")) {
                this.processIf(statement);
            }
            if (name.equals("for")) {
                this.processFor(statement);
            }
            if (name.equals("while")) {
                this.processWhile(statement);
            }
        }
        int j = 1;
        while (j < statement.getCount()) {
            SimpleReference ref;
            String name;
            Expression st = statement.getAt(j);
            if (st instanceof TclExecuteExpression) {
                TclExecuteExpression expr = (TclExecuteExpression)st;
                List exprs = expr.parseExpression();
                int i = 0;
                while (i < exprs.size()) {
                    if (exprs.get(i) instanceof TclStatement) {
                        this.processReferences((TclStatement)((Object)exprs.get(i)));
                    }
                    ++i;
                }
            } else if (st instanceof StringLiteral) {
                int pos = 0;
                StringLiteral literal = (StringLiteral)st;
                String value = literal.getValue();
                pos = value.indexOf("$");
                while (pos != -1) {
                    SimpleReference ref2 = TclParseUtils.findVariableFromString(literal, pos);
                    if (ref2 != null) {
                        ref2.setName(ref2.getName().substring(1));
                        ref2.setEnd(ref2.sourceEnd() - 1);
                        locator.match((Reference)ref2, this.getNodeSet());
                        pos += ref2.getName().length();
                    }
                    pos = value.indexOf("$", pos + 1);
                }
            } else if (st instanceof SimpleReference && (name = (ref = (SimpleReference)st).getName()).startsWith("$")) {
                ref.setName(name.substring(1));
                ref.setEnd(ref.sourceEnd() - 1);
                locator.match((Reference)ref, this.getNodeSet());
            }
            ++j;
        }
    }

    private void processBlock(Expression e) {
        TclBlockExpression block = (TclBlockExpression)e;
        List code = block.parseBlock(block.sourceStart() + 1);
        int i = 0;
        while (i < code.size()) {
            if (code.get(i) instanceof TclStatement) {
                this.processReferences((TclStatement)((Object)code.get(i)));
            }
            ++i;
        }
    }

    private void processFor(TclStatement statement) {
        Expression bl;
        int bi;
        Expression bl2;
        List exprs = statement.getExpressions();
        int len = exprs.size();
        if (1 < len && (bl2 = (Expression)exprs.get(1)) instanceof TclBlockExpression) {
            this.processBlock(bl2);
        }
        if ((bi = 4) < len && (bl = (Expression)exprs.get(bi)) instanceof TclBlockExpression) {
            this.processBlock(bl);
        }
    }

    private void processWhile(TclStatement statement) {
        Expression bl;
        int bi = 2;
        List exprs = statement.getExpressions();
        int len = exprs.size();
        if (bi < len && (bl = (Expression)exprs.get(bi)) instanceof TclBlockExpression) {
            this.processBlock(bl);
        }
    }

    private void processIf(TclStatement statement) {
        List exprs = statement.getExpressions();
        int len = exprs.size();
        int i = 0;
        while (i < len) {
            Expression e = (Expression)exprs.get(i);
            if (e instanceof SimpleReference) {
                Expression bl;
                String value = ((SimpleReference)e).getName();
                if (value.equals("if") || value.equals("elseif")) {
                    int bi;
                    for (bi = i + 2; bi < len; ++bi) {
                        Expression bl2 = (Expression)exprs.get(bi);
                        if (bl2 instanceof SimpleReference) {
                            String thenSt = ((SimpleReference)bl2).getName();
                            if (thenSt == null || !thenSt.equals("then")) break;
                            continue;
                        }
                        if (!(bl2 instanceof TclBlockExpression)) break;
                        this.processBlock(bl2);
                        break;
                    }
                    i = bi - 1;
                } else if (value.equals("else") && i + 1 < len && (bl = (Expression)exprs.get(i + 1)) instanceof TclBlockExpression) {
                    this.processBlock(bl);
                }
            }
            ++i;
        }
    }
}

