/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.core.ElementCache;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.ModelInfo;

public class ModelCache {
    public static final int DEFAULT_PROJECT_SIZE = 5;
    public static final int DEFAULT_ROOT_SIZE = 50;
    public static final int DEFAULT_PKG_SIZE = 500;
    public static final int DEFAULT_OPENABLE_SIZE = 500;
    public static final int DEFAULT_CHILDREN_SIZE = 10000;
    protected ModelInfo modelInfo;
    protected HashMap projectCache;
    protected ElementCache rootCache;
    protected ElementCache pkgCache;
    protected ElementCache openableCache;
    protected Map childrenCache;

    public ModelCache() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        double ratio = maxMemory == Long.MAX_VALUE ? 4.0 : (double)(maxMemory / 64000000L);
        this.projectCache = new HashMap(5);
        this.rootCache = new ElementCache((int)(50.0 * ratio));
        this.pkgCache = new ElementCache((int)(500.0 * ratio));
        this.openableCache = new ElementCache((int)(500.0 * ratio));
        this.childrenCache = new HashMap((int)(10000.0 * ratio));
    }

    public Object getInfo(IModelElement element) {
        switch (element.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(element);
            }
            case 3: {
                return this.rootCache.get(element);
            }
            case 4: {
                return this.pkgCache.get(element);
            }
            case 5: 
            case 6: {
                return this.openableCache.get(element);
            }
        }
        return this.childrenCache.get(element);
    }

    protected Object peekAtInfo(IModelElement element) {
        switch (element.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(element);
            }
            case 3: {
                return this.rootCache.peek(element);
            }
            case 4: {
                return this.pkgCache.peek(element);
            }
            case 5: 
            case 6: {
                return this.openableCache.peek(element);
            }
        }
        return this.childrenCache.get(element);
    }

    protected void putInfo(IModelElement element, Object info) {
        switch (element.getElementType()) {
            case 1: {
                this.modelInfo = (ModelInfo)info;
                break;
            }
            case 2: {
                this.projectCache.put(element, info);
                this.rootCache.ensureSpaceLimit(((ModelElementInfo)info).children.length, element);
                break;
            }
            case 3: {
                this.rootCache.put(element, info);
                this.pkgCache.ensureSpaceLimit(((ModelElementInfo)info).children.length, element);
                break;
            }
            case 4: {
                this.pkgCache.put(element, info);
                this.openableCache.ensureSpaceLimit(((ModelElementInfo)info).children.length, element);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.put(element, info);
                break;
            }
            default: {
                this.childrenCache.put(element, info);
            }
        }
    }

    protected void removeInfo(IModelElement element) {
        switch (element.getElementType()) {
            case 1: {
                this.modelInfo = null;
                break;
            }
            case 2: {
                this.projectCache.remove(element);
                this.rootCache.resetSpaceLimit(50, element);
                break;
            }
            case 3: {
                this.rootCache.remove(element);
                this.pkgCache.resetSpaceLimit(500, element);
                break;
            }
            case 4: {
                this.pkgCache.remove(element);
                this.openableCache.resetSpaceLimit(500, element);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.remove(element);
                break;
            }
            default: {
                this.childrenCache.remove(element);
            }
        }
    }

    public String toStringFillingRation(String prefix) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(prefix);
        buffer.append("Project cache: ");
        buffer.append(this.projectCache.size());
        buffer.append(" projects\n");
        buffer.append(prefix);
        buffer.append("Root cache[");
        buffer.append(this.rootCache.getSpaceLimit());
        buffer.append("]: ");
        buffer.append(NumberFormat.getInstance().format(this.rootCache.fillingRatio()));
        buffer.append("%\n");
        buffer.append(prefix);
        buffer.append("Folder cache[");
        buffer.append(this.pkgCache.getSpaceLimit());
        buffer.append("]: ");
        buffer.append(NumberFormat.getInstance().format(this.pkgCache.fillingRatio()));
        buffer.append("%\n");
        buffer.append(prefix);
        buffer.append("Openable cache[");
        buffer.append(this.openableCache.getSpaceLimit());
        buffer.append("]: ");
        buffer.append(NumberFormat.getInstance().format(this.openableCache.fillingRatio()));
        buffer.append("%\n");
        return buffer.toString();
    }

    protected void resetZIPTypeCache() {
        if (DLTKCore.DEBUG) {
            System.err.println("Add reset ZIP Type cache...");
        }
    }
}

