/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.ui.breakpoints.BreakpointUtils;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ScriptToggleBreakpointAdapter
implements IToggleBreakpointsTarget {
    static /* synthetic */ Class class$0;

    protected ITextEditor getPartEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return null;
    }

    protected IResource getPartResource(IWorkbenchPart part) {
        ITextEditor textEditor = this.getPartEditor(part);
        if (textEditor != null) {
            IEditorInput iEditorInput = textEditor.getEditorInput();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IResource resource = (IResource)iEditorInput.getAdapter((Class)clazz);
            return resource;
        }
        return null;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            IResource resource = this.getPartResource(part);
            if (resource != null) {
                IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
                int i = 0;
                while (i < breakpoints.length) {
                    IBreakpoint breakpoint = breakpoints[i];
                    if (resource.equals((Object)breakpoint.getMarker().getResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber) {
                        breakpoint.delete();
                        return;
                    }
                    ++i;
                }
                ITextEditor partEditor = this.getPartEditor(part);
                if (partEditor instanceof ScriptEditor) {
                    ScriptEditor ed = (ScriptEditor)partEditor;
                    try {
                        IRegion lineInformation = ed.getScriptSourceViewer().getDocument().getLineInformation(lineNumber - 1);
                        String string = ed.getScriptSourceViewer().getDocument().get(lineInformation.getOffset(), lineInformation.getLength());
                        int contains = string.indexOf("function");
                        if (contains != -1) {
                            int apos = (string = string.substring(contains + "function".length()).trim()).indexOf(40);
                            if (apos >= 0) {
                                string = string.substring(0, apos).trim();
                            }
                            BreakpointUtils.addMethodEntryBreakpoint(partEditor, lineNumber, string);
                            return;
                        }
                        BreakpointUtils.addLineBreakpoint(partEditor, lineNumber);
                    }
                    catch (BadLocationException e) {
                        DLTKDebugPlugin.log((Throwable)e);
                        return;
                    }
                } else {
                    BreakpointUtils.addLineBreakpoint(partEditor, lineNumber);
                }
            }
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.getPartResource(part) != null;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            IResource resource = this.getPartResource(part);
            if (resource != null) {
                IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
                int i = 0;
                while (i < breakpoints.length) {
                    IBreakpoint breakpoint = breakpoints[i];
                    if (resource.equals((Object)breakpoint.getMarker().getResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber) {
                        breakpoint.delete();
                        return;
                    }
                    ++i;
                }
                ITextEditor partEditor = this.getPartEditor(part);
                if (partEditor instanceof ScriptEditor) {
                    ScriptEditor ed = (ScriptEditor)partEditor;
                    try {
                        IRegion lineInformation = ed.getScriptSourceViewer().getDocument().getLineInformation(lineNumber - 1);
                        String string = ed.getScriptSourceViewer().getDocument().get(lineInformation.getOffset(), lineInformation.getLength());
                        int indexOf = string.indexOf(61);
                        string = string.substring(0, indexOf);
                        indexOf = string.lastIndexOf(46) + 1;
                        if (indexOf != -1) {
                            string = string.substring(indexOf);
                        }
                        if ((indexOf = string.lastIndexOf(33)) != -1) {
                            string = string.substring(indexOf).trim();
                        }
                        BreakpointUtils.addWatchPoint(partEditor, lineNumber, string);
                    }
                    catch (BadLocationException e) {
                        DLTKDebugPlugin.log((Throwable)e);
                        return;
                    }
                } else {
                    BreakpointUtils.addWatchPoint(partEditor, lineNumber, "Hello");
                }
            }
        }
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection ts = (ITextSelection)selection;
            ts.getStartLine();
            String ta = ts.getText();
            if (part instanceof ScriptEditor) {
                ScriptEditor ed = (ScriptEditor)part;
                try {
                    IRegion lineInformation = ed.getScriptSourceViewer().getDocument().getLineInformation(ts.getStartLine());
                    String string = ed.getScriptSourceViewer().getDocument().get(lineInformation.getOffset(), lineInformation.getLength());
                    return string.indexOf(61) > -1;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            return ta.indexOf("=") != -1;
        }
        return true;
    }
}

