/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.html;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.DocumentTypeUtil;
import org.eclipse.actf.model.dom.html.HTMLParserFactory;
import org.eclipse.actf.model.dom.html.IErrorLogListener;
import org.eclipse.actf.model.dom.html.IHTMLParser;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.util.dom.DomPrintUtil;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.blind.BlindVisualizerBase;
import org.eclipse.actf.visualization.blind.IBlindVisualizer;
import org.eclipse.actf.visualization.blind.ui.internal.Messages;
import org.eclipse.actf.visualization.engines.blind.BlindVizResourceUtil;
import org.eclipse.actf.visualization.engines.blind.ParamBlind;
import org.eclipse.actf.visualization.engines.blind.eval.EvaluationResultBlind;
import org.eclipse.actf.visualization.engines.blind.html.IVisualizeMapData;
import org.eclipse.actf.visualization.engines.blind.html.VisualizeEngine;
import org.eclipse.actf.visualization.engines.blind.html.util.HtmlErrorLogListener;
import org.eclipse.actf.visualization.eval.CheckTargetFactory;
import org.eclipse.actf.visualization.eval.EvaluationUtil;
import org.eclipse.actf.visualization.eval.ICheckTarget;
import org.eclipse.actf.visualization.eval.IHtmlCheckTarget;
import org.eclipse.actf.visualization.eval.IHtmlChecker;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.html.HtmlEvalUtil;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemVisitor;
import org.eclipse.actf.visualization.util.html2view.Html2ViewMapMaker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BlindVisualizerHtml
extends BlindVisualizerBase
implements IBlindVisualizer {
    public static final int FRAME = 1;
    private static final String ORIG_HTML_FILE = "origSource.html";
    private static final String IE_HTML_FILE = "ieSource.html";
    private static final String MAPPED_HTML_FILE_PRE = "MappedHTML";
    private static final String HTML_SOURCE_FILE = "source.html";
    private IWebBrowserACTF webBrowser;
    private final boolean PERFORMANCE_DEBUG = false;

    public boolean setModelService(IModelService iModelService) {
        this.webBrowser = null;
        if (super.setModelService(iModelService)) {
            this.webBrowser = (IWebBrowserACTF)iModelService;
            return true;
        }
        return false;
    }

    public boolean isTarget(IModelService iModelService) {
        return iModelService != null && iModelService instanceof IWebBrowserACTF;
    }

    public int visualize() {
        block42: {
            boolean bl;
            File file;
            Document document;
            Document document2;
            Document document3;
            boolean bl2;
            HtmlErrorLogListener htmlErrorLogListener;
            Vector vector;
            File file2;
            File file3;
            boolean bl3;
            block40: {
                GuidelineHolder.getInstance().setTargetMimeType("text/html");
                int n = 0;
                this.checkResult = new EvaluationResultBlind();
                bl3 = false;
                file3 = this.webBrowser.saveOriginalDocument(String.valueOf(this.tmpDirS) + ORIG_HTML_FILE);
                file2 = this.webBrowser.saveDocumentAsHTMLFile(String.valueOf(this.tmpDirS) + IE_HTML_FILE);
                this.webBrowser.saveOriginalDocument(String.valueOf(this.tmpDirS) + HTML_SOURCE_FILE);
                vector = new Vector();
                IHTMLParser iHTMLParser = HTMLParserFactory.createHTMLParser();
                htmlErrorLogListener = new HtmlErrorLogListener();
                iHTMLParser.addErrorLogListener((IErrorLogListener)htmlErrorLogListener);
                String string = String.valueOf(this.tmpDirS) + MAPPED_HTML_FILE_PRE + n + ".html";
                bl2 = false;
                if (EvaluationUtil.isOriginalDOM()) {
                    vector = Html2ViewMapMaker.makeMap((String)ORIG_HTML_FILE, (String)(MAPPED_HTML_FILE_PRE + n + ".html"), (String)this.tmpDirS);
                    if (vector.size() == 0) {
                        bl2 = true;
                    }
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    document3 = this.webBrowser.getLiveDocument();
                    IHTMLParser iHTMLParser2 = HTMLParserFactory.createHTMLParser();
                    iHTMLParser2.parse((InputStream)new FileInputStream(String.valueOf(this.tmpDirS) + IE_HTML_FILE));
                    document2 = iHTMLParser2.getDocument();
                    iHTMLParser2.parse((InputStream)new FileInputStream(String.valueOf(this.tmpDirS) + ORIG_HTML_FILE));
                    document = iHTMLParser2.getDocument();
                    file = file2;
                } else {
                    iHTMLParser.parse((InputStream)new FileInputStream(string));
                    document = document2 = iHTMLParser.getDocument();
                    document3 = this.webBrowser.getLiveDocument();
                    file = file3;
                }
                bl3 = DocumentTypeUtil.isOriginalHTML5((DocumentType)document.getDoctype());
                bl = false;
                if (document2 != null) break block40;
                return -1;
            }
            try {
                block41: {
                    Object object;
                    Object object2;
                    int n;
                    int n2;
                    if (this.hasFrameset(document2, this.webBrowser)) {
                        bl = true;
                    }
                    this.setStatusMessage(Messages.BlindView_Now_processing);
                    this.pageData = new PageData();
                    VisualizeEngine visualizeEngine = new VisualizeEngine();
                    visualizeEngine.setBaseUrl("");
                    visualizeEngine.setTargetUrl(this.targetUrl);
                    visualizeEngine.setDocument(document2);
                    visualizeEngine.setHtml2viewMapV(vector);
                    visualizeEngine.setHTML5(bl3);
                    visualizeEngine.setInvisibleIdSet(new HashSet());
                    visualizeEngine.setPageData(this.pageData);
                    visualizeEngine.visualize();
                    this.maxReachingTime = visualizeEngine.getMaxTime();
                    this.setInfoMessage(this.getMaxReachingTime());
                    this.resultDocument = visualizeEngine.getResult();
                    this.checkResult.setProblemList(visualizeEngine.getProbelems());
                    this.checkResult.setTargetUrl(this.targetUrl);
                    if (this.variantFile != null) {
                        this.variantFile.delete();
                    }
                    this.variantFile = visualizeEngine.getVariantFile();
                    this.checkResult.addAssociateFile(this.variantFile);
                    IVisualizeMapData iVisualizeMapData = visualizeEngine.getVisualizeMapData();
                    this.checkResult.setSourceFile(new File(String.valueOf(this.tmpDirS) + HTML_SOURCE_FILE));
                    boolean bl4 = false;
                    if (ParamBlind.getInstance().iLanguage == 1) {
                        bl4 = true;
                    }
                    HtmlEvalUtil htmlEvalUtil = new HtmlEvalUtil(document2, this.resultDocument, this.targetUrl, iVisualizeMapData.getOrig2idMap(), document, document3, this.pageData, bl4, bl2);
                    htmlEvalUtil.setLiveFile(file2);
                    htmlEvalUtil.setSrcFile(file3);
                    htmlEvalUtil.setTargetFile(file);
                    ArrayList arrayList = new ArrayList(1024);
                    IHtmlCheckTarget iHtmlCheckTarget = CheckTargetFactory.createHtmlCheckTarget((Document)document2, (String)this.webBrowser.getURL(), null, (HtmlEvalUtil)htmlEvalUtil);
                    int n3 = 0;
                    while (n3 < this.checkers.length) {
                        if (this.checkers[n3] instanceof IHtmlChecker) {
                            arrayList.addAll(((IHtmlChecker)this.checkers[n3]).checkHtml(iHtmlCheckTarget));
                        } else if (this.checkers[n3].isTargetFormat(this.webBrowser.getCurrentMIMEType()) && this.checkers[n3].isEnabled()) {
                            arrayList.addAll(this.checkers[n3].check((ICheckTarget)iHtmlCheckTarget));
                        }
                        ++n3;
                    }
                    n3 = 0;
                    Vector vector2 = htmlErrorLogListener.getHtmlProblemVector();
                    if (bl3) {
                        n2 = -1;
                        n = 0;
                        while (n < vector2.size()) {
                            object2 = (IProblemItem)vector2.get(n);
                            if (object2.getId().equals("C_1000.8")) {
                                n2 = n;
                            }
                            ++n;
                        }
                        if (n2 > -1) {
                            vector2.remove(n2);
                            n3 = 1;
                        }
                    }
                    n2 = -1;
                    n = 0;
                    while (n < arrayList.size()) {
                        object2 = (IProblemItem)arrayList.get(n);
                        object = object2.getHighlightTargetNodeInfo();
                        if (object != null) {
                            if (object2.getHighlightTargetIds().length == 0) {
                                object2.setHighlightTargetIds(object.getHighlightTargetIds(iVisualizeMapData.getOrig2idMap()));
                            }
                            if (EvaluationUtil.isOriginalDOM()) {
                                object2.setHighlightTargetSourceInfo(object.getHighlightTargetSourceInfo(vector));
                            }
                        }
                        if (n3 != 0 && object2.getId().equals("C_88.1")) {
                            n3 = 0;
                            n2 = n;
                        }
                        ++n;
                    }
                    if (n2 > -1) {
                        arrayList.remove(n2);
                    }
                    this.checkResult.addProblemItems(arrayList);
                    this.checkResult.addProblemItems((Collection)vector2);
                    this.checkResult.accept((IProblemItemVisitor)this.pageData);
                    if (this.resultFile != null) {
                        this.resultFile.delete();
                    }
                    this.resultFile = BlindVizResourceUtil.createTempFile((String)"result", (String)".html");
                    try {
                        DomPrintUtil domPrintUtil = new DomPrintUtil(this.resultDocument);
                        domPrintUtil.setHTML5(bl3);
                        domPrintUtil.writeToFile(this.resultFile);
                    }
                    catch (Exception exception) {
                        DebugPrintUtil.devOrDebugPrintln((Object)"error: saveHtmlDocumentAsUTF8");
                    }
                    try {
                        Element[] elementArray = this.getElementsArray(document3, "iframe");
                        object2 = new HashSet();
                        if (elementArray.length <= 0) break block41;
                        Element[] elementArray2 = elementArray;
                        int n4 = elementArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            object = elementArray2[n5];
                            String string = object.getAttribute("src");
                            if (string != null && string.startsWith("http")) {
                                ((HashSet)object2).add(string);
                            } else {
                                NodeList nodeList = object.getChildNodes();
                                if (nodeList.getLength() > 0 && nodeList.item(0).getNodeName().equalsIgnoreCase("html")) {
                                    try {
                                        File file4 = BlindVizResourceUtil.createTempFile((String)"IFRAME", (String)".html");
                                        DomPrintUtil domPrintUtil = new DomPrintUtil(nodeList.item(0));
                                        domPrintUtil.setHTML5(true);
                                        domPrintUtil.writeToFile(file4);
                                        ((HashSet)object2).add(file4.toURI().toURL().toString());
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            ++n5;
                        }
                        if (!((HashSet)object2).isEmpty() && MessageDialog.openConfirm((Shell)PlatformUIUtil.getShell(), (String)Messages.BlindVisualizerHtml_15, (String)Messages.BlindVisualizerHtml_16)) {
                            object = PlatformUIUtil.getActiveEditor();
                            Iterator iterator = ((HashSet)object2).iterator();
                            while (iterator.hasNext()) {
                                String string = (String)iterator.next();
                                ModelServiceUtils.launchNew((String)string);
                            }
                            PlatformUIUtil.getActivePage().activate((IWorkbenchPart)object);
                        }
                    }
                    catch (Exception exception) {}
                }
                if (!bl) break block42;
                this.pageData.setHasFrame(true);
                return 1;
            }
            catch (Exception exception) {
                this.setStatusMessage(Messages.Visualization_Error);
                exception.printStackTrace();
                return -1;
            }
        }
        if (this.webBrowser != null && !this.webBrowser.isUrlExists()) {
            this.pageData.setError(true);
            return -1;
        }
        return 0;
    }

    private boolean hasFrameset(Document document, IWebBrowserACTF iWebBrowserACTF) {
        NodeList nodeList = document.getElementsByTagName("frameset");
        if (nodeList.getLength() > 0) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            NodeList nodeList2 = document.getElementsByTagName("frame");
            String string = BlindVizResourceUtil.getTempDirectory() + "frameList.html";
            String string2 = iWebBrowserACTF.getURL();
            try {
                String string3;
                object4 = new URL(string2);
                object3 = document.getElementsByTagName("base");
                if (object3.getLength() > 0 && (string3 = (object2 = (Element)object3.item(object3.getLength() - 1)).getAttribute("href")).length() > 0) {
                    object = new URL((URL)object4, string3);
                    string2 = ((URL)object).toString();
                }
            }
            catch (Exception exception) {}
            try {
                object4 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
            }
            catch (IOException iOException) {
                return true;
            }
            ((PrintWriter)object4).write("<html>");
            ((PrintWriter)object4).write("<head>" + FileUtils.LINE_SEP);
            ((PrintWriter)object4).write("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" >" + FileUtils.LINE_SEP);
            ((PrintWriter)object4).write("<base href=\"" + string2 + "\"></head>" + FileUtils.LINE_SEP + "<body><P>");
            ((PrintWriter)object4).write(Messages.BlindVisualizerHtml_1);
            ((PrintWriter)object4).write(String.valueOf(nodeList2.getLength()));
            ((PrintWriter)object4).write(Messages.BlindVisualizerHtml_2);
            ((PrintWriter)object4).write("<br>" + FileUtils.LINE_SEP);
            ((PrintWriter)object4).write(Messages.BlindVisualizerHtml_0);
            ((PrintWriter)object4).write("</P>" + FileUtils.LINE_SEP + "<ol>" + FileUtils.LINE_SEP);
            int n = 0;
            while (n < nodeList2.getLength()) {
                object = (Element)nodeList2.item(n);
                object3 = object.getAttribute("title");
                object2 = object.getAttribute("name");
                if (((String)object3).equals("")) {
                    ((String)object3).equals("none");
                }
                if (((String)object2).equals("")) {
                    ((String)object2).equals("none");
                }
                ((PrintWriter)object4).write("<li><a href=\"" + object.getAttribute("src") + "\">Title: \"" + (String)object3 + "\".<BR> Name: \"" + (String)object2 + "\".<BR> src: \"" + object.getAttribute("src") + "\".</a>" + FileUtils.LINE_SEP);
                ++n;
            }
            ((PrintWriter)object4).write("</ol></body></html>");
            ((PrintWriter)object4).flush();
            ((PrintWriter)object4).close();
            iWebBrowserACTF.navigate(string);
            return true;
        }
        return false;
    }

    private Element[] getElementsArray(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        int n = nodeList.getLength();
        Element[] elementArray = new Element[n];
        int n2 = 0;
        while (n2 < n) {
            elementArray[n2] = (Element)nodeList.item(n2);
            ++n2;
        }
        return elementArray;
    }
}

