/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.servlet.RequestDispatcherAdaptor;
import org.eclipse.equinox.http.servlet.internal.util.EventListeners;
import org.eclipse.equinox.http.servlet.internal.util.Params;

public class HttpServletRequestBuilderWrapperImpl
extends HttpServletRequestWrapper {
    private Stack<DispatchTargets> dispatchTargets = new Stack();
    private final HttpServletRequest request;
    private final DispatcherType dispatcherType;
    private Map<String, String[]> parameterMap;
    static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    static final String INCLUDE_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.include.context_path";
    static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";

    public static HttpServletRequestBuilderWrapperImpl findHttpRuntimeRequest(HttpServletRequest request) {
        while (request instanceof HttpServletRequestWrapper) {
            if (request instanceof HttpServletRequestBuilderWrapperImpl) {
                return (HttpServletRequestBuilderWrapperImpl)request;
            }
            request = (HttpServletRequest)((HttpServletRequestWrapper)request).getRequest();
        }
        return null;
    }

    public HttpServletRequestBuilderWrapperImpl(HttpServletRequest request, DispatchTargets dispatchTargets, DispatcherType dispatcherType) {
        super(request);
        this.request = request;
        this.dispatchTargets.push(dispatchTargets);
        this.dispatcherType = dispatcherType;
    }

    public String getAuthType() {
        String authType = (String)this.request.getAttribute("org.osgi.service.http.authentication.type");
        if (authType != null) {
            return authType;
        }
        return this.request.getAuthType();
    }

    public String getRemoteUser() {
        String remoteUser = (String)this.request.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (remoteUser != null) {
            return remoteUser;
        }
        return this.request.getRemoteUser();
    }

    public String getPathInfo() {
        if (this.dispatcherType == DispatcherType.INCLUDE) {
            return this.request.getPathInfo();
        }
        return this.dispatchTargets.peek().getPathInfo();
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap != null) {
            return this.parameterMap;
        }
        HashMap<String, String[]> copy = new HashMap<String, String[]>(this.dispatchTargets.peek().getParameterMap());
        for (Map.Entry entry : this.request.getParameterMap().entrySet()) {
            String[] values = (String[])copy.get(entry.getKey());
            values = Params.append(values, (String[])entry.getValue());
            copy.put((String)entry.getKey(), values);
        }
        this.parameterMap = Collections.unmodifiableMap(copy);
        return this.parameterMap;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public String getQueryString() {
        String queryStringA = this.dispatchTargets.peek().getQueryString();
        String queryStringB = this.request.getQueryString();
        if (queryStringA != null && queryStringA.length() > 0 && queryStringB != null && queryStringB.length() > 0) {
            return String.valueOf(queryStringA) + "&" + queryStringB;
        }
        return queryStringB;
    }

    public ServletContext getServletContext() {
        return this.dispatchTargets.peek().getServletRegistration().getServletContext();
    }

    public String getServletPath() {
        if (this.dispatcherType == DispatcherType.INCLUDE) {
            return this.request.getServletPath();
        }
        if (this.dispatchTargets.peek().getServletPath().equals("/")) {
            return "";
        }
        return this.dispatchTargets.peek().getServletPath();
    }

    public String getContextPath() {
        return this.dispatchTargets.peek().getContextController().getFullContextPath();
    }

    public Object getAttribute(String attributeName) {
        String servletPath = this.dispatchTargets.peek().getServletPath();
        if (this.dispatcherType == DispatcherType.INCLUDE) {
            if (attributeName.equals(INCLUDE_CONTEXT_PATH_ATTRIBUTE)) {
                String includeServletPath;
                String contextPath = (String)this.request.getAttribute(INCLUDE_CONTEXT_PATH_ATTRIBUTE);
                if (contextPath == null || contextPath.equals("/")) {
                    contextPath = "";
                }
                if ((includeServletPath = (String)this.request.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE)) == null || includeServletPath.equals("/")) {
                    includeServletPath = "";
                }
                return String.valueOf(contextPath) + includeServletPath;
            }
            if (attributeName.equals(INCLUDE_SERVLET_PATH_ATTRIBUTE)) {
                String attributeServletPath = (String)this.request.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE);
                if (attributeServletPath != null) {
                    return attributeServletPath;
                }
                if (servletPath.equals("/")) {
                    return "";
                }
                return servletPath;
            }
            if (attributeName.equals(INCLUDE_PATH_INFO_ATTRIBUTE)) {
                String pathInfoAttribute = (String)this.request.getAttribute(INCLUDE_PATH_INFO_ATTRIBUTE);
                if (servletPath.equals("/")) {
                    return pathInfoAttribute;
                }
                if (pathInfoAttribute == null || pathInfoAttribute.length() == 0) {
                    return null;
                }
                if (pathInfoAttribute.startsWith(servletPath)) {
                    pathInfoAttribute = pathInfoAttribute.substring(servletPath.length());
                }
                if (pathInfoAttribute.length() == 0) {
                    return null;
                }
                return pathInfoAttribute;
            }
        }
        return this.request.getAttribute(attributeName);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        ContextController contextController = this.dispatchTargets.peek().getContextController();
        if (!path.startsWith("/")) {
            path = String.valueOf(this.dispatchTargets.peek().getServletPath()) + "/" + path;
        } else if (path.startsWith(contextController.getFullContextPath())) {
            path = path.substring(contextController.getFullContextPath().length());
        }
        DispatchTargets requestedDispatchTargets = contextController.getDispatchTargets(path, null);
        if (requestedDispatchTargets == null) {
            return null;
        }
        return new RequestDispatcherAdaptor(requestedDispatchTargets, path);
    }

    public static String getDispatchPathInfo(HttpServletRequest req) {
        if (req.getDispatcherType() == DispatcherType.INCLUDE) {
            return (String)req.getAttribute(INCLUDE_PATH_INFO_ATTRIBUTE);
        }
        return req.getPathInfo();
    }

    public static String getDispatchServletPath(HttpServletRequest req) {
        if (req.getDispatcherType() == DispatcherType.INCLUDE) {
            String servletPath = (String)req.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE);
            return servletPath == null ? "" : servletPath;
        }
        return req.getServletPath();
    }

    public HttpSession getSession() {
        HttpSession session = this.request.getSession();
        if (session != null) {
            return this.dispatchTargets.peek().getContextController().getSessionAdaptor(session, ((Servlet)this.dispatchTargets.peek().getServletRegistration().getT()).getServletConfig().getServletContext());
        }
        return null;
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = this.request.getSession(create);
        if (session != null) {
            return this.dispatchTargets.peek().getContextController().getSessionAdaptor(session, ((Servlet)this.dispatchTargets.peek().getServletRegistration().getT()).getServletConfig().getServletContext());
        }
        return null;
    }

    public synchronized void pop() {
        this.dispatchTargets.pop();
        this.parameterMap = null;
        this.getParameterMap();
    }

    public synchronized void push(DispatchTargets toPush) {
        this.dispatchTargets.push(toPush);
        this.parameterMap = null;
        this.getParameterMap();
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
        EventListeners eventListeners = this.dispatchTargets.peek().getContextController().getEventListeners();
        List<ServletRequestAttributeListener> listeners = eventListeners.get(ServletRequestAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(this.dispatchTargets.peek().getServletRegistration().getServletContext(), (ServletRequest)this, name, null);
        for (ServletRequestAttributeListener servletRequestAttributeListener : listeners) {
            servletRequestAttributeListener.attributeRemoved(servletRequestAttributeEvent);
        }
    }

    public void setAttribute(String name, Object value) {
        boolean added = this.request.getAttribute(name) == null;
        this.request.setAttribute(name, value);
        EventListeners eventListeners = this.dispatchTargets.peek().getContextController().getEventListeners();
        List<ServletRequestAttributeListener> listeners = eventListeners.get(ServletRequestAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(this.dispatchTargets.peek().getServletRegistration().getServletContext(), (ServletRequest)this, name, value);
        for (ServletRequestAttributeListener servletRequestAttributeListener : listeners) {
            if (added) {
                servletRequestAttributeListener.attributeAdded(servletRequestAttributeEvent);
                continue;
            }
            servletRequestAttributeListener.attributeReplaced(servletRequestAttributeEvent);
        }
    }
}

