/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.examples.adesigner;

import java.net.URL;
import org.eclipse.actf.examples.adesigner.ADesignerPlugin;
import org.eclipse.actf.examples.adesigner.ApplicationActionBarAdvisor;
import org.eclipse.actf.examples.adesigner.ui.actions.SwitchModeAction;
import org.eclipse.actf.model.flash.proxy.FlashCacheUtil;
import org.eclipse.actf.model.ui.util.PerspectiveListenerForBrowserLaunch;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        PlatformUI.getPreferenceStore().setValue("SHOW_TRADITIONAL_STYLE_TABS", false);
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(true);
        configurer.setShowMenuBar(true);
        configurer.setShowStatusLine(true);
        configurer.setTitle(ADesignerPlugin.getResourceString("adesigner.window.title"));
        configurer.getWindow().addPerspectiveListener(new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                ApplicationWorkbenchWindowAdvisor.this.getWindowConfigurer().setTitle(String.valueOf(perspective.getLabel()) + " - " + ADesignerPlugin.getResourceString("adesigner.window.title"));
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }
        });
        FlashCacheUtil.clearCacheForStartup();
        PerspectiveListenerForBrowserLaunch.setTargetUrl((URL)PlatformUI.getWorkbench().getHelpSystem().resolve("/org.eclipse.actf.examples.adesigner.doc/docs/index.html", true));
    }

    private void checkChache(String id) {
        if ("org.eclipse.actf.visualization.ui.perspectives.FlashPerspective".equals(id)) {
            FlashCacheUtil.checkCache();
        }
    }

    public void postWindowOpen() {
        IMenuManager menuManager = this.getWindowConfigurer().getActionBarConfigurer().getMenuManager();
        IContributionItem[] items = menuManager.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getId() != null && (items[i].getId().equals("org.eclipse.search.menu") || items[i].getId().equals("org.eclipse.ui.run"))) {
                items[i].dispose();
            }
            ++i;
        }
        PreferenceManager prefManager = this.getWindowConfigurer().getWorkbenchConfigurer().getWorkbench().getPreferenceManager();
        IPreferenceNode[] iPreferenceNodeArray = prefManager.getRootSubNodes();
        int n = iPreferenceNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode node = iPreferenceNodeArray[n2];
            if ("org.eclipse.actf.ui.preferences.RootPreferencePage".equals(node.getId())) {
                node.remove("org.eclipse.actf.util.vocab.preferences.VocabPreferencePage");
            }
            ++n2;
        }
        IPreferenceStore prefStore = ADesignerPlugin.getDefault().getPreferenceStore();
        if (ADesignerPlugin.getPerspectiveID() == null && prefStore.getString("adesigner.preferences.startup.option").equals("adesigner.preferences.startup.choise.show.mode.dialog")) {
            SwitchModeAction.openModeSwitchDialog(this.getWindowConfigurer().getWindow());
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.checkChache(activePage.getPerspective().getId());
    }
}

