/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorXYZ;

public class ColorLAB {
    private static final double THIRD = 0.3333333333333333;
    private float L;
    private float a;
    private float b;

    public ColorLAB(ColorXYZ colorXYZ) {
        float f = colorXYZ.getX();
        float f2 = colorXYZ.getY();
        float f3 = colorXYZ.getZ();
        this.L = f2 > 0.008856f ? (float)(116.0 * Math.pow(f2, 0.3333333333333333) - 16.0) : 903.3f * f2;
        double d = Math.pow(f, 0.3333333333333333);
        double d2 = Math.pow(f2, 0.3333333333333333);
        double d3 = Math.pow(f3, 0.3333333333333333);
        this.a = (float)(500.0 * (d - d2));
        this.b = (float)(200.0 * (d2 - d3));
    }

    public ColorLAB(float f, float f2, float f3) throws ColorException {
        this.setL(f);
        this.setA(f2);
        this.setB(f3);
    }

    public float getL() {
        return this.L;
    }

    public void setL(float f) throws ColorException {
        if (f < 0.0f || 100.0f < f) {
            throw new ColorException("L is out of range: " + f);
        }
        this.L = f;
    }

    public float getA() {
        return this.a;
    }

    public void setA(float f) {
        this.a = f;
    }

    public float getB() {
        return this.b;
    }

    public void setB(float f) {
        this.b = f;
    }

    public ColorXYZ toXYZ() throws ColorException {
        float f = 0.0f;
        double d = 0.0;
        if (this.L > 8.0f) {
            d = (this.L + 16.0f) / 116.0f;
            f = (float)Math.pow(d, 3.0);
        } else {
            f = this.L / 903.3f;
            d = Math.pow(f, 0.3333333333333333);
        }
        float f2 = (float)Math.pow((double)this.a / 500.0 + d, 3.0);
        float f3 = (float)Math.pow(d - (double)this.b / 200.0, 3.0);
        return new ColorXYZ(f2, f, f3, false);
    }

    public float chroma() {
        return (float)Math.sqrt(this.a * this.a + this.b * this.b);
    }

    public double hueAngle() {
        return Math.atan2(this.b, this.a);
    }

    public static float deltaE(ColorLAB colorLAB, ColorLAB colorLAB2) {
        double d = colorLAB.L - colorLAB2.L;
        double d2 = colorLAB.a - colorLAB2.a;
        double d3 = colorLAB.b - colorLAB2.b;
        return (float)Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public static float deltaL(ColorLAB colorLAB, ColorLAB colorLAB2) {
        return Math.abs(colorLAB.L - colorLAB2.L);
    }

    public static float deltaH(ColorLAB colorLAB, ColorLAB colorLAB2) {
        float f = colorLAB.chroma() - colorLAB2.chroma();
        float f2 = colorLAB.a - colorLAB2.a;
        float f3 = colorLAB.b - colorLAB2.b;
        return (float)Math.sqrt(f2 * f2 + f3 * f3 - f * f);
    }

    public static double deltaHueAngle(ColorLAB colorLAB, ColorLAB colorLAB2) {
        double d = colorLAB.hueAngle();
        double d2 = colorLAB2.hueAngle();
        if (Double.isNaN(d)) {
            return 0.0;
        }
        if (Double.isNaN(d2)) {
            return 0.0;
        }
        double d3 = Math.abs(d - d2);
        if (d3 <= Math.PI) {
            return d3;
        }
        if (d3 <= Math.PI * 2) {
            return Math.PI * 2 - d3;
        }
        return d3 - Math.PI * 2;
    }

    public static double deltaHueAngleInDegree(ColorLAB colorLAB, ColorLAB colorLAB2) {
        return ColorLAB.deltaHueAngle(colorLAB, colorLAB2) * 180.0 / Math.PI;
    }
}

