/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.util;

import java.io.IOException;
import java.io.InputStream;

public class RereadableInputStream
extends InputStream {
    private InputStream in;
    private byte[] buf = new byte[10000];
    private int bufSiz = 0;
    private int index = 0;
    private boolean buffering = true;
    private boolean normal = false;

    public RereadableInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void close() throws IOException {
        if (this.normal) {
            this.in.close();
        }
    }

    public int read() throws IOException {
        if (this.buffering) {
            int n = this.in.read();
            if (this.bufSiz == this.buf.length) {
                this.buffering = false;
                this.normal = true;
            } else {
                this.buf[this.bufSiz++] = (byte)n;
            }
            return n;
        }
        if (this.normal) {
            return this.in.read();
        }
        byte by = this.buf[this.index++];
        if (this.index == this.bufSiz) {
            this.normal = true;
            this.buf = null;
        }
        return by;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffering) {
            int n3 = this.in.read(byArray, n, n2);
            if (this.bufSiz + n3 < this.buf.length) {
                int n4 = 0;
                while (n4 < n3) {
                    this.buf[this.bufSiz + n4] = byArray[n + n4];
                    ++n4;
                }
                this.bufSiz += n3;
            } else {
                this.buffering = false;
                this.normal = true;
            }
            return n3;
        }
        if (this.normal) {
            return this.in.read(byArray, n, n2);
        }
        int n5 = 0;
        while (n5 < byArray.length && this.index < this.bufSiz) {
            byArray[n5] = this.buf[this.index];
            ++n5;
            ++this.index;
        }
        if (this.index == this.bufSiz) {
            this.normal = true;
            this.buf = null;
        }
        return n5;
    }

    public void reset() throws IOException {
        if (!this.buffering) {
            throw new IOException("Cannot reset " + this);
        }
        this.buffering = false;
    }
}

