/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.actf.model.flash.bridge.IWaXcoding;
import org.eclipse.actf.model.flash.bridge.WaXcodingFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FlashModelPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.actf.model.flash";
    private static FlashModelPlugin plugin;
    private static final Path imposedSWFPath;
    private static final Path bootloaderSWFPath;
    private static final Path bridgeInitSWFPath;
    private static final Path bootloaderSWFV9Path;
    private static final Path bridgeInitSWFV9Path;

    static {
        imposedSWFPath = new Path("bridgeSWF/imposed.swf");
        bootloaderSWFPath = new Path("bridgeSWF/boot_loader.swf");
        bridgeInitSWFPath = new Path("bridgeSWF/boot_bridge.swf");
        bootloaderSWFV9Path = new Path("bridgeSWF/v9/bootloader_as3.swf");
        bridgeInitSWFV9Path = new Path("bridgeSWF/v9/bridge_as3.swf");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        InputStream is = this.tryOpenStream(imposedSWFPath);
        IWaXcoding wax = WaXcodingFactory.getWaXcoding();
        if (is != null) {
            wax.setSWFTranscodingImposedFile(is);
        }
        if ((is = this.tryOpenStream(bootloaderSWFPath)) != null) {
            wax.setSWFBootloader(is);
        }
        if ((is = this.tryOpenStream(bridgeInitSWFPath)) != null) {
            wax.setSWFBridgeInit(is);
        }
        if ((is = this.tryOpenStream(bootloaderSWFV9Path)) != null) {
            wax.setSWFBootloaderV9(is);
        }
        if ((is = this.tryOpenStream(bridgeInitSWFV9Path)) != null) {
            wax.setSWFBridgeInitV9(is);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static FlashModelPlugin getDefault() {
        return plugin;
    }

    private InputStream tryOpenStream(Path path) {
        try {
            return FileLocator.openStream((Bundle)this.getBundle(), (IPath)path, (boolean)false);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

