/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal.config;

public class PropertyConversionHelper {
    public static Object convertValue(String value, Class<?> targetType) {
        if (targetType == String.class) {
            return value;
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return Boolean.parseBoolean(value);
        }
        if (Enum.class.isAssignableFrom(targetType)) {
            try {
                Object valueOf = Enum.valueOf(targetType, value);
                return valueOf;
            }
            catch (Exception e) {
                throw new RuntimeException("Unsupported field type: " + targetType, e);
            }
        }
        throw new RuntimeException("Unsupported field type: " + targetType);
    }
}

