/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.validator;

import java.text.MessageFormat;
import org.eclipse.tcf.te.ui.controls.validator.RegexValidator;

public class NumberValidator
extends RegexValidator {
    public static final String ERROR_INVALID_RANGE = "NumberValidator_Error_InvalidRange";
    protected static final String NUMBER_REGEX = "([0-9]*)";
    private int min = 0;
    private int max = Integer.MAX_VALUE;

    public NumberValidator() {
        this(-1, -1);
    }

    public NumberValidator(int min, int max) {
        this(0, min, max);
    }

    public NumberValidator(int attributes, int min, int max) {
        this(attributes, NUMBER_REGEX, min, max);
    }

    public NumberValidator(int attributes, String regEx, int min, int max) {
        super(attributes, regEx);
        this.setBounds(min, max);
    }

    public void setBounds(int min, int max) {
        min = min >= 0 ? min : 0;
        max = max >= 0 ? max : Integer.MAX_VALUE;
        this.min = Math.min(min, max);
        this.max = Math.max(min, max);
    }

    @Override
    public boolean isValid(String newText) {
        boolean valid = super.isValid(newText);
        if (valid) {
            try {
                int value = Integer.decode(newText);
                if (value < this.min || value > this.max) {
                    this.setMessage(MessageFormat.format(this.getMessageText(ERROR_INVALID_RANGE), this.min, this.max), this.getMessageTextType(ERROR_INVALID_RANGE, 3));
                    valid = this.getMessageType() != 3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return valid;
    }
}

