/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.HashMap;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeModule;
import org.eclipse.tcf.util.TCFDataCache;

public class TCFChildrenModules
extends TCFChildren {
    public TCFChildrenModules(TCFNode node) {
        super(node, 128);
    }

    void onMemoryMapChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeModule)n).onMemoryMapChanged();
        }
        this.reset();
    }

    protected boolean startDataRetrieval() {
        TCFNodeExecContext exe = (TCFNodeExecContext)this.node;
        TCFDataCache<TCFNodeExecContext.MemoryRegion[]> map_cache = exe.getMemoryMap();
        if (!map_cache.validate((Runnable)((Object)this))) {
            return false;
        }
        TCFNodeExecContext.MemoryRegion[] map = (TCFNodeExecContext.MemoryRegion[])map_cache.getData();
        HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
        if (map != null) {
            int cnt = 0;
            int index = 0;
            while (index < map.length) {
                String id = String.valueOf(exe.id) + ".Module-" + index;
                TCFNodeModule module = (TCFNodeModule)this.node.model.getNode(id);
                if (module == null) {
                    module = new TCFNodeModule(exe, id, index);
                }
                if (module.getDefaultSortPositionFlag()) {
                    module.setSortPosition(cnt++);
                }
                data.put(id, module);
                ++index;
            }
        }
        this.set(null, map_cache.getError(), data);
        return true;
    }
}

