/*******************************************************************************
 * Copyright (c) 2008, 2014 Wind River Systems, Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *     Wind River Systems - initial API and implementation
 *******************************************************************************/
package org.eclipse.tcf.internal.cdt.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class ImageCache {

    public static final String
        IMG_TARGET_TAB = "icons/target_tab.gif";

    public static final String
        IMG_BREAKPOINT_SCOPE = "icons/obj16/bp_scope.gif";

    private static final Map<String,ImageDescriptor> desc_cache = new HashMap<String,ImageDescriptor>();
    private static final Map<ImageDescriptor,Image> image_cache = new HashMap<ImageDescriptor,Image>();

    public static synchronized ImageDescriptor getImageDescriptor(String name) {
        if (name == null) return null;
        ImageDescriptor descriptor = desc_cache.get(name);
        if (descriptor == null) {
            Bundle bundle = Activator.getDefault().getBundle();
            if (bundle != null) {
                URL url = FileLocator.find(bundle, new Path(name), null);
                if (url != null) descriptor = ImageDescriptor.createFromURL(url);
            }
            if (descriptor == null) {
                bundle = Platform.getBundle("org.eclipse.tcf.debug.ui");
                if (bundle != null) {
                    URL url = FileLocator.find(bundle, new Path(name), null);
                    if (url != null) descriptor = ImageDescriptor.createFromURL(url);
                }
                if (descriptor == null) {
                    bundle = Platform.getBundle("org.eclipse.debug.ui");
                    if (bundle != null) {
                        URL url = FileLocator.find(bundle, new Path(name), null);
                        if (url != null) descriptor = ImageDescriptor.createFromURL(url);
                    }
                }
            }
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            desc_cache.put(name, descriptor);
        }
        return descriptor;
    }

    public static synchronized Image getImage(ImageDescriptor desc) {
        Image image = image_cache.get(desc);
        if (image == null) {
            image = desc.createImage();
            image_cache.put(desc, image);
        }
        return image;
    }

    public static synchronized Image getImage(String name) {
        return getImage(getImageDescriptor(name));
    }
}
