/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.internal.debug.launch.TCFLaunchDelegate;
import org.eclipse.tcf.internal.debug.launch.TCFLocalAgent;
import org.eclipse.tcf.internal.debug.launch.TCFUserDefPeer;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.launch.PeerListControl;
import org.eclipse.tcf.internal.debug.ui.launch.PeerPropsDialog;
import org.eclipse.tcf.internal.debug.ui.launch.TCFPathMapTab;
import org.eclipse.tcf.internal.debug.ui.launch.TestErrorsDialog;
import org.eclipse.tcf.internal.debug.ui.launch.setup.SetupWizardDialog;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.util.TCFTask;

public class TCFTargetTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_ID = "org.eclipse.tcf.launch.targetTab";
    private Button run_local_server_button;
    private Button run_local_agent_button;
    private Button use_local_agent_button;
    private Text peer_id_text;
    private PeerListControl peer_list;
    private Tree peer_tree;
    private Runnable update_peer_buttons;
    private Display display;
    private Exception init_error;
    private String mem_map_cfg;

    public void createControl(Composite parent) {
        this.display = parent.getDisplay();
        assert (this.display != null);
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        this.createVerticalSpacer(comp, 1);
        this.createLocalAgentButtons(comp);
        this.createVerticalSpacer(comp, 1);
        this.createTargetGroup(comp);
    }

    private void createLocalAgentButtons(Composite parent) {
        Composite local_agent_comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        local_agent_comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        local_agent_comp.setLayoutData((Object)gd);
        this.run_local_server_button = this.createCheckButton(local_agent_comp, "Run TCF symbols server on the local host");
        this.run_local_server_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFTargetTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.run_local_server_button.setEnabled(true);
        this.run_local_agent_button = this.createCheckButton(local_agent_comp, "Run instance of TCF agent on the local host");
        this.run_local_agent_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFTargetTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.run_local_agent_button.setEnabled(true);
        this.use_local_agent_button = this.createCheckButton(local_agent_comp, "Use local host as the target");
        this.use_local_agent_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TCFTargetTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.use_local_agent_button.setEnabled(true);
    }

    private void createTargetGroup(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        group.setFont(font);
        group.setText("Target");
        this.createVerticalSpacer((Composite)group, layout.numColumns);
        Label host_label = new Label((Composite)group, 0);
        host_label.setText("Target ID:");
        host_label.setLayoutData((Object)new GridData(32));
        host_label.setFont(font);
        this.peer_id_text = new Text((Composite)group, 2052);
        this.peer_id_text.setLayoutData((Object)new GridData(768));
        this.peer_id_text.setFont(font);
        this.peer_id_text.setEditable(false);
        this.createVerticalSpacer((Composite)group, layout.numColumns);
        Label peer_label = new Label((Composite)group, 0);
        peer_label.setText("&Available targets:");
        peer_label.setLayoutData((Object)new GridData(32));
        peer_label.setFont(font);
        this.peer_list = new PeerListControl((Composite)group){

            @Override
            protected void onPeerListChanged() {
                TCFTargetTab.this.updateLaunchConfigurationDialog();
            }

            @Override
            protected void onPeerSelected(PeerListControl.PeerInfo info) {
                TCFTargetTab.this.peer_id_text.setText(TCFTargetTab.this.peer_list.getPath(info));
            }
        };
        this.peer_tree = this.peer_list.getTree();
        this.createPeerButtons(this.peer_tree.getParent());
    }

    private void createPeerButtons(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        Menu menu = new Menu((Control)this.peer_tree);
        SelectionAdapter sel_adapter = null;
        final Button button_new = new Button(composite, 8);
        button_new.setText("N&ew...");
        button_new.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("TransportName", "TCP");
                attrs.put("Host", "127.0.0.1");
                attrs.put("Port", "1534");
                SetupWizardDialog wizard = new SetupWizardDialog(attrs);
                WizardDialog dialog = new WizardDialog(TCFTargetTab.this.getShell(), (IWizard)wizard);
                dialog.create();
                if (dialog.open() != 0) {
                    return;
                }
                if (attrs.isEmpty()) {
                    return;
                }
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        new TCFUserDefPeer(attrs);
                        TCFUserDefPeer.savePeers();
                    }
                });
            }
        };
        button_new.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_new = new MenuItem(menu, 8);
        item_new.setText("N&ew...");
        item_new.addSelectionListener((SelectionListener)sel_adapter);
        final Button button_edit = new Button(composite, 8);
        button_edit.setText("E&dit...");
        button_edit.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final PeerListControl.PeerInfo info = TCFTargetTab.this.peer_list.findPeerInfo(TCFTargetTab.this.peer_id_text.getText());
                if (info == null) {
                    return;
                }
                if (new PeerPropsDialog(TCFTargetTab.this.getShell(), TCFTargetTab.this.getImage(), info.attrs, info.peer instanceof TCFUserDefPeer).open() != 0) {
                    return;
                }
                if (!(info.peer instanceof TCFUserDefPeer)) {
                    return;
                }
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((TCFUserDefPeer)info.peer).updateAttributes(info.attrs);
                        TCFUserDefPeer.savePeers();
                    }
                });
            }
        };
        button_edit.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_edit = new MenuItem(menu, 8);
        item_edit.setText("E&dit...");
        item_edit.addSelectionListener((SelectionListener)sel_adapter);
        final Button button_remove = new Button(composite, 8);
        button_remove.setText("&Remove");
        button_remove.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final PeerListControl.PeerInfo info = TCFTargetTab.this.peer_list.findPeerInfo(TCFTargetTab.this.peer_id_text.getText());
                if (info == null) {
                    return;
                }
                if (!(info.peer instanceof TCFUserDefPeer)) {
                    return;
                }
                TCFTargetTab.this.peer_id_text.setText("");
                TCFTargetTab.this.updateLaunchConfigurationDialog();
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((TCFUserDefPeer)info.peer).dispose();
                        TCFUserDefPeer.savePeers();
                    }
                });
            }
        };
        button_remove.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_remove = new MenuItem(menu, 8);
        item_remove.setText("&Remove");
        item_remove.addSelectionListener((SelectionListener)sel_adapter);
        this.createVerticalSpacer(composite, 20);
        new MenuItem(menu, 2);
        final Button button_test = new Button(composite, 8);
        button_test.setText("Run &Tests");
        button_test.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TCFTargetTab.this.runDiagnostics(false);
            }
        };
        button_test.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_test = new MenuItem(menu, 8);
        item_test.setText("Run &Tests");
        item_test.addSelectionListener((SelectionListener)sel_adapter);
        final Button button_loop = new Button(composite, 8);
        button_loop.setText("Tests &Loop");
        button_loop.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TCFTargetTab.this.runDiagnostics(true);
            }
        };
        button_loop.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_loop = new MenuItem(menu, 8);
        item_loop.setText("Tests &Loop");
        item_loop.addSelectionListener((SelectionListener)sel_adapter);
        this.peer_tree.setMenu(menu);
        this.update_peer_buttons = new Runnable(){

            @Override
            public void run() {
                boolean local = TCFTargetTab.this.use_local_agent_button.getSelection();
                PeerListControl.PeerInfo info = TCFTargetTab.this.peer_list.findPeerInfo(TCFTargetTab.this.peer_id_text.getText());
                button_new.setEnabled(!local);
                button_edit.setEnabled(info != null && !local);
                button_remove.setEnabled(info != null && info.peer instanceof TCFUserDefPeer && !local);
                button_test.setEnabled(local || info != null);
                button_loop.setEnabled(local || info != null);
                item_new.setEnabled(!local);
                item_edit.setEnabled(info != null && !local);
                item_remove.setEnabled(info != null && info.peer instanceof TCFUserDefPeer && !local);
                item_test.setEnabled(info != null);
                item_loop.setEnabled(info != null);
            }
        };
        this.update_peer_buttons.run();
    }

    protected void updateLaunchConfigurationDialog() {
        if (this.use_local_agent_button.getSelection()) {
            this.peer_tree.setEnabled(false);
            this.peer_tree.deselectAll();
            String id = TCFLocalAgent.getLocalAgentID((String)"agent");
            if (id == null) {
                id = "";
            }
            this.peer_id_text.setText(id);
            this.peer_id_text.setEnabled(false);
        } else {
            this.peer_tree.setEnabled(true);
            this.peer_id_text.setEnabled(true);
            String id = this.peer_id_text.getText();
            TreeItem item = this.peer_list.findItem(id);
            if (item != null) {
                this.peer_tree.setSelection(item);
            } else {
                this.peer_tree.deselectAll();
            }
        }
        this.update_peer_buttons.run();
        super.updateLaunchConfigurationDialog();
    }

    public String getName() {
        return "Target";
    }

    public Image getImage() {
        return ImageCache.getImage("icons/target_tab");
    }

    public String getId() {
        return TAB_ID;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        try {
            String id = configuration.getAttribute("org.eclipse.tcf.debug.PeerID", "");
            this.peer_id_text.setText(id);
            this.peer_list.setInitialSelection(id);
            this.run_local_server_button.setSelection(configuration.getAttribute("org.eclipse.tcf.debug.RunLocalServer", false));
            this.run_local_agent_button.setSelection(configuration.getAttribute("org.eclipse.tcf.debug.RunLocalAgent", false));
            this.use_local_agent_button.setSelection(configuration.getAttribute("org.eclipse.tcf.debug.UseLocalAgent", true));
            this.mem_map_cfg = configuration.getAttribute("org.eclipse.tcf.debug.MemoryMap", "null");
        }
        catch (CoreException e) {
            this.init_error = e;
            this.setErrorMessage("Cannot read launch configuration: " + (Object)((Object)e));
            Activator.log(e);
        }
        this.updateLaunchConfigurationDialog();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.use_local_agent_button.getSelection()) {
            configuration.removeAttribute("org.eclipse.tcf.debug.PeerID");
        } else {
            configuration.setAttribute("org.eclipse.tcf.debug.PeerID", this.peer_id_text.getText());
        }
        configuration.setAttribute("org.eclipse.tcf.debug.RunLocalServer", this.run_local_server_button.getSelection());
        configuration.setAttribute("org.eclipse.tcf.debug.RunLocalAgent", this.run_local_agent_button.getSelection());
        configuration.setAttribute("org.eclipse.tcf.debug.UseLocalAgent", this.use_local_agent_button.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.tcf.debug.RunLocalServer", false);
        configuration.setAttribute("org.eclipse.tcf.debug.RunLocalAgent", false);
        configuration.setAttribute("org.eclipse.tcf.debug.UseLocalAgent", true);
        configuration.removeAttribute("org.eclipse.tcf.debug.PeerID");
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.init_error != null) {
            this.setErrorMessage("Cannot read launch configuration: " + this.init_error);
            return false;
        }
        return true;
    }

    public String getPeerID() {
        return this.peer_id_text.getText();
    }

    private void runDiagnostics(boolean loop) {
        MessageBox mb;
        String msg;
        Object peer = null;
        if (this.use_local_agent_button.getSelection()) {
            try {
                if (this.run_local_agent_button.getSelection()) {
                    TCFLocalAgent.runLocalAgent((String)"agent");
                }
                final String id = TCFLocalAgent.getLocalAgentID((String)"agent");
                peer = (IPeer)new TCFTask<IPeer>(){

                    public void run() {
                        this.done((IPeer)Protocol.getLocator().getPeers().get(id));
                    }
                }.get();
            }
            catch (Throwable err) {
                msg = err.getLocalizedMessage();
                if (msg == null || msg.length() == 0) {
                    msg = err.getClass().getName();
                }
                mb = new MessageBox(this.getShell(), 33);
                mb.setText("Error");
                mb.setMessage("Cannot start agent:\n" + msg);
                mb.open();
            }
        } else {
            PeerListControl.PeerInfo info = this.peer_list.findPeerInfo(this.peer_id_text.getText());
            if (info == null) {
                return;
            }
            peer = info.peer;
        }
        if (peer == null) {
            return;
        }
        if (this.run_local_server_button.getSelection()) {
            try {
                final IPeer agent = peer;
                final String id = TCFLocalAgent.runLocalAgent((String)"server");
                IPeer server = (IPeer)new TCFTask<IPeer>(){

                    public void run() {
                        this.done((IPeer)Protocol.getLocator().getPeers().get(id));
                    }
                }.get();
                peer = new TransientPeer(server.getAttributes()){

                    public IChannel openChannel() {
                        if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                            throw new AssertionError();
                        }
                        IChannel c = super.openChannel();
                        c.redirect(agent.getAttributes());
                        return c;
                    }
                };
            }
            catch (Throwable err) {
                msg = err.getLocalizedMessage();
                if (msg == null || msg.length() == 0) {
                    msg = err.getClass().getName();
                }
                mb = new MessageBox(this.getShell(), 33);
                mb.setText("Error");
                mb.setMessage("Cannot start symbols server:\n" + msg);
                mb.open();
            }
        }
        Shell shell = new Shell(this.getShell(), 32800);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        shell.setLayout((Layout)layout);
        shell.setText("Running Diagnostics...");
        CLabel label = new CLabel((Composite)shell, 0);
        label.setLayoutData((Object)new GridData(4, 2, true, false));
        label.setText("Running Diagnostics...");
        final TCFTestSuite[] test = new TCFTestSuite[1];
        Button button_cancel = new Button((Composite)shell, 8);
        button_cancel.setText("&Cancel");
        button_cancel.setLayoutData((Object)new GridData(3, 2, false, false));
        button_cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (test[0] != null) {
                            test[0].cancel();
                        }
                    }
                });
            }
        });
        this.createVerticalSpacer((Composite)shell, 0);
        ProgressBar bar = new ProgressBar((Composite)shell, 256);
        bar.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        shell.setDefaultButton(button_cancel);
        shell.pack();
        shell.setSize(483, shell.getSize().y);
        Rectangle rc0 = this.getShell().getBounds();
        Rectangle rc1 = shell.getBounds();
        shell.setLocation(rc0.x + (rc0.width - rc1.width) / 2, rc0.y + (rc0.height - rc1.height) / 2);
        shell.setVisible(true);
        this.runDiagnostics((IPeer)peer, loop, test, shell, label, bar);
    }

    private void runDiagnostics(final IPeer peer, final boolean loop, final TCFTestSuite[] test, final Shell shell, final CLabel label, final ProgressBar bar) {
        final TCFTestSuite.TestListener done = new TCFTestSuite.TestListener(){
            private String last_text = "";
            private int last_count = 0;
            private int last_total = 0;

            public void progress(String label_text, int count_done, int count_total) {
                if (!$assertionsDisabled && test[0] == null) {
                    throw new AssertionError();
                }
                if ((label_text == null || this.last_text.equals(label_text)) && this.last_total == count_total && (float)(count_done - this.last_count) / (float)count_total < 0.02f) {
                    return;
                }
                if (label_text != null) {
                    this.last_text = label_text;
                }
                this.last_total = count_total;
                this.last_count = count_done;
                TCFTargetTab.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        label.setText(last_text);
                        bar.setMinimum(0);
                        bar.setMaximum(last_total);
                        bar.setSelection(last_count);
                    }
                });
            }

            public void done(final Collection<Throwable> errors) {
                if (!$assertionsDisabled && test[0] == null) {
                    throw new AssertionError();
                }
                final boolean b = test[0].isCanceled();
                test[0] = null;
                TCFTargetTab.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (errors.size() > 0) {
                            shell.dispose();
                            new TestErrorsDialog(TCFTargetTab.this.getControl().getShell(), ImageCache.getImage("icons/tcf"), errors).open();
                        } else if (loop && !b && TCFTargetTab.this.display != null) {
                            TCFTargetTab.this.runDiagnostics(peer, true, test, shell, label, bar);
                        } else {
                            shell.dispose();
                        }
                    }
                });
            }
        };
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    boolean enable_tracing;
                    List<IPathMap.PathMapRule> path_map = null;
                    ILaunchConfigurationTab[] iLaunchConfigurationTabArray = TCFTargetTab.this.getLaunchConfigurationDialog().getTabs();
                    int n = iLaunchConfigurationTabArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchConfigurationTab t = iLaunchConfigurationTabArray[n2];
                        if (t instanceof TCFPathMapTab) {
                            path_map = ((TCFPathMapTab)t).getPathMap();
                        }
                        ++n2;
                    }
                    HashMap mem_map = null;
                    if (TCFTargetTab.this.mem_map_cfg != null) {
                        mem_map = new HashMap();
                        TCFLaunchDelegate.parseMemMapsAttribute(mem_map, (String)TCFTargetTab.this.mem_map_cfg);
                    }
                    boolean bl = enable_tracing = "true".equals(Platform.getDebugOption((String)"org.eclipse.tcf.debug/debug")) && "true".equals(Platform.getDebugOption((String)"org.eclipse.tcf.debug/debug/tests/runcontrol"));
                    if (enable_tracing) {
                        System.setProperty("org.eclipse.tcf.debug.tracing.tests.runcontrol", "true");
                    }
                    test[0] = new TCFTestSuite(peer, done, path_map, mem_map);
                }
                catch (Throwable x) {
                    ArrayList<Throwable> errors = new ArrayList<Throwable>();
                    errors.add(x);
                    done.done(errors);
                }
            }
        });
    }
}

