/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.autosave;

import java.io.File;
import java.net.URI;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IResultOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;

public class SaveListener
implements IExecutionListener {
    IFSTreeNode dirtyNode;

    public void postExecuteSuccess(String commandId, Object returnValue) {
        if (this.dirtyNode != null) {
            if (UIPlugin.isAutoSaving()) {
                UiExecutor.execute(this.dirtyNode.operationUploadContent(this.dirtyNode.getCacheFile()));
            } else {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void handleException(Throwable e) {
                    }

                    public void run() throws Exception {
                        if (SaveListener.this.dirtyNode != null) {
                            SaveListener.this.dirtyNode.operationRefresh(false).runInJob(null);
                        }
                    }
                });
            }
        }
    }

    public void preExecute(String commandId, ExecutionEvent event) {
        this.dirtyNode = null;
        IEditorInput input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        if (input instanceof IURIEditorInput) {
            IURIEditorInput fileInput = (IURIEditorInput)input;
            URI uri = fileInput.getURI();
            try {
                IFileStore store = EFS.getStore((URI)uri);
                File localFile = store.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                if (localFile != null) {
                    IResultOperation parser = ModelManager.operationRestoreFromPath((String)localFile.getCanonicalPath());
                    parser.run(null);
                    this.dirtyNode = (IFSTreeNode)parser.getResult();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void notHandled(String commandId, NotHandledException exception) {
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
    }
}

