/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.stepper.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IPropertiesAccessService;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerManager;
import org.eclipse.tcf.te.runtime.statushandler.interfaces.IStatusHandler;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepperService;
import org.eclipse.tcf.te.runtime.stepper.job.AbstractStepperJobSchedulingRule;
import org.eclipse.tcf.te.runtime.stepper.stepper.Stepper;

public final class StepperJob
extends Job {
    private final IStepContext stepContext;
    private final IPropertiesContainer data;
    private final String stepGroupId;
    protected final String operation;
    private final boolean handleStatus;
    private final boolean isCancelable;
    private ICallback jobCallback = null;
    private boolean isFinished = false;
    private boolean isCanceled = false;
    private boolean statusHandled = false;

    public StepperJob(String name, IStepContext stepContext, IPropertiesContainer data, String stepGroupId, String operation, boolean isCancelable, boolean handleStatus) {
        super(name);
        this.setPriority(10);
        Assert.isNotNull((Object)stepContext);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)stepGroupId);
        Assert.isNotNull((Object)operation);
        this.stepContext = stepContext;
        this.data = data;
        this.stepGroupId = stepGroupId;
        this.operation = operation;
        this.isCancelable = isCancelable;
        this.handleStatus = handleStatus;
        AbstractStepperJobSchedulingRule rule = null;
        IStepperService service = (IStepperService)ServiceManager.getInstance().getService(stepContext.getContextObject(), IStepperService.class, true);
        if (service != null) {
            rule = service.getSchedulingRule(stepContext.getContextObject(), operation);
        } else if (stepContext.getContextObject() instanceof ISchedulingRule) {
            rule = (ISchedulingRule)stepContext.getContextObject();
        }
        this.setRule(rule);
        Map<String, List<Job>> jobs = StepperJob.getJobs(stepContext.getContextObject());
        StepperJob.addJob(jobs, this, operation);
        StepperJob.setJobs(jobs, stepContext.getContextObject());
    }

    public static Map<String, List<Job>> getJobs(Object context) {
        IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService(context, IPropertiesAccessService.class);
        HashMap jobs = null;
        if (service == null && context instanceof IPropertiesContainer) {
            jobs = (Map)((IPropertiesContainer)context).getProperty(StepperJob.class.getName());
        } else {
            HashMap hashMap = jobs = service != null ? (HashMap)service.getProperty(context, StepperJob.class.getName()) : null;
        }
        if (jobs == null) {
            jobs = new HashMap();
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Job> getJobsForOperation(Object context, String operation) {
        Map<String, List<Job>> jobs;
        Map<String, List<Job>> map = jobs = StepperJob.getJobs(context);
        synchronized (map) {
            List<Job> jobsForOperation = jobs.get(operation);
            if (jobsForOperation == null) {
                return Collections.emptyList();
            }
            return new ArrayList<Job>(jobsForOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addJob(Map<String, List<Job>> jobs, Job job, String operation) {
        Map<String, List<Job>> map = jobs;
        synchronized (map) {
            List<Job> jobsForOperation = jobs.get(operation);
            if (jobsForOperation == null) {
                jobsForOperation = new ArrayList<Job>();
                jobs.put(operation, jobsForOperation);
            }
            jobsForOperation.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJob(Map<String, List<Job>> jobs, Job job, String operation) {
        Map<String, List<Job>> map = jobs;
        synchronized (map) {
            List<Job> jobsForOperation = jobs.get(operation);
            if (jobsForOperation != null) {
                jobsForOperation.remove(job);
            }
        }
    }

    public static void setJobs(Map<String, List<Job>> jobs, Object context) {
        IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService(context, IPropertiesAccessService.class);
        if (service != null) {
            service.setProperty(context, StepperJob.class.getName(), jobs);
        } else if (context instanceof IPropertiesContainer) {
            ((IPropertiesContainer)context).setProperty(StepperJob.class.getName(), jobs);
        }
    }

    public final void setJobCallback(ICallback callback) {
        this.jobCallback = callback;
    }

    public final ICallback getJobCallback() {
        return this.jobCallback;
    }

    public boolean isCancelable() {
        return this.isCancelable;
    }

    public final IStatus run(IProgressMonitor monitor) {
        IStatus status;
        block7: {
            StepperProgressMonitor stepperMonitor = new StepperProgressMonitor((IProgressMonitor)monitor, this.isCancelable);
            monitor = stepperMonitor;
            JobChangeListener listener = new JobChangeListener(stepperMonitor);
            this.addJobChangeListener((IJobChangeListener)listener);
            Stepper stepper = new Stepper(this.getName()){

                @Override
                protected void onInitialize(IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) {
                    super.onInitialize(data, fullQualifiedId, monitor);
                    StepperAttributeUtil.setProperty("org.eclipse.tcf.te.runtime.stepper.stepper_job", fullQualifiedId, data, (Object)StepperJob.this);
                    StepperAttributeUtil.setProperty("org.eclipse.tcf.te.runtime.stepper.stepper_job_operation", fullQualifiedId, data, StepperJob.this.operation);
                }
            };
            status = Status.OK_STATUS;
            try {
                try {
                    stepper.initialize(this.stepContext, this.stepGroupId, this.data, (IProgressMonitor)monitor);
                    stepper.execute();
                }
                catch (CoreException e) {
                    status = e.getStatus();
                    stepper.cleanup();
                    Map<String, List<Job>> jobs = StepperJob.getJobs(this.stepContext.getContextObject());
                    StepperJob.removeJob(jobs, this, this.operation);
                    StepperJob.setJobs(jobs, this.stepContext.getContextObject());
                    break block7;
                }
            }
            catch (Throwable throwable) {
                stepper.cleanup();
                Map<String, List<Job>> jobs = StepperJob.getJobs(this.stepContext.getContextObject());
                StepperJob.removeJob(jobs, this, this.operation);
                StepperJob.setJobs(jobs, this.stepContext.getContextObject());
                throw throwable;
            }
            stepper.cleanup();
            Map<String, List<Job>> jobs = StepperJob.getJobs(this.stepContext.getContextObject());
            StepperJob.removeJob(jobs, this, this.operation);
            StepperJob.setJobs(jobs, this.stepContext.getContextObject());
        }
        if (this.jobCallback != null) {
            this.jobCallback.done((Object)this, status);
        }
        this.isFinished = true;
        if (this.handleStatus) {
            this.handleStatus(status);
        }
        return this.statusHandled ? Status.OK_STATUS : status;
    }

    protected void handleStatus(IStatus status) {
        IStatusHandler[] handler;
        if (!this.statusHandled && status != null && status.matches(7) && (handler = StatusHandlerManager.getInstance().getHandler((Object)this)) != null && handler.length > 0) {
            handler[0].handleStatus(status, null, null);
        }
        this.markStatusHandled();
    }

    public void markStatusHandled() {
        this.statusHandled = true;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean isCanceled() {
        return this.isCanceled && this.isCancelable;
    }

    protected void canceling() {
        if (this.isCancelable) {
            super.canceling();
            this.isCanceled = true;
        }
    }

    public boolean belongsTo(Object family) {
        return StepperJob.class.getName().equals(family);
    }

    private class JobChangeListener
    extends JobChangeAdapter {
        private final StepperProgressMonitor jobMonitor;

        public JobChangeListener(StepperProgressMonitor monitor) {
            this.jobMonitor = monitor;
        }

        public void done(IJobChangeEvent event) {
            this.jobMonitor.jobDone(StepperJob.this.isCanceled());
            StepperJob.this.handleStatus(event.getResult());
            StepperJob.this.removeJobChangeListener((IJobChangeListener)this);
        }
    }

    private static class StepperProgressMonitor
    extends ProgressMonitorWrapper {
        private final boolean cancelable;
        private volatile boolean jobDone;
        private volatile boolean canceled;

        public StepperProgressMonitor(IProgressMonitor monitor, boolean isCancelable) {
            super(monitor);
            this.cancelable = isCancelable;
        }

        void jobDone(boolean canceled) {
            this.jobDone = true;
            this.canceled = canceled;
        }

        public void beginTask(String name, int totalWork) {
            if (!this.jobDone) {
                super.beginTask(name, totalWork);
            }
        }

        public void done() {
            if (!this.jobDone) {
                super.done();
            }
        }

        public void internalWorked(double work) {
            if (!this.jobDone) {
                super.internalWorked(work);
            }
        }

        public boolean isCanceled() {
            if (this.cancelable && !this.jobDone) {
                return super.isCanceled();
            }
            return this.canceled;
        }

        public void setCanceled(boolean value) {
            boolean bl = this.canceled = this.cancelable && value;
            if (!this.jobDone) {
                super.setCanceled(this.canceled);
            }
        }

        public void setTaskName(String name) {
            if (!this.jobDone) {
                super.setTaskName(name);
            }
        }

        public void subTask(String name) {
            if (!this.jobDone) {
                super.subTask(name);
            }
        }

        public void worked(int work) {
            if (!this.jobDone) {
                super.worked(work);
            }
        }
    }
}

