/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.file;

import java.util.Arrays;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.controls.BaseDialogSelectionControl;
import org.eclipse.tcf.te.ui.controls.nls.Messages;
import org.eclipse.tcf.te.ui.controls.validator.FileNameValidator;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;

public class FileSelectionControl
extends BaseDialogSelectionControl
implements IDataExchangeNode {
    private String[] filterExtensions;
    private String[] filterNames;
    private String last_filter_path = null;

    public FileSelectionControl(IDialogPage parentPage) {
        super(parentPage);
        this.setDialogTitle(Messages.FileSelectionControl_title_open);
        this.setGroupLabel(Messages.FileSelectionControl_group_label);
        this.setEditFieldLabel(Messages.FileSelectionControl_editfield_label);
    }

    public void setFilterExtensions(String[] filterExtensions) {
        String[] stringArray = this.filterExtensions = filterExtensions != null ? Arrays.copyOf(filterExtensions, filterExtensions.length) : null;
        if (this.getEditFieldValidator() != null && filterExtensions != null) {
            ((FileNameValidator)this.getEditFieldValidator()).setFileExtensions(filterExtensions);
        }
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions != null ? Arrays.copyOf(this.filterExtensions, this.filterExtensions.length) : new String[]{};
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames != null ? Arrays.copyOf(filterNames, filterNames.length) : null;
    }

    public String[] getFilterNames() {
        return this.filterNames != null ? Arrays.copyOf(this.filterNames, this.filterNames.length) : new String[]{};
    }

    @Override
    protected Dialog doCreateDialogControl(Composite parent) {
        Assert.isNotNull((Object)parent);
        FileDialog dialog = new FileDialog(parent.getShell(), 4096);
        return dialog;
    }

    @Override
    protected void configureDialogControl(Dialog dialog) {
        super.configureDialogControl(dialog);
        if (dialog instanceof FileDialog) {
            String selectedFile;
            FileDialog fileDialog = (FileDialog)dialog;
            if (this.getFilterExtensions().length > 0) {
                fileDialog.setFilterExtensions(this.getFilterExtensions());
            }
            if (this.getFilterNames().length > 0) {
                fileDialog.setFilterNames(this.getFilterNames());
            }
            if ((selectedFile = this.doGetSelectedFile()) != null && selectedFile.trim().length() > 0) {
                String filterFileName;
                Path filePath = new Path(selectedFile);
                Path filterPath = filePath.toFile().isDirectory() ? filePath : filePath.removeLastSegments(1);
                while (filterPath != null && filterPath.segmentCount() > 1 && !filterPath.toFile().exists()) {
                    filterPath = filterPath.removeLastSegments(1);
                }
                String string = filterFileName = filePath.toFile().isDirectory() || !filePath.toFile().exists() ? null : filePath.lastSegment();
                if (filterPath != null && !filterPath.isEmpty()) {
                    fileDialog.setFilterPath(filterPath.toString());
                }
                if (filterFileName != null) {
                    fileDialog.setFileName(filterFileName);
                }
            } else {
                String filterPath = this.last_filter_path != null ? this.last_filter_path : this.doGetDefaultFilterPath();
                fileDialog.setFilterPath(filterPath);
            }
        }
    }

    @Override
    public void doApplyElementFromDialogControl(String selectedElement) {
        Path path = selectedElement != null ? new Path(selectedElement) : null;
        super.doApplyElementFromDialogControl(path != null ? path.toOSString() : "");
    }

    protected String doGetSelectedFile() {
        String file = this.getEditFieldControlText();
        return file.trim().length() > 0 ? file.trim() : null;
    }

    protected String doGetDefaultFilterPath() {
        if (Platform.getBundle((String)"org.eclipse.core.resources") != null && Platform.getBundle((String)"org.eclipse.core.resources").getState() == 32) {
            return ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        return null;
    }

    @Override
    protected Validator doCreateEditFieldValidator() {
        return new FileNameValidator(15);
    }

    @Override
    protected void configureEditFieldValidator(Validator validator) {
        if (validator instanceof FileNameValidator && this.getFilterExtensions() != null) {
            ((FileNameValidator)validator).setFileExtensions(this.getFilterExtensions());
        }
    }

    @Override
    protected String doOpenDialogControl(Dialog dialog) {
        Assert.isNotNull((Object)dialog);
        if (dialog instanceof FileDialog) {
            FileDialog fileDialog = (FileDialog)dialog;
            String selected = fileDialog.open();
            if (selected != null) {
                this.last_filter_path = fileDialog.getFilterPath();
            }
            return selected;
        }
        return null;
    }

    protected String getPropertiesKey() {
        return "File";
    }

    public void setupData(IPropertiesContainer data) {
        this.doApplyElementFromDialogControl(data.getStringProperty(this.getPropertiesKey()));
    }

    public void extractData(IPropertiesContainer data) {
        String file = this.doGetSelectedFile();
        if (file != null && file.trim().length() > 0) {
            data.setProperty(this.getPropertiesKey(), (Object)new Path(file.trim()).toPortableString());
        } else {
            data.setProperty(this.getPropertiesKey(), null);
        }
    }

    public boolean checkDataChanged(IPropertiesContainer data) {
        String file = this.doGetSelectedFile();
        Path path = new Path(file != null ? file : "");
        String newValue = path.toPortableString();
        if ("".equals(newValue)) {
            String oldValue = data.getStringProperty(this.getPropertiesKey());
            return oldValue != null && !"".equals(oldValue.trim());
        }
        return !data.isProperty(this.getPropertiesKey(), (Object)new Path(newValue).toPortableString());
    }
}

