/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.concurrent.factories;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;

public class SingleThreadThreadFactory
implements ThreadFactory {
    private final ThreadGroup threadGroup;
    private final String threadName;
    private Thread thread;
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    public SingleThreadThreadFactory(String namePrefix) {
        Assert.isNotNull((Object)namePrefix);
        this.threadGroup = System.getSecurityManager() != null ? System.getSecurityManager().getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.threadName = String.valueOf("".equals(namePrefix.trim()) ? "Executor" : namePrefix) + " - " + this.threadNumber.getAndIncrement();
    }

    @Override
    public Thread newThread(Runnable r) {
        if (this.thread != null) {
            return null;
        }
        this.thread = new Thread(this.threadGroup, r, this.threadName);
        this.thread.setDaemon(false);
        this.thread.setPriority(5);
        return this.thread;
    }

    public Thread getThread() {
        return this.thread;
    }
}

