/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import org.eclipse.statet.internal.jcommons.collections.AbstractImList;
import org.eclipse.statet.internal.jcommons.collections.ImEmptyIdentityList;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class ImEmptyList<E>
extends AbstractImList<E>
implements ImList<E>,
RandomAccess {
    public static final ImEmptyList INSTANCE = new ImEmptyList();
    private final Object[] array = new Object[0];
    private final ListIterator<E> iterator = new AbstractImList.AbstractImListIter<E>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public E previous() {
            throw new NoSuchElementException();
        }
    };

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.isEmpty();
    }

    @Override
    public E get(int index) {
        throw new IndexOutOfBoundsException("index= " + index);
    }

    @Override
    public int indexOf(@Nullable Object o) {
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return this.iterator;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.iterator;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.iterator;
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.emptySpliterator();
    }

    @Override
    public ImList<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > 0) {
            throw new IndexOutOfBoundsException("fromIndex= " + fromIndex + ", toIndex= " + toIndex + ", size= " + 1);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex > toIndex: fromIndex= " + fromIndex + ", toIndex= " + toIndex);
        }
        return this;
    }

    @Override
    public Object[] toArray() {
        return this.array;
    }

    @Override
    public <T> T[] toArray(T[] dest) {
        if (dest.length > 0) {
            dest[0] = null;
        }
        return dest;
    }

    @Override
    public void copyTo(Object[] dest, int destPos) {
    }

    @Override
    public void copyTo(int srcPos, Object[] dest, int destPos, int length) {
        assert (false);
    }

    @Override
    public ImList<E> toImList() {
        return this;
    }

    @Override
    public ImIdentityList<E> toImIdentityList() {
        return ImEmptyIdentityList.INSTANCE;
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof List) {
            List other = (List)obj;
            return other.isEmpty();
        }
        return false;
    }

    public String toString() {
        return "[]";
    }
}

