/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import org.eclipse.statet.internal.jcommons.collections.AbstractImList;
import org.eclipse.statet.internal.jcommons.collections.ImArrayIdentityList;
import org.eclipse.statet.internal.jcommons.collections.ImArraySub0List;
import org.eclipse.statet.internal.jcommons.collections.ImArraySubList;
import org.eclipse.statet.internal.jcommons.collections.ImEmptyList;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonList;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class ImArrayList<E>
extends AbstractImList<E>
implements ImList<E>,
RandomAccess {
    private final E[] array;

    public ImArrayList(E[] a) {
        this.array = a;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.indexOf(e.next()) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int index) {
        return this.array[index];
    }

    @Override
    public int indexOf(@Nullable Object o) {
        if (o == null) {
            int i = 0;
            while (i < this.array.length) {
                if (this.array[i] == null) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        int i = 0;
        while (i < this.array.length) {
            if (o.equals(this.array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        if (o == null) {
            int i = this.array.length - 1;
            while (i >= 0) {
                if (this.array[i] == null) {
                    return i;
                }
                --i;
            }
            return -1;
        }
        int i = this.array.length - 1;
        while (i >= 0) {
            if (o.equals(this.array[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter(0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new Iter(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.array.length) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return new Iter(index);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.array, 0, this.array.length, 1040);
    }

    @Override
    public ImList<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.array.length) {
            throw new IndexOutOfBoundsException("fromIndex= " + fromIndex + ", toIndex= " + toIndex + ", size= " + this.array.length);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex > toIndex: fromIndex= " + fromIndex + ", toIndex= " + toIndex);
        }
        int l = toIndex - fromIndex;
        if (l == this.array.length) {
            return this;
        }
        if (l == 0) {
            return ImEmptyList.INSTANCE;
        }
        if (l == 1) {
            return new ImSingletonList<E>(this.array[fromIndex]);
        }
        if (fromIndex == 0) {
            return new ImArraySub0List<E>(this.array, toIndex);
        }
        return new ImArraySubList<E>(this.array, fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        Object[] dest = new Object[this.array.length];
        System.arraycopy(this.array, 0, dest, 0, this.array.length);
        return dest;
    }

    @Override
    public <T> T[] toArray(T[] dest) {
        int n = this.array.length;
        if (dest.length < n) {
            return Arrays.copyOf(this.array, n, dest.getClass());
        }
        System.arraycopy(this.array, 0, dest, 0, n);
        if (dest.length > n) {
            dest[n] = null;
        }
        return dest;
    }

    @Override
    public void copyTo(Object[] dest, int destPos) {
        System.arraycopy(this.array, 0, dest, destPos, this.array.length);
    }

    @Override
    public void copyTo(int srcPos, Object[] dest, int destPos, int length) {
        System.arraycopy(this.array, srcPos, dest, destPos, length);
    }

    @Override
    public ImList<E> toImList() {
        return this;
    }

    @Override
    public ImIdentityList<E> toImIdentityList() {
        return new ImArrayIdentityList<E>(this.array);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int i = 0;
        while (i < this.array.length) {
            hashCode = 31 * hashCode + (this.array[i] != null ? this.array[i].hashCode() : 0);
            ++i;
        }
        return hashCode;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof List) {
            List other = (List)obj;
            if (this.array.length != other.size()) {
                return false;
            }
            Iterator otherIter = other.iterator();
            int i = 0;
            while (i < this.array.length) {
                if (!Objects.equals(this.array[i], otherIter.next())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    private class Iter
    extends AbstractImList.AbstractImListIter<E> {
        private int cursor;

        Iter(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ImArrayList.this.array.length;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public E next() {
            if (this.cursor >= ImArrayList.this.array.length) {
                throw new NoSuchElementException();
            }
            return ImArrayList.this.array[this.cursor++];
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            if (this.cursor <= 0 || ImArrayList.this.array.length <= 0) {
                throw new NoSuchElementException();
            }
            return ImArrayList.this.array[--this.cursor];
        }
    }
}

