/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.text.core.input;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;

@NonNullByDefault
public abstract class FilterParserInput
extends TextParserInput {
    private final TextParserInput source;
    private int[] bufferBeginIndexes;
    private int[] bufferEndIndexes;

    protected FilterParserInput(TextParserInput source, int defaultBufferSize) {
        super(defaultBufferSize);
        if (source == null) {
            throw new NullPointerException("source");
        }
        this.source = source;
        this.bufferBeginIndexes = new int[1];
        this.bufferEndIndexes = new int[0];
    }

    @Override
    protected void reset() {
        super.reset();
        this.bufferBeginIndexes[0] = 0;
    }

    @Override
    public FilterParserInput init() {
        super.init();
        return this;
    }

    @Override
    public FilterParserInput init(int startIndex, int stopIndex) {
        this.source.init(startIndex, stopIndex);
        this.bufferBeginIndexes[0] = this.source.getStartIndex();
        super.init(this.source.getStartIndex(), this.source.getStopIndex());
        return this;
    }

    public final TextParserInput getSource() {
        return this.source;
    }

    @Override
    protected int getSourceStartIndex() {
        return this.source.getSourceStartIndex();
    }

    @Override
    protected int getSourceLength() {
        return this.source.getSourceLength();
    }

    @Override
    protected @Nullable String getSourceString() {
        return this.source.getSourceString();
    }

    @Override
    protected int getSourceStringIndex() {
        return this.source.getSourceStringIndex();
    }

    @Override
    public final int getIndex(int offset) {
        int currentIdx = this.getIndexIdx();
        return this.bufferBeginIndexes[currentIdx + offset];
    }

    @Override
    public final int getLengthInSource(int offset) {
        if (offset == 0) {
            return 0;
        }
        int currentIdx = this.getIndexIdx();
        return this.bufferEndIndexes[currentIdx + offset - 1] - this.bufferBeginIndexes[currentIdx];
    }

    @Override
    public void consume(int offset) {
        if (offset == 0) {
            return;
        }
        int currentIdx = this.getIndexIdx();
        int lastOffset = this.getEndIdx() - currentIdx - 1;
        if (offset > lastOffset) {
            if (lastOffset > 16) {
                this.setConsume(lastOffset, this.bufferBeginIndexes[currentIdx + lastOffset]);
                currentIdx = this.getIndexIdx();
                offset -= lastOffset;
            }
            if (!this.updateBuffer(offset + 1)) {
                this.checkOffset(offset);
                int index = this.getStopIndex();
                if (index == Integer.MIN_VALUE) {
                    index = this.bufferBeginIndexes[this.getEndIdx()];
                }
                this.setConsume(offset, index);
                return;
            }
        }
        this.setConsume(offset, this.bufferBeginIndexes[currentIdx + offset]);
    }

    @Override
    protected void doUpdateBuffer(int index, char[] buffer, int requiredLength, int recommendLength) {
        int reused = this.copyBuffer0(buffer);
        int[] begins = buffer == this.getBuffer() ? this.bufferBeginIndexes : new int[buffer.length + 1];
        int[] ends = buffer == this.getBuffer() ? this.bufferEndIndexes : new int[buffer.length];
        int currentIdx = this.getIndexIdx();
        if (reused > 0) {
            System.arraycopy(this.bufferBeginIndexes, currentIdx, begins, 0, reused + 1);
            System.arraycopy(this.bufferEndIndexes, currentIdx, ends, 0, reused);
        } else {
            begins[0] = this.bufferBeginIndexes[currentIdx];
        }
        int end = this.read(this.source, buffer, begins, ends, reused, requiredLength, recommendLength);
        this.setBuffer(buffer, 0, end);
        this.bufferBeginIndexes = begins;
        this.bufferEndIndexes = ends;
        this.setConsume(0, this.bufferBeginIndexes[0]);
    }

    protected abstract int read(TextParserInput var1, char[] var2, int[] var3, int[] var4, int var5, int var6, int var7);
}

