/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core;

import java.util.ArrayList;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class DataBindingSubContext {
    private final DataBindingContext dbc;
    private final ArrayList<Binding> bindings;
    private final ArrayList<IObservable> observables;
    private final @Nullable IChangeListener listener;
    private boolean enabled = true;

    public DataBindingSubContext(DataBindingContext dbc, @Nullable IChangeListener listener) {
        this.dbc = dbc;
        this.bindings = new ArrayList(8);
        this.observables = new ArrayList(8);
        this.listener = listener;
    }

    public DataBindingSubContext(DataBindingContext dbc) {
        this(dbc, null);
    }

    public DataBindingContext getDataBindingContext() {
        return this.dbc;
    }

    public void run(Runnable runnable) {
        IListChangeListener<Binding> bindingsListener = new IListChangeListener<Binding>(){

            public void handleListChange(ListChangeEvent<? extends Binding> event) {
                ListDiffEntry[] listDiffEntryArray = event.diff.getDifferences();
                int n = listDiffEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ListDiffEntry diff = listDiffEntryArray[n2];
                    if (diff.isAddition()) {
                        DataBindingSubContext.this.addBinding((Binding)diff.getElement());
                    } else {
                        DataBindingSubContext.this.removeBinding((Binding)diff.getElement());
                    }
                    ++n2;
                }
            }
        };
        this.dbc.getBindings().addListChangeListener((IListChangeListener)bindingsListener);
        try {
            @NonNull IObservable[] observables = ObservableTracker.runAndCollect((Runnable)runnable);
            this.observables.ensureCapacity(this.observables.size() + observables.length);
            int i = 0;
            while (i < observables.length) {
                this.observables.add(observables[i]);
                ++i;
            }
        }
        finally {
            this.dbc.getBindings().removeListChangeListener((IListChangeListener)bindingsListener);
        }
    }

    protected void addBinding(Binding binding) {
        this.bindings.add(binding);
        if (this.listener != null) {
            binding.getTarget().addChangeListener(this.listener);
        }
    }

    protected void removeBinding(Binding binding) {
        this.bindings.add(binding);
        if (this.listener != null) {
            binding.getTarget().addChangeListener(this.listener);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            return;
        }
        this.enabled = enabled;
        if (this.enabled) {
            for (Binding binding : this.bindings) {
                this.dbc.addBinding(binding);
            }
        } else {
            for (Binding binding : this.bindings) {
                this.dbc.removeBinding(binding);
            }
        }
    }

    public void dispose() {
        for (Binding binding : this.bindings) {
            if (binding.isDisposed()) continue;
            binding.dispose();
        }
        this.bindings.clear();
        for (IObservable observable : this.observables) {
            if (observable.isDisposed()) continue;
            observable.dispose();
        }
        this.observables.clear();
    }
}

