/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupConfig;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguageManager;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.internal.docmlet.wikitext.core.WikitextCorePlugin;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.Nullable;

public class MarkupLanguageManager
implements WikitextMarkupLanguageManager {
    private static final String EXTENSION_POINT_ID = "org.eclipse.statet.docmlet.WikitextMarkupLanguages";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String LABEL_ATTRIBUTE_NAME = "label";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private static final String CONFIG_CLASS_ATTRIBUTE_NAME = "configClass";
    private static final String CONTENT_TYPE_ID_ATTRIBUTE_NAME = "contentTypeId";
    private static final String CONFIG_WORKBENCH_KEY = "MarkupConfig.Workbench.config";
    private List<String> names;
    private final Map<String, MLEntry> nameMap = new HashMap<String, MLEntry>();
    private final Map<String, MLEntry> contentTypeMap = new HashMap<String, MLEntry>();

    public MarkupLanguageManager() {
        this.readRegistry();
    }

    private void readRegistry() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("markupLanguage") && (name = element.getAttribute(NAME_ATTRIBUTE_NAME)) != null && !name.isEmpty()) {
                MLEntry mlEntry = new MLEntry(name, element);
                this.nameMap.put(mlEntry.getName(), mlEntry);
                if (mlEntry.getContentTypdId() != null) {
                    this.contentTypeMap.put(mlEntry.getContentTypdId(), mlEntry);
                }
            }
            ++n2;
        }
        Set<String> nameSet = this.nameMap.keySet();
        Object[] array = nameSet.toArray(new String[nameSet.size()]);
        Arrays.sort(array);
        this.names = ImCollections.newList((Object[])array);
    }

    @Override
    public List<String> getLanguageNames() {
        return this.names;
    }

    @Override
    public MLEntry getLanguageDescriptor(String name) {
        return this.nameMap.get(name);
    }

    @Override
    public WikitextMarkupLanguage getLanguage(String name) {
        MLEntry mlEntry = this.nameMap.get(name);
        return mlEntry != null ? mlEntry.getLanguage() : null;
    }

    @Override
    public WikitextMarkupLanguage getLanguage(IContentType contentType) {
        MLEntry mlEntry = this.contentTypeMap.get(contentType.getId());
        return mlEntry != null ? mlEntry.getLanguage() : null;
    }

    public String getLanguageName(IContentType contentType) {
        MLEntry mlEntry = this.contentTypeMap.get(contentType.getId());
        return mlEntry != null ? mlEntry.getName() : null;
    }

    protected MarkupConfig createNewConfig(String languageName) {
        MLEntry mlEntry = this.nameMap.get(languageName);
        return mlEntry != null ? mlEntry.newConfig() : null;
    }

    protected void configChanged(String languageName) {
    }

    protected final class MLEntry
    implements WikitextMarkupLanguageManager.WikitextMarkupLanguageDescriptor,
    IEclipsePreferences.IPreferenceChangeListener {
        private static final byte S_LANGUAGE_FAILED = 16;
        private static final byte S_CONFIG_FAILED = 32;
        private final String name;
        private final String label;
        private final String contentTypdId;
        private final IConfigurationElement element;
        private byte state;
        private final String prefQualifier;
        private volatile WikitextMarkupLanguage mlInstance;

        public MLEntry(String name, IConfigurationElement element) {
            this.name = name.intern();
            String value = element.getAttribute(MarkupLanguageManager.LABEL_ATTRIBUTE_NAME);
            this.label = value != null && !value.isEmpty() ? value.intern() : this.name;
            value = element.getAttribute(MarkupLanguageManager.CONTENT_TYPE_ID_ATTRIBUTE_NAME);
            this.contentTypdId = value != null && !value.isEmpty() ? value.intern() : null;
            this.element = element;
            String pluginId = this.element.getContributor().getName();
            this.prefQualifier = String.valueOf(pluginId) + "/markup/" + name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IContributor getContributor() {
            return this.element.getContributor();
        }

        @Override
        public String getPreferenceQualifier() {
            return this.prefQualifier;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        public String getContentTypdId() {
            return this.contentTypdId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WikitextMarkupLanguage getLanguage() {
            WikitextMarkupLanguage markupLanguage = this.mlInstance;
            if (markupLanguage == null) {
                MLEntry mLEntry = this;
                synchronized (mLEntry) {
                    block9: {
                        markupLanguage = this.mlInstance;
                        if (markupLanguage != null || (this.state & 0x10) != 0) break block9;
                        try {
                            markupLanguage = (WikitextMarkupLanguage)this.element.createExecutableExtension(MarkupLanguageManager.CLASS_ATTRIBUTE_NAME);
                            if (!this.getName().equals(markupLanguage.getName())) {
                                throw new IllegalArgumentException(MarkupLanguageManager.NAME_ATTRIBUTE_NAME);
                            }
                            MarkupConfig config = this.loadWorkbenchConfig();
                            if (config != null) {
                                markupLanguage.setMarkupConfig(config);
                            }
                            this.mlInstance = markupLanguage;
                        }
                        catch (CoreException e) {
                            this.state = (byte)(this.state | 0x10);
                            WikitextCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.core", NLS.bind((String)"An error occurred when loading markup language ''{0}''.", (Object)this.getName()), (Throwable)e));
                            return null;
                        }
                    }
                }
            }
            return markupLanguage;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        protected MarkupConfig loadWorkbenchConfig() {
            if (this.prefQualifier == null) {
                return null;
            }
            MarkupConfig config = this.newConfig();
            if (config == null) {
                return null;
            }
            PreferenceAccess prefs = PreferenceUtils.getInstancePrefs();
            prefs.addPreferenceNodeListener(this.prefQualifier, (IEclipsePreferences.IPreferenceChangeListener)this);
            // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable Preference.NullableStringPref pref = new Preference.NullableStringPref(this.prefQualifier, MarkupLanguageManager.CONFIG_WORKBENCH_KEY);
            String configString = (String)prefs.getPreferenceValue((Preference)pref);
            if (configString != null) {
                config.load(configString);
            }
            return config;
        }

        @Override
        public boolean isConfigSupported() {
            return this.element.getAttribute(MarkupLanguageManager.CONFIG_CLASS_ATTRIBUTE_NAME) != null && (this.state & 0x20) == 0;
        }

        @Override
        public MarkupConfig newConfig() {
            if (this.isConfigSupported()) {
                try {
                    return (MarkupConfig)this.element.createExecutableExtension(MarkupLanguageManager.CONFIG_CLASS_ATTRIBUTE_NAME);
                }
                catch (CoreException e) {
                    this.state = (byte)(this.state | 0x20);
                    WikitextCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.core", NLS.bind((String)"An error occurred when loading markup language ''{0}''.", (Object)this.getName()), (Throwable)e));
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals(MarkupLanguageManager.CONFIG_WORKBENCH_KEY)) {
                MLEntry mLEntry = this;
                synchronized (mLEntry) {
                    this.mlInstance.setMarkupConfig(this.loadWorkbenchConfig());
                }
                MarkupLanguageManager.this.configChanged(this.name);
            }
        }
    }
}

