/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.statet.internal.rhelp.core.REnvHelpImpl;
import org.eclipse.statet.internal.rhelp.core.RHelpManagerIntern;
import org.eclipse.statet.internal.rhelp.core.server.JettyServerClientSupport;
import org.eclipse.statet.internal.rhelp.core.server.ServerClientSupport;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpSearchQuery;
import org.eclipse.statet.rhelp.core.RHelpSearchRequestor;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvManager;

@NonNullByDefault
public class RHelpManager
extends RHelpManagerIntern {
    private ScheduledExecutorService serverUpdateExecutor;

    public RHelpManager(REnvManager rEnvManager) {
        super(rEnvManager);
        super.checkREnvs();
    }

    protected void onREnvChanged() {
        super.checkREnvs();
    }

    public List<REnv> getREnvWithHelp() {
        return super.getREnvWithHelpIntern();
    }

    public boolean hasHelp(@Nullable REnv rEnv) {
        if (rEnv != null && (rEnv = rEnv.resolve()) != null) {
            return super.hasHelpIntern(rEnv);
        }
        return false;
    }

    public @Nullable REnvHelp getHelp(@Nullable REnv rEnv) {
        if (rEnv != null && (rEnv = rEnv.resolve()) != null) {
            return super.getHelpIntern(rEnv);
        }
        return null;
    }

    public REnvHelp getHelpChecked(@Nullable REnv rEnv) throws StatusException {
        REnvHelpConfiguration rEnvConfig;
        REnvHelp help = this.getHelp(rEnv);
        if (help != null) {
            return help;
        }
        if (rEnv == null || (rEnvConfig = (REnvHelpConfiguration)rEnv.get(REnvHelpConfiguration.class)) == null) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "The specified R environment does not exists.", null));
        }
        if (rEnvConfig.getStateSharedType() == "server") {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("The remote R help of the specified R environment '%1$s' is not available.", rEnv.getName())));
        }
        throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("The R help of the specified R environment '%1$s' is not yet indexed. Please run the indexer first to enable R help support.", rEnv.getName())));
    }

    public void search(RHelpSearchQuery query, RHelpSearchRequestor requestor, ProgressMonitor m) throws StatusException {
        if (query == null) {
            throw new NullPointerException("query");
        }
        if (requestor == null) {
            throw new NullPointerException("requestor");
        }
        query.validate();
        REnvHelpImpl help = (REnvHelpImpl)this.getHelpChecked(query.getREnv());
        try {
            help.search(query, requestor);
        }
        finally {
            help.unlock();
        }
    }

    protected void initServerSupport(String type) {
        if (type != "jetty") {
            throw new UnsupportedOperationException("type= " + type);
        }
        ServerClientSupport.init(new JettyServerClientSupport());
        this.serverUpdateExecutor = Executors.newSingleThreadScheduledExecutor();
        this.serverUpdateExecutor.scheduleAtFixedRate(() -> this.updateServerHelp(), 5L, 60L, TimeUnit.SECONDS);
    }
}

