/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.data.impl.DefaultRObjectFactory;
import org.eclipse.statet.rj.services.FQRObject;
import org.eclipse.statet.rj.services.FQRObjectRef;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;

@NonNullByDefault
public class RObjectAdapter<TRObject extends RObject> {
    protected static final String API_R_PREFIX = "rj:::sda002";
    private final byte objectType;

    protected static void addXRef(FunctionCall fcall, FQRObjectRef ref) {
        fcall.add("x.env", ref.getEnv());
        fcall.add("x.expr", (RObject)DefaultRObjectFactory.INSTANCE.createExpression("x.env$" + ((RLanguage)ref.getName()).getSource()));
    }

    public RObjectAdapter(byte objectType) {
        this.objectType = objectType;
    }

    public TRObject loadObject(FQRObjectRef ref, RObject referenceObject, LazyRStore.Fragment<TRObject> fragment, RService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        RObject object;
        if (((RLanguage)ref.getName()).getLanguageType() == 1) {
            FQRObject fqrObject = r.findData(((RLanguage)ref.getName()).getSource(), ref.getEnv(), false, null, this.getLoadOptions(), -1, m);
            object = fqrObject != null ? fqrObject.getObject() : null;
        } else {
            FunctionCall fcall = r.createFunctionCall(this.getLoadObjectFName());
            RObjectAdapter.addXRef(fcall, ref);
            object = fcall.evalData(null, this.getLoadOptions(), -1, m);
        }
        return this.validateObject(object, referenceObject, fragment);
    }

    protected String getLoadObjectFName() {
        return "rj:::sda002.getObject";
    }

    protected int getLoadOptions() {
        return 4;
    }

    protected TRObject validateObject(@Nullable RObject rObject, RObject referenceObject, LazyRStore.Fragment<TRObject> fragment) throws UnexpectedRDataException {
        return (TRObject)RDataUtils.checkType((RObject)rObject, (byte)this.objectType);
    }
}

