/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core.conversion;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ChainedConverter<TFrom, TTo>
implements IConverter<TFrom, TTo> {
    private final @Nullable Object fromType;
    private final @Nullable Object toType;
    private final ImList<IConverter> converters;

    public ChainedConverter(ImList<IConverter> converters) {
        if (converters.isEmpty()) {
            throw new IllegalArgumentException("converters.size= 0");
        }
        this.converters = converters;
        this.fromType = ((IConverter)converters.get(0)).getFromType();
        this.toType = ((IConverter)converters.get(converters.size() - 1)).getToType();
    }

    public @Nullable Object getFromType() {
        return this.fromType;
    }

    public @Nullable Object getToType() {
        return this.toType;
    }

    @NonNullByDefault(value={})
    public TTo convert(TFrom fromObject) {
        Object o = fromObject;
        for (IConverter converter : this.converters) {
            o = converter.convert(o);
        }
        return (TTo)o;
    }
}

