/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCore;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupConfig;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguageManager1;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocWorkspaceSourceUnit;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceUnit;
import org.eclipse.statet.docmlet.wikitext.ui.config.MarkupConfigUIAdapter;
import org.eclipse.statet.docmlet.wikitext.ui.editors.WikidocEditor;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.statushandlers.StatusManager;

public class ConfigureMarkupHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = WorkbenchUIUtils.getActivePart((Object)event.getApplicationContext());
        WikitextSourceUnit su = null;
        if (activePart instanceof WikidocEditor) {
            WikidocEditor editor = (WikidocEditor)activePart;
            su = editor.getSourceUnit();
        }
        if (!(su instanceof WikidocWorkspaceSourceUnit)) {
            MessageDialog.openInformation((Shell)this.getShell(activePart), (String)"Configure Markup", (String)"The operation only supported for Wikitext documents in the workspace.");
            return null;
        }
        IFile file = (IFile)su.getResource();
        WikitextMarkupLanguageManager1 markupLanguageManager = WikitextCore.getMarkupLanguageManager();
        WikitextMarkupLanguage activeLanguage = markupLanguageManager.getLanguage(file, null, true);
        if (activeLanguage != null) {
            MarkupConfig config;
            MarkupConfigUIAdapter ui;
            MarkupConfig activeConfig = activeLanguage.getMarkupConfig();
            MarkupConfig fileConfig = markupLanguageManager.getConfig(file, null);
            MarkupConfigUIAdapter markupConfigUIAdapter = ui = activeConfig != null ? (MarkupConfigUIAdapter)Platform.getAdapterManager().loadAdapter((Object)activeConfig, MarkupConfigUIAdapter.class.getName()) : null;
            if (ui == null) {
                MessageDialog.openInformation((Shell)this.getShell(activePart), (String)"Configure Markup", (String)NLS.bind((String)"The operation is not supported for {0}.", (Object)activeLanguage.getName()));
                return null;
            }
            AtomicBoolean enabled = new AtomicBoolean(fileConfig != null);
            if (ui.edit("document", enabled, config = activeConfig.clone(), this.getShell(activePart))) {
                try {
                    activePart.getSite().getWorkbenchWindow().run(true, true, (IRunnableWithProgress)new ApplyRunnable((WikidocWorkspaceSourceUnit)su, (MarkupConfig)(enabled.get() ? config : null)));
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.ui", "An error occurred when setting markup configuration.", (Throwable)e));
                }
            }
        }
        return null;
    }

    protected Shell getShell(IWorkbenchPart part) {
        IWorkbenchPartSite site;
        if (part != null && (site = part.getSite()) != null) {
            return site.getShell();
        }
        return null;
    }

    private static class ApplyRunnable
    implements IRunnableWithProgress {
        private final WikidocWorkspaceSourceUnit sourceUnit;
        private final MarkupConfig markupConfig;

        public ApplyRunnable(WikidocWorkspaceSourceUnit su, MarkupConfig markupConfig) {
            this.sourceUnit = su;
            this.markupConfig = markupConfig;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)"Applying markup configuration...", (int)20);
            try {
                IFile file = (IFile)this.sourceUnit.getResource();
                WikitextCore.getMarkupLanguageManager().setConfig(file, this.markupConfig);
                m.worked(20);
            }
            finally {
                m.done();
            }
        }
    }
}

