/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.docmlet.wikitext.core.ast.ContainerNode;
import org.eclipse.statet.docmlet.wikitext.core.ast.Label;
import org.eclipse.statet.docmlet.wikitext.core.ast.NodeType;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstVisitor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;

@NonNullByDefault
public abstract class Link
extends ContainerNode {
    public static final byte COMMON = 0;
    public static final byte LINK_REF_DEFINITION = 1;
    public static final byte LINK_BY_REF = 2;
    private final byte linkType;
    private final @Nullable String uri;
    private final @Nullable String title;

    private Link(WikitextAstNode parent, int startOffset, int endOffset, byte linkType, @Nullable String uri, @Nullable String title) {
        super(parent, startOffset, endOffset);
        this.linkType = linkType;
        this.uri = uri;
        this.title = title;
    }

    private Link(WikitextAstNode parent, int startOffset, String uri, @Nullable String title) {
        super(parent, startOffset, startOffset);
        this.linkType = 0;
        this.uri = uri;
        this.title = title;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LINK;
    }

    @Override
    public void acceptInWikitext(WikitextAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    public byte getLinkType() {
        return this.linkType;
    }

    public @Nullable String getUri() {
        return this.uri;
    }

    public @Nullable String getTitle() {
        return this.title;
    }

    public abstract Label getReferenceLabel();

    /* synthetic */ Link(WikitextAstNode wikitextAstNode, int n, int n2, byte by, String string, String string2, Link link) {
        this(wikitextAstNode, n, n2, by, string, string2);
    }

    static final class Common
    extends Link {
        Common(WikitextAstNode parent, int startOffset, int endOffset, byte linkType, String href, @Nullable String title) {
            super(parent, startOffset, endOffset, linkType, href, title, null);
        }

        @Override
        public @Nullable Label getReferenceLabel() {
            return null;
        }
    }

    static final class Ref
    extends Link {
        private final Label referenceLabel;

        Ref(WikitextAstNode parent, int startOffset, int endOffset, byte linkType, Label referenceLabel, String url, @Nullable String title) {
            super(parent, startOffset, endOffset, linkType, url, title, null);
            referenceLabel.parent = this;
            this.referenceLabel = (Label)((Object)ObjectUtils.nonNullAssert((Object)((Object)referenceLabel)));
        }

        Ref(WikitextAstNode parent, int startOffset, int endOffset, byte linkType, Label referenceLabel) {
            super(parent, startOffset, endOffset, linkType, null, null, null);
            referenceLabel.parent = this;
            this.referenceLabel = (Label)((Object)ObjectUtils.nonNullAssert((Object)((Object)referenceLabel)));
        }

        @Override
        public boolean hasChildren() {
            return true;
        }

        @Override
        public int getChildCount() {
            return this.children.length + 1;
        }

        @Override
        public WikitextAstNode getChild(int index) {
            if (index == 0) {
                return this.referenceLabel;
            }
            return this.children[index - 1];
        }

        @Override
        public int getChildIndex(AstNode element) {
            if (this.referenceLabel == element) {
                return 0;
            }
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i] == element) {
                    return i + 1;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public Label getReferenceLabel() {
            return this.referenceLabel;
        }

        @Override
        public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
            this.referenceLabel.accept(visitor);
            WikitextAstNode[] wikitextAstNodeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                WikitextAstNode child = wikitextAstNodeArray[n2];
                child.accept(visitor);
                ++n2;
            }
        }

        @Override
        public void acceptInWikitextChildren(WikitextAstVisitor visitor) throws InvocationTargetException {
            this.referenceLabel.acceptInWikitext(visitor);
            WikitextAstNode[] wikitextAstNodeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                WikitextAstNode child = wikitextAstNodeArray[n2];
                child.acceptInWikitext(visitor);
                ++n2;
            }
        }
    }
}

