/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.config;

import java.util.HashMap;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.docmlet.tex.core.TexCodeStyleSettings;
import org.eclipse.statet.ecommons.databinding.core.validation.IntegerValidator;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.text.ui.settings.IndentSettingsUI;
import org.eclipse.statet.ecommons.ui.CombineStatusChangeListener;
import org.eclipse.statet.ecommons.ui.components.EditableTextList;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.docmlet.tex.ui.config.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TexCodeStylePreferenceBlock
extends ManagedConfigurationBlock {
    private TexCodeStyleSettings model;
    private IndentSettingsUI stdIndentSettings;
    private Text indentBlockDepthControl;
    private Text indentEnvDepthControl;
    private EditableTextList indentEnvLabelsControl;
    private final CombineStatusChangeListener statusListener;

    public TexCodeStylePreferenceBlock(IProject project, StatusChangeListener statusListener) {
        super(project);
        this.statusListener = new CombineStatusChangeListener(statusListener);
        this.setStatusListener((StatusChangeListener)this.statusListener);
    }

    protected void createBlockArea(Composite pageComposite) {
        HashMap<Object, String> prefs = new HashMap<Object, String>();
        prefs.put(TexCodeStyleSettings.TAB_SIZE_PREF, "tex/tex.codestyle/indent");
        prefs.put(TexCodeStyleSettings.INDENT_DEFAULT_TYPE_PREF, "tex/tex.codestyle/indent");
        prefs.put(TexCodeStyleSettings.INDENT_SPACES_COUNT_PREF, "tex/tex.codestyle/indent");
        prefs.put(TexCodeStyleSettings.REPLACE_CONVERSATIVE_PREF, "tex/tex.codestyle/indent");
        prefs.put(TexCodeStyleSettings.REPLACE_TABS_WITH_SPACES_PREF, "tex/tex.codestyle/indent");
        prefs.put(TexCodeStyleSettings.INDENT_BLOCK_DEPTH_PREF, "tex/tex.codestyle/indent");
        prefs.put(TexCodeStyleSettings.INDENT_ENV_DEPTH_PREF, "tex/tex.codestyle/indent");
        prefs.put(TexCodeStyleSettings.INDENT_ENV_LABELS_PREF, "tex/tex.codestyle/indent");
        this.setupPreferenceManager(prefs);
        this.model = new TexCodeStyleSettings(0);
        this.stdIndentSettings = new IndentSettingsUI();
        Composite mainComposite = new Composite(pageComposite, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        TabFolder folder = new TabFolder(mainComposite, 0);
        folder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TabItem item = new TabItem(folder, 0);
        item.setText(this.stdIndentSettings.getGroupLabel());
        item.setControl(this.createIndentControls((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText("&Line Wrapping");
        item.setControl(this.createLineControls((Composite)folder));
        this.initBindings();
        this.updateControls();
    }

    private Control createIndentControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newTabGrid((int)2));
        this.stdIndentSettings.createControls(composite);
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        Composite depthComposite = new Composite(composite, 0);
        depthComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        depthComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)4));
        this.indentBlockDepthControl = this.createIndentDepthLine(depthComposite, Messages.CodeStyle_Indent_IndentInBlocks_label);
        this.indentEnvDepthControl = this.createIndentDepthLine(depthComposite, Messages.CodeStyle_Indent_IndentInEnvs_label);
        Label label = new Label(depthComposite, 0);
        GridData gd = new GridData(4, 0x1000000, true, false, 4, 1);
        gd.horizontalIndent = LayoutUtils.defaultIndent();
        label.setLayoutData((Object)gd);
        label.setText("Environments to be indented:");
        this.indentEnvLabelsControl = new EditableTextList();
        Control control = this.indentEnvLabelsControl.create(depthComposite, new ViewerComparator());
        gd = new GridData(4, 4, false, true, 3, 1);
        gd.horizontalIndent = LayoutUtils.defaultIndent();
        control.setLayoutData((Object)gd);
        LayoutUtils.addGDDummy((Composite)depthComposite, (boolean)true);
        this.indentEnvLabelsControl.getColumn().setEditingSupport((EditingSupport)new LabelEditing(this.indentEnvLabelsControl));
        LayoutUtils.addSmallFiller((Composite)depthComposite, (boolean)false);
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        return composite;
    }

    private Text createIndentDepthLine(Composite composite, String label) {
        Label labelControl = new Label(composite, 16384);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Text textControl = new Text(composite, 133124);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)textControl, (int)2);
        textControl.setLayoutData((Object)gd);
        Label typeControl = new Label(composite, 16384);
        typeControl.setText(this.stdIndentSettings.getLevelUnitLabel());
        typeControl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        LayoutUtils.addGDDummy((Composite)composite);
        return textControl;
    }

    private Control createLineControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newTabGrid((int)2));
        this.stdIndentSettings.addLineWidth(composite);
        return composite;
    }

    protected void addBindings(DataBindingSupport db) {
        this.stdIndentSettings.addBindings(db, (Object)this.model);
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.indentBlockDepthControl), BeanProperties.value((String)"indentBlockDepth", Integer.TYPE).observe(db.getRealm(), (Object)this.model), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(1, 10, Messages.CodeStyle_Indent_IndentInBlocks_error_message)), null);
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.indentEnvDepthControl), BeanProperties.value((String)"indentEnvDepth", Integer.TYPE).observe(db.getRealm(), (Object)this.model), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(1, 10, Messages.CodeStyle_Indent_IndentInEnvs_error_message)), null);
        WritableSet labels = new WritableSet(db.getRealm());
        this.indentEnvLabelsControl.setInput((IObservableCollection)labels);
        db.getContext().bindSet((IObservableSet)labels, BeanProperties.set((String)"indentEnvLabels", String.class).observe(db.getRealm(), (Object)this.model));
    }

    protected void updateControls() {
        this.model.load((PreferenceAccess)this);
        this.model.resetDirty();
        this.getDataBinding().getContext().updateTargets();
        this.indentEnvLabelsControl.refresh();
    }

    protected void updatePreferences() {
        if (this.model.isDirty()) {
            this.model.resetDirty();
            this.setPrefValues(this.model.toPreferencesMap());
        }
    }

    private class LabelEditing
    extends EditingSupport {
        private final TextCellEditor cellEditor;
        private final EditableTextList list;
        private Object last;
        private StatusChangeListener listener;

        public LabelEditing(EditableTextList list) {
            super((ColumnViewer)list.getViewer());
            this.list = list;
            this.cellEditor = new TextCellEditor((Composite)list.getViewer().getTable());
            this.cellEditor.addListener(new ICellEditorListener(){

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    if (LabelEditing.this.listener == null) {
                        LabelEditing.this.listener = TexCodeStylePreferenceBlock.this.statusListener.newListener();
                    }
                    if (!newValidState) {
                        LabelEditing.this.listener.statusChanged((IStatus)new Status(4, "org.eclipse.statet.docmlet.tex.ui", LabelEditing.this.cellEditor.getErrorMessage()));
                    } else {
                        LabelEditing.this.listener.statusChanged(Status.OK_STATUS);
                    }
                }

                public void applyEditorValue() {
                    LabelEditing.this.last = null;
                    if (LabelEditing.this.listener != null) {
                        TexCodeStylePreferenceBlock.this.statusListener.removeListener(LabelEditing.this.listener);
                        LabelEditing.this.listener = null;
                    }
                }

                public void cancelEditor() {
                    if (LabelEditing.this.last == "") {
                        LabelEditing.this.list.applyChange((Object)"", null);
                    }
                    if (LabelEditing.this.listener != null) {
                        TexCodeStylePreferenceBlock.this.statusListener.removeListener(LabelEditing.this.listener);
                        LabelEditing.this.listener = null;
                    }
                }
            });
            this.cellEditor.setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    String s = (String)value;
                    int i = 0;
                    while (i < s.length()) {
                        char c = s.charAt(i);
                        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '*' && i == s.length() - 1)) {
                            return "Invalid environment name";
                        }
                        ++i;
                    }
                    return null;
                }
            });
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Object getValue(Object element) {
            this.last = element;
            return element;
        }

        protected void setValue(Object element, Object value) {
            if (value != null) {
                this.list.applyChange(element, value != "" ? value : null);
            }
        }
    }
}

