/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.debug.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.statet.internal.r.debug.core.breakpoints.RExceptionBreakpoint;
import org.eclipse.statet.internal.r.debug.core.breakpoints.RLineBreakpoint;
import org.eclipse.statet.internal.r.debug.core.breakpoints.RMethodBreakpoint;
import org.eclipse.statet.internal.r.debug.core.eval.REvaluationExpression;
import org.eclipse.statet.internal.r.debug.core.eval.REvaluationResult;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTarget;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.debug.core.IRDebugTarget;
import org.eclipse.statet.r.debug.core.IREvaluationResult;
import org.eclipse.statet.r.debug.core.breakpoints.IRExceptionBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.IRLineBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.IRMethodBreakpoint;
import org.eclipse.statet.r.nico.AbstractRDbgController;

@NonNullByDefault
public class RDebugModel {
    public static final String IDENTIFIER = "org.eclipse.statet.r.debugModels.R";
    public static final String R_LINE_BREAKPOINT_TYPE_ID = "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint";
    public static final String R_METHOD_BREAKPOINT_TYPE_ID = "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint";
    public static final String R_EXCEPTION_BREAKPOINT_TYPE_ID = "org.eclipse.statet.r.debugBreakpoints.RExceptionBreakpoint";
    private static final List<IRLineBreakpoint> NO_R_LINE_BREAKPOINTS = Collections.emptyList();

    public static IRLineBreakpoint createLineBreakpoint(IFile resource, int lineNumber, int charStart, int charEnd, int elementType, String elementId, String elementLabel, String subLabel, boolean temporary) throws CoreException {
        return new RLineBreakpoint((IResource)resource, lineNumber, charStart, charEnd, elementType, elementId, elementLabel, subLabel, temporary);
    }

    public static IRMethodBreakpoint createMethodBreakpoint(IFile resource, int lineNumber, int charStart, int charEnd, int elementType, String elementId, String elementLabel, String subLabel, boolean temporary) throws CoreException {
        return new RMethodBreakpoint((IResource)resource, lineNumber, charStart, charEnd, elementType, elementId, elementLabel, subLabel, temporary);
    }

    public static IRExceptionBreakpoint createExceptionBreakpoint(String exceptionId, boolean temporary) throws CoreException {
        if (exceptionId == null) {
            throw new NullPointerException("exceptionId");
        }
        return new RExceptionBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), exceptionId, temporary);
    }

    public static List<IRLineBreakpoint> getLineBreakpoints(IFile file) throws CoreException {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(IDENTIFIER);
        List<IRLineBreakpoint> matches = null;
        int i = 0;
        while (i < breakpoints.length) {
            IRLineBreakpoint breakpoint;
            IMarker marker;
            if (breakpoints[i] instanceof IRLineBreakpoint && (marker = (breakpoint = (IRLineBreakpoint)breakpoints[i]).getMarker()) != null && marker.exists() && file.equals((Object)marker.getResource())) {
                if (matches == null) {
                    matches = new ArrayList<IRLineBreakpoint>(4);
                }
                matches.add(breakpoint);
            }
            ++i;
        }
        return matches != null ? matches : NO_R_LINE_BREAKPOINTS;
    }

    public static List<IRLineBreakpoint> getLineBreakpoints(IFile file, int lineNumber) throws CoreException {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(IDENTIFIER);
        List<IRLineBreakpoint> matches = null;
        int i = 0;
        while (i < breakpoints.length) {
            IRLineBreakpoint breakpoint;
            IMarker marker;
            if (breakpoints[i] instanceof IRLineBreakpoint && (marker = (breakpoint = (IRLineBreakpoint)breakpoints[i]).getMarker()) != null && marker.exists() && file.equals((Object)marker.getResource()) && lineNumber == breakpoint.getLineNumber()) {
                if (matches == null) {
                    matches = new ArrayList<IRLineBreakpoint>(4);
                }
                matches.add(breakpoint);
            }
            ++i;
        }
        return matches != null ? matches : NO_R_LINE_BREAKPOINTS;
    }

    public static @Nullable IRExceptionBreakpoint getExpressionBreakpoint(String expressionId) throws DebugException {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(IDENTIFIER);
        int i = 0;
        while (i < breakpoints.length) {
            IRExceptionBreakpoint breakpoint;
            if (breakpoints[i] instanceof IRExceptionBreakpoint && (breakpoint = (IRExceptionBreakpoint)breakpoints[i]).getExceptionId().equals(expressionId)) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static IErrorReportingExpression createExpression(IREvaluationResult result) {
        return new REvaluationExpression((REvaluationResult)result);
    }

    public static IRDebugTarget createRDebugTarget(AbstractRDbgController controller) {
        return new RDebugTarget(controller);
    }
}

