/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.io.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.io.internal.Messages;

public class EFSUtilImpl
extends FileUtil {
    private static final String LABEL_2_LOCALFILE = "' (" + Messages.FileType_Local_name + ")";
    private final IFileStore fFile;

    public EFSUtilImpl(IFileStore file) {
        this.fFile = file;
    }

    @Override
    public String getLabel() {
        IFileSystem system = this.fFile.getFileSystem();
        if (system.equals(EFS.getLocalFileSystem())) {
            return "'" + this.fFile.toString() + LABEL_2_LOCALFILE;
        }
        return "'" + this.fFile.toURI().toString() + "'";
    }

    @Override
    public URI getURI() {
        return this.fFile.toURI();
    }

    @Override
    public long getTimeStamp(IProgressMonitor monitor) throws CoreException {
        return this.fFile.fetchInfo(0, monitor).getLastModified();
    }

    @Override
    public FileUtil.ReadTextFileOperation createReadTextFileOp(final FileUtil.ReaderAction action) {
        return new FileUtil.ReadTextFileOperation(this){

            @Override
            protected FileUtil.FileInput getInput(IProgressMonitor monitor) throws CoreException, IOException {
                try {
                    InputStream raw = EFSUtilImpl.this.fFile.openInputStream(0, monitor);
                    FileUtil.FileInput fileInput = new FileUtil.FileInput(raw, null);
                    return fileInput;
                }
                finally {
                    monitor.done();
                }
            }

            @Override
            protected FileUtil.ReaderAction getAction() {
                return action;
            }
        };
    }

    @Override
    public FileUtil.WriteTextFileOperation createWriteTextFileOp(final String content) {
        return new FileUtil.WriteTextFileOperation(this){

            @Override
            protected void writeImpl(IProgressMonitor monitor) throws CoreException, IOException {
                OutputStreamWriter out = null;
                try {
                    block11: {
                        boolean exists = EFSUtilImpl.this.fFile.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 5)).exists();
                        if (exists && (this.fMode & 3) == 0) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", 0, NLS.bind((String)Messages.Resource_error_AlreadyExists_message, (Object)(" " + EFSUtilImpl.this.getLabel() + " ")), null));
                        }
                        if (exists && (this.fMode & 1) != 0 && !this.fForceCharset) {
                            try {
                                try {
                                    InputStream raw = EFSUtilImpl.this.fFile.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                                    FileUtil.FileInput fi = new FileUtil.FileInput(raw, null);
                                    fi.close();
                                    String defaultCharset = fi.getDefaultCharset();
                                    if (defaultCharset != null) {
                                        this.fCharset = defaultCharset;
                                    }
                                }
                                catch (IOException iOException) {
                                    monitor.worked(5);
                                    break block11;
                                }
                            }
                            catch (Throwable throwable) {
                                monitor.worked(5);
                                throw throwable;
                            }
                            monitor.worked(5);
                        } else {
                            monitor.worked(10);
                        }
                    }
                    out = new OutputStreamWriter(EFSUtilImpl.this.fFile.openOutputStream(this.fMode, (IProgressMonitor)new SubProgressMonitor(monitor, 5)), this.fCharset);
                    out.write(content);
                    monitor.worked(75);
                    ((Writer)out).flush();
                }
                catch (Throwable throwable) {
                    EFSUtilImpl.saveClose(out);
                    throw throwable;
                }
                EFSUtilImpl.saveClose(out);
            }
        };
    }
}

