/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.statet.internal.r.core.sourcemodel.BuildSourceFrame;
import org.eclipse.statet.internal.r.core.sourcemodel.EmbeddedRBuildElement;
import org.eclipse.statet.internal.r.core.sourcemodel.RSourceFileElement;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.r.core.model.RCompositeSourceElement;
import org.eclipse.statet.r.core.model.RLangSourceElement;
import org.eclipse.statet.r.core.model.RSourceUnit;

@NonNullByDefault
public class CompositeSourceElement
extends RSourceFileElement
implements RCompositeSourceElement {
    private final ImList<? extends EmbeddedRBuildElement> compositeElements;
    private final TextRegion sourceRange;
    private volatile @Nullable List<RLangSourceElement> allSourceChildren;

    public CompositeSourceElement(RSourceUnit su, BuildSourceFrame envir, List<? extends EmbeddedRBuildElement> elements, TextRegion sourceRange) {
        super(su, envir);
        this.compositeElements = ImCollections.toList(elements);
        this.sourceRange = sourceRange;
    }

    public ImList<? extends RLangSourceElement> getCompositeElements() {
        return this.compositeElements;
    }

    public TextRegion getSourceRange() {
        return this.sourceRange;
    }

    @Override
    public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
        for (EmbeddedRBuildElement element : this.compositeElements) {
            if (!element.hasSourceChildren(filter)) continue;
            return true;
        }
        return false;
    }

    public List<RLangSourceElement> getSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
        if (filter == null) {
            ImList children = this.allSourceChildren;
            if (children == null) {
                Collection[] compositeLists = new List[this.compositeElements.size()];
                int i = 0;
                while (i < compositeLists.length) {
                    compositeLists[i] = ((EmbeddedRBuildElement)this.compositeElements.get(i)).getSourceChildren(null);
                    ++i;
                }
                this.allSourceChildren = children = ImCollections.concatList((Collection[])compositeLists);
            }
            return children;
        }
        ArrayList<RLangSourceElement> children = new ArrayList<RLangSourceElement>();
        for (EmbeddedRBuildElement element : this.compositeElements) {
            List<? extends RLangSourceElement> list = element.getSourceChildren(null);
            for (RLangSourceElement child : list) {
                if (!filter.include((LtkModelElement)child)) continue;
                children.add(child);
            }
        }
        return children;
    }
}

