/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.persistence.IPersistable;
import org.eclipse.statet.ecommons.waltable.sort.ISortModel;
import org.eclipse.statet.ecommons.waltable.sort.SortDirection;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;

public class SortStatePersistor<T>
implements IPersistable {
    public static final String PERSISTENCE_KEY_SORTING_STATE = ".SortHeaderLayer.sortingState";
    private final ISortModel sortModel;

    public SortStatePersistor(ISortModel sortModel) {
        this.sortModel = sortModel;
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        StringBuilder buffer = new StringBuilder();
        for (long id : this.sortModel.getSortedColumnIds()) {
            SortDirection sortDirection = this.sortModel.getSortDirection(id);
            long sortOrder = this.sortModel.getSortOrder(id);
            buffer.append(id);
            buffer.append(":");
            buffer.append(sortDirection.toString());
            buffer.append(":");
            buffer.append(sortOrder);
            buffer.append("|");
        }
        if (buffer.length() > 0) {
            properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_SORTING_STATE, buffer.toString());
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.sortModel.clear();
        Object savedValue = properties.get(String.valueOf(prefix) + PERSISTENCE_KEY_SORTING_STATE);
        if (savedValue == null) {
            return;
        }
        try {
            String savedState = savedValue.toString();
            String[] sortedColumns = savedState.split("\\|");
            ArrayList<SortState> stateInfo = new ArrayList<SortState>();
            String[] stringArray = sortedColumns;
            int n = sortedColumns.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                stateInfo.add(this.getSortStateFromString(token));
                ++n2;
            }
            Collections.sort(stateInfo, new SortStateComparator());
            for (SortState state : stateInfo) {
                this.sortModel.sort(state.columnIndex, state.sortDirection, true);
            }
        }
        catch (Exception ex) {
            this.sortModel.clear();
            WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "Error while restoring sorting state: " + ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    protected SortState getSortStateFromString(String token) {
        String[] split = token.split(":");
        long columnIndex = Long.parseLong(split[0]);
        SortDirection sortDirection = SortDirection.valueOf(split[1]);
        int sortOrder = Integer.parseInt(split[2]);
        return new SortState(columnIndex, sortDirection, sortOrder);
    }

    protected class SortState {
        public long columnIndex;
        public SortDirection sortDirection;
        public int sortOrder;

        public SortState(long columnIndex, SortDirection sortDirection, int sortOrder) {
            this.columnIndex = columnIndex;
            this.sortDirection = sortDirection;
            this.sortOrder = sortOrder;
        }
    }

    private class SortStateComparator
    implements Comparator<SortState> {
        private SortStateComparator() {
        }

        @Override
        public int compare(SortState state1, SortState state2) {
            return Long.valueOf(state1.sortOrder).compareTo(Long.valueOf(state2.sortOrder));
        }
    }
}

