/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.source.EmbeddingAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.ExtdocMarkupLanguage;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockNode;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockType;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class HtmlBlock
extends SourceBlockType<HtmlBlockNode> {
    private static final String HTML_1_TAG_NAMES = "script|pre|style";
    private static final String HTML_BLOCK_TAG_NAMES = "address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|section|source|title|summary|table|tbody|td|tfoot|th|thead|tr|track|ul";
    private static final Pattern START_PATTERN = Pattern.compile("<(?:((?:(?i)script|pre|style)(?:[\\s>].*)?)|(!--.*)|(\\?.*)|(!\\p{Upper}+.*)|(!\\[CDATA\\[.*)|(/?(?:(?i)address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|section|source|title|summary|table|tbody|td|tfoot|th|thead|tr|track|ul)(?:(?:\\s|/?>).*)?)|(\\p{Alpha}[\\p{Alnum}-]*(?:\\s+[\\p{Alpha}_:][\\p{Alnum}_.:-]*(?:\\s*=\\s*(?:\"[^\"]*\"|'[^']*'|[^\\s\"'=><`]+))?)*\\s*/?>\\s*|/\\p{Alpha}[\\p{Alnum}-]*\\s*>\\s*))", 32);
    private static final Pattern END_HTML_1_PATTERN = Pattern.compile("</(?:(?i)script|pre|style)>", 32);
    private static final Pattern END_COMMENT_PATTERN = Pattern.compile("-->", 32);
    private static final Pattern END_PI_PATTERN = Pattern.compile("\\?>", 32);
    private static final Pattern END_DECL_PATTERN = Pattern.compile(">", 32);
    private static final Pattern END_CDATA_PATTERN = Pattern.compile("\\]\\]>", 32);
    private final Matcher startMatcher = START_PATTERN.matcher("");
    private @Nullable Matcher endHtml1Matcher;
    private @Nullable Matcher endCommentMatcher;
    private @Nullable Matcher endPIMatcher;
    private @Nullable Matcher endDeclMatcher;
    private @Nullable Matcher endCDATAMatcher;

    @Override
    public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockNode<?> currentNode) {
        Matcher matcher;
        Line currentLine = lineSequence.getCurrentLine();
        return currentLine != null && !currentLine.isBlank() && currentLine.getIndent() < 4 && (matcher = currentLine.setupIndent(this.startMatcher)).matches() && (currentNode == null || this.canInterrupt(matcher));
    }

    private boolean canInterrupt(Matcher matcher) {
        return matcher.start(7) == -1;
    }

    @Override
    public void createNodes(SourceBlocks.SourceBlockBuilder builder) {
        HtmlBlockNode htmlBlockNode = new HtmlBlockNode(this, builder);
        LineSequence lineSequence = builder.getLineSequence();
        Line startLine = lineSequence.getCurrentLine();
        Matcher matcher = startLine.setupIndent(this.startMatcher);
        HtmlBlock.assertMatches(matcher);
        htmlBlockNode.htmlType = this.getType(matcher);
        Matcher endMatcher = this.getEndMatcher(htmlBlockNode.htmlType);
        if (endMatcher != null) {
            Line line;
            while ((line = lineSequence.getCurrentLine()) != null) {
                lineSequence.advance();
                if (!line.setup(endMatcher).find()) continue;
                htmlBlockNode.isClosed = true;
                break;
            }
        } else {
            HtmlBlock.advanceNonBlankLines(lineSequence);
        }
    }

    @Override
    public void initializeContext(ProcessingContext context, HtmlBlockNode node) {
    }

    @Override
    public void emit(ProcessingContext context, HtmlBlockNode node, CommonmarkLocator locator, DocumentBuilder builder) {
        HtmlBlockNode htmlBlockNode = node;
        ImList<Line> lines = node.getLines();
        if (context.getMode() == 3) {
            int descr = htmlBlockNode.htmlType == 2 ? 129 : 1 | htmlBlockNode.htmlType << ExtdocMarkupLanguage.EMBEDDED_HTML_DISTINCT_SHIFT & 0x70;
            locator.setBlockBegin(node);
            builder.beginBlock(DocumentBuilder.BlockType.CODE, (Attributes)new EmbeddingAttributes("Html", descr));
        }
        for (Line line : lines) {
            locator.setLine(line);
            builder.charactersUnescaped(line.getText());
            builder.charactersUnescaped("\n");
        }
        if (context.getMode() == 3) {
            locator.setBlockEnd(node);
            builder.endBlock();
        }
    }

    private byte getType(Matcher matcher) {
        if (matcher.start(1) != -1) {
            return 1;
        }
        if (matcher.start(2) != -1) {
            return 2;
        }
        if (matcher.start(3) != -1) {
            return 3;
        }
        if (matcher.start(4) != -1) {
            return 4;
        }
        if (matcher.start(5) != -1) {
            return 5;
        }
        if (matcher.start(6) != -1) {
            return 6;
        }
        return 7;
    }

    private @Nullable Matcher getEndMatcher(byte type) {
        switch (type) {
            case 1: {
                if (this.endHtml1Matcher == null) {
                    this.endHtml1Matcher = END_HTML_1_PATTERN.matcher("");
                }
                return this.endHtml1Matcher;
            }
            case 2: {
                if (this.endCommentMatcher == null) {
                    this.endCommentMatcher = END_COMMENT_PATTERN.matcher("");
                }
                return this.endCommentMatcher;
            }
            case 3: {
                if (this.endPIMatcher == null) {
                    this.endPIMatcher = END_PI_PATTERN.matcher("");
                }
                return this.endPIMatcher;
            }
            case 4: {
                if (this.endDeclMatcher == null) {
                    this.endDeclMatcher = END_DECL_PATTERN.matcher("");
                }
                return this.endDeclMatcher;
            }
            case 5: {
                if (this.endCDATAMatcher == null) {
                    this.endCDATAMatcher = END_CDATA_PATTERN.matcher("");
                }
                return this.endCDATAMatcher;
            }
        }
        return null;
    }

    static final class HtmlBlockNode
    extends SourceBlockNode<HtmlBlock> {
        private byte htmlType;
        private boolean isClosed;

        private HtmlBlockNode(HtmlBlock type, SourceBlocks.SourceBlockBuilder builder) {
            super(type, builder);
        }
    }
}

